/* Custom XDoclet tag support for generating NDDP configuration files.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.config;

import java.util.Properties;
import xdoclet.XDocletTagSupport;

/**
 * Class providing custom XDoclet tag support for generating Kepler 
 * configuration files.  The methods below generate a sequence of 
 * unique Lsid values and are used by annotations_template.xdt and
 * nddpActors_template.xdt to annotate nddp actors automatically. 
 *      
 * @author Timothy M. McPhillips
 */

public class ActorOntologyTags extends XDocletTagSupport {

    public ActorOntologyTags() {
        super();
    }

	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 
	
    public String currentLsid(Properties attributes) {
        
        return _id(attributes.getProperty("delimiter"));
    }
    
    public String nextLsid(Properties attributes) {
        
        _incrementId();
        
        return _id(attributes.getProperty("delimiter"));
    }
    
    	public String setLsid(Properties attributes) {
        
        _setId(attributes.getProperty("id"));
        
        return "";
    }
    	
    	///////////////////////////////////////////////////////////////////
	////                         private methods                   ////

    	private String _id(String delimiter) {
    	    
    	    if (delimiter == null) {
    	        delimiter = ".";
    	    }
    	        
        return String.valueOf(_id) + delimiter + String.valueOf(_version);
    	}    	    
    	
    	private void _incrementId() {
    	    _id++;
    	}
    	
    	private void _setId(String idString) {
    	    
        try { 
            _id = Integer.parseInt(idString);
        } catch (NumberFormatException ex) {
        }
    }
    	
	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////
    	
    	private int _id = 0;
    	private int _version = 1;
}
