/* Handler class for Nexus assumptions blocks.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 package org.nddp.phylogeny;

import java.util.Map;

import org.nddp.CollectionManager;
import org.nddp.exceptions.ParseException;

import ptolemy.kernel.util.IllegalActionException;

class NexusAssumptionsBlockHandler extends NexusBlockHandler {
    
    public NexusAssumptionsBlockHandler(NexusBlock block, CollectionManager
        nexusFileCollectionManager) throws IllegalActionException {
        
		super(block, nexusFileCollectionManager);
    }

	///////////////////////////////////////////////////////////////////
	////                         protected methods                 ////

    	protected void _handleBlock() throws IllegalActionException, 
    		ParseException {

    	    _dispatchCommandHandlers();    
    	}
    	
   	{
        _nexusCommandHandlerMap.put("WTSET", new NexusCommandHandler() {
            
            public void handle(NexusCommand weightSetCommand) {
                
		    	    	// get the unparsed version of the command
		    	    	String commandString = weightSetCommand.toString();
		    	    
		    	    	// extract the value of the command which follows the equal sign
		    	    	int equalSignPosition = commandString.indexOf('=');
		         String valueString = commandString.substring(equalSignPosition + 1);
			
		    	    	// get the mapping between character indices and property values
				Map weightMap = 
				    NexusBlockHandler._parseCharacterPropertyList(valueString);
		
			    	// create a new weight set from the mapping
		    	    WeightVector weightSet = new WeightVector(weightMap);
		    	    
		    	    // add the weight set to the Nexus file collection
		    	    _nexusFileCollectionManager.addDomainObject(weightSet);
			}
        });
    }
}