/* Handler class for Nexus characters blocks.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 package org.nddp.phylogeny;

import java.util.Iterator;
import java.util.regex.Pattern;

import org.nddp.CollectionManager;
import org.nddp.exceptions.IndexOutOfBoundsException;

import ptolemy.kernel.util.IllegalActionException;

class NexusCharactersBlockHandler extends NexusBlockHandler {
    
    public NexusCharactersBlockHandler(NexusBlock block, CollectionManager
        nexusFileCollectionManager) throws IllegalActionException {
        
		super(block, nexusFileCollectionManager);        
    }
 
	///////////////////////////////////////////////////////////////////
	////                         protected methods                 ////

    protected void _handleBlock() throws IllegalActionException, 
    		IndexOutOfBoundsException {
	
    	    NexusCommand dimensionsCommand = _block.getCommand("DIMENSIONS");
    	    
    	    NexusCommand formatCommand = _block.getCommand("FORMAT");
    	    
    	    NexusCommand matrixCommand = _block.getCommand("MATRIX");
    	    
    	    NexusCommand characterDescriptions = 
    	        _block.getCommand("CHARSTATELABELS");
    	    
    	    int taxonCount = matrixCommand.argumentCount()/2;
    	    
    	    int characterCount = 
    	        Integer.parseInt(dimensionsCommand.getProperty("NCHAR"));
    	    
    	    CharacterMatrix matrix = 
    	        new CharacterMatrix(taxonCount, characterCount);

    	    matrix.setDataType(TaxonomicCharacter.MORPHOLOGICAL_DATA);
    	    
    	    matrix.setMissingSymbol(
    	            formatCommand.getProperty("MISSING").charAt(0));
    	    
    	    matrix.setGapSymbol(
    	            formatCommand.getProperty("GAP").charAt(0));
    	    
    	    int taxonIndex = 0;
    	    for (Iterator i = matrixCommand.argumentIterator(); 
    	    			i.hasNext(); i.next(), taxonIndex++) {
    	        
    	        String taxonName = (String) i.next();
    	        matrix.setTaxonName(taxonIndex, taxonName);
    	    }

    	    taxonIndex = 0;
    	    for (Iterator i = matrixCommand.argumentIterator(); 
    	    			i.hasNext(); taxonIndex++) {
    	        
    	        i.next();
    	        String characters = (String) i.next();
    	        matrix.addCharacterValues(taxonIndex, characters);
    	    }
    	    
    	    for (Iterator i = characterDescriptions.argumentIterator(); 
    	    			i.hasNext(); ) {
    	        
			int characterIndex = Integer.parseInt((String)i.next()) - 1;
			
			String characterDescription = (String)i.next();
			
			characterDescription = 
			    NEXUS_UNDERSCORE_PATTERN.matcher(
			            characterDescription).replaceAll(" ");
			
			matrix.setCharacterDescription(characterIndex,
			        characterDescription);
    	    }
    	    
    	    _nexusFileCollectionManager.addDomainObject(matrix);
	}

	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////	
    
    private static final Pattern NEXUS_UNDERSCORE_PATTERN = 
        Pattern.compile("_+");
}