/* Program runner for Phylip DNAMLK.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.phylogeny.phylip;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;

import org.nddp.exceptions.CollectionException;
import org.nddp.exceptions.ExternalApplicationException;
import org.nddp.phylogeny.Tree;

public class PhylipDnaMLKRunner extends PhylipJumblingRunner {

    public PhylipDnaMLKRunner() {
        
        super();
    }

	///////////////////////////////////////////////////////////////////
	////                         public methods                    ////    	

	public Object run() throws CollectionException {

    	    return _run("DNAMLK", System.getProperty("PHYLIP_EXE_DIR") + "/dnamlk");
	}
	
	///////////////////////////////////////////////////////////////////
	////                         protected methods                 ////

    	protected void _parseOutput(String output, List trees) 
    		throws CollectionException {

    	    int index = 0;
    	    
		for (Iterator treeIterator = trees.iterator(); 
			treeIterator.hasNext(); ) {

		    Tree tree = (Tree)treeIterator.next();
		    
//		    index = _findTable(output, index, "steps in each site:", 3);
//		    index = _parseStepTable(output, tree, index);	
//		    
//		    index = _findTable(output, index, "State at upper node", 2);
//		    index = _parseStateTable(output, tree, index);			
		}
    	}
    	
    protected void _writeStandardInput() 
    		throws ExternalApplicationException {
        
		try {
		    // disable interleaved format
		    _writeToProcess("I");

		    	// reconstruct hypothetical sequences
		    _writeToProcess("5");

		} catch (IOException e) {
			throw new ExternalApplicationException(
		        "Error writing to DNAMLK process");
        	}	
		
		super._writeStandardInput();
    }
}

