/*  Base class for Phylip tree inference actors that jumble taxa.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 package org.nddp.phylogeny.phylip;

import org.nddp.exceptions.InconsistentDataException;
import org.nddp.util.Parameters;

import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

public abstract class PhylipJumblingTreeInferenceActor extends PhylipTreeInferenceActor {

    public PhylipJumblingTreeInferenceActor(CompositeEntity container, String name)
        throws NameDuplicationException, IllegalActionException {
        
        	super(container, name);
        
        	jumbleCount = Parameters.intParameter(this, "jumbleCount", 0);
        	
        	jumbleSeed = Parameters.intParameter(this, "jumbleSeed", 1);
        	
		_enableParameterOverride(new Parameter[] {jumbleCount, jumbleSeed} );
    }

	///////////////////////////////////////////////////////////////////
	////                         public variables                  ////

	public Parameter jumbleCount;
	public Parameter jumbleSeed;
	
	///////////////////////////////////////////////////////////////////
	////                         protected methods                 ////
	
	protected void _configureRunner() throws InconsistentDataException {

	    super._configureRunner();
	    
	    ((PhylipJumblingRunner)_runner).jumbleTaxa(_jumbleCount, _jumbleSeed);
	}       

    public void _handleParameterChange(Parameter parameter, Token newValue) 
		throws IllegalActionException {
            
		if (parameter == jumbleCount) {
		    
        		_jumbleCount = Parameters.intValue(newValue);
        		
        } else if (parameter == jumbleSeed) {
            
        		int newJumbleSeed = Parameters.intValue(newValue);
        		
        		if (newJumbleSeed % 4 != 1) {
        		    throw new IllegalActionException(
					"jumbleSeed must satisfy: jumbleSeed mod 4 == 1");
        		}
        		
        		_jumbleSeed = newJumbleSeed;
        		
        } else {
            super._handleParameterChange(parameter, newValue);
        }
    }
 
	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////
  	  	
	private int _jumbleCount;
	private int _jumbleSeed;
}
