/* Collection token containing a collection exception.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */

 package org.nddp.tokens;

import org.nddp.Collection;
import org.nddp.AtomicCoactor;
import org.nddp.Coactor;
import org.nddp.exceptions.CollectionException;
import org.nddp.util.Xml;

public class ExceptionToken extends CollectionTokenSkeleton {

	public ExceptionToken(Collection collection, Coactor source, 
        CollectionException exception) {
	    
		super(collection);
	
		_source = source;
		_exception = exception;
	}

	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 
	
	public CollectionException exception() {
		return _exception;
	}
	
	public Coactor source() {
		return _source;
	}
	
    public String toString() {

        	return toXmlString(true);
    }

    public String toXmlString(boolean showType) {

        StringBuffer buffer = new StringBuffer("<Exception");
        
        if (showType) {
	        buffer.append(Xml.attribute("type", _exception.getClass().getName()));
        }
        
   	    buffer.append(Xml.attribute("source", _source.getName()));
   	    
   	    buffer.append(Xml.attribute("message", _exception.getMessage()) + " />");

   	    return buffer.toString();
    }
    
    ///////////////////////////////////////////////////////////////////
	////                     private variables                     //// 
    
    private final CollectionException _exception;
    private final Coactor _source;
}