/* Token representing collection metadata.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 package org.nddp.tokens;

import org.nddp.Collection;
import org.nddp.util.Xml;

import ptolemy.data.StringToken;
import ptolemy.data.Token;

public class MetadataToken extends CollectionTokenSkeleton {

	public MetadataToken(Collection collection, String key, Token value) {
		super(collection);
	
		_key = key;
		_value = value;
	}
	
	///////////////////////////////////////////////////////////////////
	////                         public variables                  ////

	public static final Token NO_MATCHING_METADATA = new Token();

	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 

	public String key() {
	    return _key;
	}

    public String toString() {

        	return toXmlString(true);
    }
    
    public String toXmlString(boolean showType) {

        return toXmlString("Metadata", showType);
    }
    
	public Token value() {
	    return _value;
	}
	
	///////////////////////////////////////////////////////////////////
	////                      protected methods                    //// 

    protected final String toXmlString(String tokenType, boolean showType) {

        StringBuffer buffer = new StringBuffer("<" + tokenType);
        
        if (showType) {
	        buffer.append(Xml.attribute("type", _value.getClass().getName()));
        }
        
   	    buffer.append(Xml.attribute("key", _key));
   	    
   	    buffer.append(Xml.attribute("value", _value.toString(), 
   	            (! (_value instanceof StringToken))) + " />");
   	    
   	    return buffer.toString();
    }
    
	///////////////////////////////////////////////////////////////////
	////                         private variables                 ////

    private final String _key;
    private final Token _value;
}