/* Base class for clasess that run external processes on behalf of actors.
 *
 * Copyright (c) 2005 Natural Diversity Discovery Project.
 * All rights reserved.
 * 
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE NATURAL DIVERSITY DISCOVERY PROJECT BE LIABLE 
 * TO ANY PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR 
 * CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND 
 * ITS DOCUMENTATION, EVEN IF THE NATURAL DIVERSITY DISCOVERY PROJECT
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE NATURAL DIVERSITY DISCOVERY PROJECT SPECIFICALLY DISCLAIMS ANY 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE NATURAL 
 * DIVERSITY DISCOVERY PROJECT HAS NO OBLIGATION TO PROVIDE MAINTENANCE, 
 * SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

   @ProposedRating Red (tmcphillips@naturaldiversity.org)
   @AcceptedRating Red (tmcphillips@naturaldiversity.org) 
 */
 
package org.nddp.util;

import java.io.IOException;
import java.io.Writer;

import org.nddp.exceptions.ExternalApplicationException;

public class ProcessRunnerConcrete {

    public ProcessRunnerConcrete(ProcessEnvironment environment, 
        String programPath) 
        throws ExternalApplicationException {
        
        super();
        
        _stdoutStreamHandler = new StreamBuffer();
        _stderrStreamHandler = new StreamBuffer();
        
        try {
            _process = environment.startProcess(programPath, _stdoutStreamHandler,
                _stderrStreamHandler);
            
        } catch (IOException e) {
            throw new ExternalApplicationException(
                "Error starting program " + programPath);
        }   
    }

	///////////////////////////////////////////////////////////////////
	////                         public methods                    //// 

//   	public void setStderrStreamHandler(StreamWriter streamHandler) {
//   	    _stderrStreamHandler = streamHandler;
//   	}
//   	public void setStdoutStreamHandler(StreamWriter streamHandler) {
//   	    _stdoutStreamHandler = streamHandler;
//   	}
   	
	///////////////////////////////////////////////////////////////////
	////                         protected methods                 ////
        
    
    public String getStandardOutput() {
        return ((StreamBuffer)_stdoutStreamHandler).toString();
    }

    public String getStandardError() {
        return ((StreamBuffer)_stderrStreamHandler).toString();
    }
    
    public void waitForProgramCompletion() {

        // Wait for the program to finish
	    _process.waitFor();
    }
    
    public void writeToProcess(String string) throws IOException {
        
        _process.writeLine(string);
        _process.flushStandardInput();
    }

    ///////////////////////////////////////////////////////////////////
	////                         private variables                 ////
    
    	private ExternalProcess _process;
    	private Writer _stdoutStreamHandler = null;
	private Writer _stderrStreamHandler = null;
}
