/**
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 */

package org.nmiworkflow;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Source;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

//////////////////////////////////////////////////////////////////////////
//// GlobusJob
/**
This actor takes a Globus RSL and hostname and submits a job to that
host. The output is gathered and sent to the output port.
<p>
The <i>rsl</i> parameter is the Globus RSL that defines the job to be run.
The <i>host</i> parameter is the hostname where the job will be executed.
I should add more parameters so the user does not need to specify a full
rsl. Rsl is annoying.
*/

public class GlobusJob extends Source {

  public GlobusJob(CompositeEntity container, String name)
          throws IllegalActionException, NameDuplicationException {
      super(container, name);


      input = new TypedIOPort(this, "input", true, false);
      //input.setMultiport(true);
      input.setTypeEquals(BaseType.STRING);

      output.setTypeEquals(BaseType.STRING);

      rsl = new Parameter(this, "RSL String", new StringToken(""));
      rsl.setTypeEquals(BaseType.STRING);

      host = new Parameter(this, "Globus Host", new StringToken(""));
      host.setTypeEquals(BaseType.STRING);

      _attachText("_iconDescription", "<svg>\n"
              + "<rect x=\"-25\" y=\"-20\" "
              + "width=\"50\" height=\"40\" "
              + "style=\"fill:white\"/>\n"
              + "<polygon points=\"-15,-10 -12,-10 -8,-14 -1,-14 3,-10"
              + " 15,-10 15,10, -15,10\" "
              + "style=\"fill:red\"/>\n"
              + "</svg>\n");
  }

  ///////////////////////////////////////////////////////////////////
  ////                     ports and parameters                  ////
  /** The input port, which is a multiport.
   */
  public TypedIOPort input;

  public Parameter rsl; //the rsl string defining the job to be run
  public Parameter host; //the host name to run the job on


  ///////////////////////////////////////////////////////////////////
  ////                         public methods                    ////

  /** If the specified attribute is <i>fileOrURL</i> and there is an
   *  open file being read, then close that file and open the new one;
   *  if the attribute is <i>numberOfLinesToSkip</i> and its value is
   *  negative, then throw an exception.  In the case of <i>fileOrURL</i>,
   *  do nothing if the file name is the same as the previous value of
   *  this attribute.
   *  @param attribute The attribute that has changed.
   *  @exception IllegalActionException If the specified attribute
   *   is <i>fileOrURL</i> and the file cannot be opened, or the previously
   *   opened file cannot be closed; or if the attribute is
   *   <i>numberOfLinesToSkip</i> and its value is negative.
   */
  public void attributeChanged(Attribute attribute)
          throws IllegalActionException {

      super.attributeChanged(attribute);
  }
  /** Clone the actor into the specified workspace.
   *  @return A new actor.
   *  @exception CloneNotSupportedException If a derived class contains
   *   an attribute that cannot be cloned.
   */
/*  public Object clone(Workspace workspace)
          throws CloneNotSupportedException {
      LineReader newObject = (LineReader)super.clone(workspace);
      newObject._currentLine = null;
      newObject._reachedEOF = false;
      newObject._reader = null;
      return newObject;
  }*/

  /** Output the data lines into an array.
   *  @exception IllegalActionException If there's no director.
   */

  public void fire() throws IllegalActionException {
      super.fire();

      //get the proxy string fed into the input port
      Token token = input.get(0);

      String hostString = ((StringToken)host.getToken()).stringValue();
      String rslString  = ((StringToken)rsl.getToken()).stringValue();
      _debug("RSL = " + rslString);
      _proxy = token.toString();
      _job = new GridJob(hostString, false);
      _result = _job.GlobusRun(rslString, _proxy);
      _result += _job.getOut();
      output.broadcast(new StringToken(_result));
  }

  /** Post fire the actor. Return false to indicated that the
  * process has finished. If it returns true, the process will
  * continue indefinitely.
  */

  public boolean postfire() {
      return false;
  }

  /** Open the file or URL and read the first line, and use the
   *  first line to set the type of the output.
   *  @exception IllegalActionException If the file or URL cannot be
   *  opened, or if the first line cannot be read.
   */
  public void preinitialize() throws IllegalActionException {
      super.preinitialize();
  }

  /** Close the reader if there is one.
   *  @exception IllegalActionException If an IO error occurs.
   */
/********
  public void wrapup() throws IllegalActionException {
      fileOrURL.close();
      _reader = null;
  }
*********/

  ///////////////////////////////////////////////////////////////////
  ////                         protected members                 ////


  ///////////////////////////////////////////////////////////////////
  ////                         private methods                   ////


  ///////////////////////////////////////////////////////////////////
  ////                         private members                   ////

  private GridJob _job;
  private String _proxy;

  /** Result string Variable. */
  private String _result = new String("");

}
