/**
 * Authors: jaeger
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 */

package org.nmiworkflow;

import java.io.File;
import java.io.IOException;

import org.globus.ftp.GridFTPClient;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;

import ptolemy.actor.TypedIOPort;
import ptolemy.actor.lib.Source;
import ptolemy.data.StringToken;
import ptolemy.data.Token;
import ptolemy.data.expr.Parameter;
import ptolemy.data.type.BaseType;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;

//////////////////////////////////////////////////////////////////////////
//// GlobusJob
/**
This actor takes a Globus RSL and hostname and submits a job to that
host. The output is gathered and sent to the output port.
<p>
The <i>rsl</i> parameter is the Globus RSL that defines the job to be run.
The <i>host</i> parameter is the hostname where the job will be executed.
I should add more parameters so the user does not need to specify a full
rsl. Rsl is annoying.
*/

public class GridFTP extends Source {

  public GridFTP (CompositeEntity container, String name)
          throws IllegalActionException, NameDuplicationException {
      super(container, name);


      input = new TypedIOPort(this, "input", true, false);
      //input.setMultiport(true);
      input.setTypeEquals(BaseType.STRING);

      output.setTypeEquals(BaseType.STRING);

      sourceHost = new Parameter(this, "Source hostname", new StringToken("griddle.sdsc.edu"));
      sourceHost.setTypeEquals(BaseType.STRING);
      sourceFile = new Parameter(this, "Full path to source file", new StringToken("/etc/passwd"));
      sourceFile.setTypeEquals(BaseType.STRING);
      destHost = new Parameter(this, "Destination hostname", new StringToken("localhost"));
      destHost.setTypeEquals(BaseType.STRING);
      destFile = new Parameter(this, "Full path to destination file", new StringToken("/tmp/passwd.griddle"));
      destFile.setTypeEquals(BaseType.STRING);

      _attachText("_iconDescription", "<svg>\n"
              + "<rect x=\"-25\" y=\"-20\" "
              + "width=\"50\" height=\"40\" "
              + "style=\"fill:white\"/>\n"
              + "<polygon points=\"-15,-10 -12,-10 -8,-14 -1,-14 3,-10"
              + " 15,-10 15,10, -15,10\" "
              + "style=\"fill:red\"/>\n"
              + "</svg>\n");
  }

  ///////////////////////////////////////////////////////////////////
  ////                     ports and parameters                  ////
  /** The input port, which is a multiport.
   */
  public TypedIOPort input;

  public Parameter sourceHost; //string of the source host gridFTP server
  public Parameter destHost;   //string of the destination host for the transfer
  public Parameter sourcePort; //port number for the server
  public Parameter destPort;   //port number for the dest
  public Parameter sourceFile; //full path to the source file
  public Parameter destFile  ; //full path to the destination file

  ///////////////////////////////////////////////////////////////////
  ////                         public methods                    ////

  /** If the specified attribute is <i>fileOrURL</i> and there is an
   *  open file being read, then close that file and open the new one;
   *  if the attribute is <i>numberOfLinesToSkip</i> and its value is
   *  negative, then throw an exception.  In the case of <i>fileOrURL</i>,
   *  do nothing if the file name is the same as the previous value of
   *  this attribute.
   *  @param attribute The attribute that has changed.
   *  @exception IllegalActionException If the specified attribute
   *   is <i>fileOrURL</i> and the file cannot be opened, or the previously
   *   opened file cannot be closed; or if the attribute is
   *   <i>numberOfLinesToSkip</i> and its value is negative.
   */
  public void attributeChanged(Attribute attribute)
          throws IllegalActionException {

      super.attributeChanged(attribute);
  }
  /** Clone the actor into the specified workspace.
   *  @return A new actor.
   *  @exception CloneNotSupportedException If a derived class contains
   *   an attribute that cannot be cloned.
   */
/*  public Object clone(Workspace workspace)
          throws CloneNotSupportedException {
      LineReader newObject = (LineReader)super.clone(workspace);
      newObject._currentLine = null;
      newObject._reachedEOF = false;
      newObject._reader = null;
      return newObject;
  }*/

  /** Output the data lines into an array.
   *  @exception IllegalActionException If there's no director.
   */

  public void fire() throws IllegalActionException {
      super.fire();

      //get the proxy string fed into the input port
      Token token = input.get(0);

      String sourceHostString = ((StringToken)sourceHost.getToken()).stringValue();
      String sourceFileString = ((StringToken)sourceFile.getToken()).stringValue();
      int sourcePort = 2811; //((IntToken)sourcePort.getToken()).intValue();
      String destHostString = ((StringToken)destHost.getToken()).stringValue();
      String destFileString = ((StringToken)destFile.getToken()).stringValue();
      int destPort = 2811; //((IntToken)destPort.getToken()).intValue();

      String failMsg = "GridFTP transfer failed because of: ";
      //_proxy = token.toString();
      try {
          ExtendedGSSManager manager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
          _proxy = manager.createCredential((token.toString()).getBytes(),
                                ExtendedGSSCredential.IMPEXP_OPAQUE,
                                GSSCredential.DEFAULT_LIFETIME,
                                null, // use default mechanism - GSI
                                GSSCredential.INITIATE_AND_ACCEPT);

          if(destHostString.equals("") || destHostString.equals("localhost")) {
              _gftpc = new GridFTPClient(sourceHostString, sourcePort);
              _gftpc.authenticate(_proxy);
              _gftpc.get(sourceFileString, new File(destFileString));
          } else if (sourceHostString.equals("") || sourceHostString.equals("localhost")) {
              _gftpc_dest = new GridFTPClient(destHostString, destPort);
              _gftpc_dest.authenticate(_proxy);
              _gftpc_dest.put(new File(sourceFileString), destFileString, false);
          } else {
              _gftpc = new GridFTPClient(sourceHostString, sourcePort);
              _gftpc.authenticate(_proxy);
              _gftpc_dest = new GridFTPClient(destHostString, destPort);
              _gftpc_dest.authenticate(_proxy);
              _gftpc.transfer(sourceFileString, _gftpc_dest, destFileString, false, null);
          }
      } catch (IOException ioe) {
          throw new IllegalActionException(failMsg + ioe.toString());
      } catch (org.globus.ftp.exception.ServerException se) {
          throw new IllegalActionException(failMsg + se.toString());
      } catch (org.globus.ftp.exception.ClientException ce) {
          throw new IllegalActionException(failMsg + ce.toString());
      } catch (org.ietf.jgss.GSSException gsse) {
          throw new IllegalActionException(failMsg + gsse.toString());
      }
      _result += "Done with GridFTP transfer.";
      output.broadcast(new StringToken(_result));
  }

  /** Post fire the actor. Return false to indicated that the
  * process has finished. If it returns true, the process will
  * continue indefinitely.
  */

  public boolean postfire() {
      return false;
  }

  /** Open the file or URL and read the first line, and use the
   *  first line to set the type of the output.
   *  @exception IllegalActionException If the file or URL cannot be
   *  opened, or if the first line cannot be read.
   */
  public void preinitialize() throws IllegalActionException {
      super.preinitialize();
  }

  /** Close the reader if there is one.
   *  @exception IllegalActionException If an IO error occurs.
   */
/********
  public void wrapup() throws IllegalActionException {
      fileOrURL.close();
      _reader = null;
  }
*********/

  ///////////////////////////////////////////////////////////////////
  ////                         protected members                 ////


  ///////////////////////////////////////////////////////////////////
  ////                         private methods                   ////


  ///////////////////////////////////////////////////////////////////
  ////                         private members                   ////

  private GridFTPClient _gftpc;
  private GridFTPClient _gftpc_dest;
  private GSSCredential _proxy;

  /** Result string Variable. */
  private String _result = new String("");

}
