/* Generated By:JJTree&JavaCC: Do not edit this line. PtParser.java */
/* 
 Copyright (c) 1998-2006 The Regents of the University of California.
 All rights reserved.
 Permission is hereby granted, without written agreement and without
 license or royalty fees, to use, copy, modify, and distribute this
 software and its documentation for any purpose, provided that the above
 copyright notice and the following two paragraphs appear in all copies
 of this software.

 IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
 THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 SUCH DAMAGE.

 THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
 CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
 ENHANCEMENTS, OR MODIFICATIONS.
 
                                        PT_COPYRIGHT_VERSION_2
                                        COPYRIGHTENDKEY

Created : May 1998
*/

package ptolemy.data.expr;

import ptolemy.kernel.*;
import ptolemy.kernel.util.*;
import ptolemy.data.*;
import ptolemy.math.Complex;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Collections;
import java.util.StringTokenizer;

import java.io.*;

//////////////////////////////////////////////////////////////////////
//// PTParser.jjt
/** 
This file implements an expression parser for Ptolemy II using the 
JavaCC parser generator. It can handle all the basic arithmetic operators
(*, /, +, -, %, ^), relational operators (<, <=, >, >=, == !=), logical 
operators(&&, ||, !), bitwise operators (&, |, #, ~)  and, using 
reflection, all of the functionality available in the java.lang.Math 
package. 
<p>
By editing the ASTFunctionNode file it is also relatively 
easy to allow references to other functions. This provides an easy mechanism 
to extend the range to the parser e.g. have a tcl(...) function 
that passes the string to a Tcl interpreter and retuns the result.
<p>
Functional if is supported via the following syntax:
        (boolean) ? (value1) : (value2)
<p>
Extensibility is also supported by allowing method calls on the Tokens,
the syntax is 
        (value1).method(comma separated arguments)
<p>
JavaCC by itself simply generates a file (and support files) that allow an 
input to be parsed, it does not return a parse tree. For the purposes of 
type checking we require a parse tree, and this is obtained using JJTree, a 
preprocessor for JavaCC. 
<p>
JJtree operates by annotating the grammar file to support the generation
of the parse tree. Thus the process is
<p>
<center>X.jjt --> JJTREE --> X.jj --> JAVACC --> X.java + support files
<br>
</CENTER>
<p>
The parser can also be passed a symbol table of ptolemy.data.expr.Variables
which the expression to be parsed can reference.

<p>Anything between quotes(") or apostrophes(') is taken to be one string.  
Strings are allowed to contain newlines or carriage returns.  In
addition, these characters, as well as other special characters, can
be escaped using the standard Java syntax (\n, \t, \077, etc.).

<p>The expressions recognized follow as close as possible the syntax of Java.
In particular the operator precedences implemented here follow exactly 
those in Java. Any type conversions that are performed are lossless. If 
the user wants lossy conversions, explicit casts will be necessary.
<p>
Complex number are specified by an i or j after the imaginary part 
of the number. Long numbers are specified by an l or L after an 
integer number.
<p>
Users can register constants with the parser and also register classes
where functions that may be called are defined. For a more 
thorough description of what the Parser is designed to do, 
please consult the Ptolemy II design document (or contact nsmyth@eecs)
<p>
Note that the parsers created by JavaCC generally have quite a bit of
internal state.  On the other hand, the parse trees generated by this
parser are much smaller.  It is also fairly cheap to traverse a parse
tree in order to evaluate it.  Thus it is usually preferable to cache
parse trees and create a new parser when the cached parse tree becomes
invalid.

@author Neil Smyth, Steve Neuendorffer
@version $Id: PtParser.java,v 1.127 2006/04/03 21:21:36 cxh Exp $
@since Ptolemy II 1.0
@Pt.ProposedRating Yellow (nsmyth)
@Pt.AcceptedRating Yellow (yuhong)
@see ptolemy.data.expr.ASTPtBitwiseNode
@see ptolemy.data.expr.ASTPtFunctionApplicationNode
@see ptolemy.data.expr.ASTPtFunctionDefinitionNode
@see ptolemy.data.expr.ASTPtFunctionalIfNode
@see ptolemy.data.expr.ASTPtLeafNode
@see ptolemy.data.expr.ASTPtLogicalNode
@see ptolemy.data.expr.ASTPtMethodCallNode
@see ptolemy.data.expr.ASTPtProductNode
@see ptolemy.data.expr.ASTPtRelationalNode
@see ptolemy.data.expr.ASTPtRootNode
@see ptolemy.data.expr.ASTPtSumNode
@see ptolemy.data.expr.ASTPtUnaryNode
@see ptolemy.data.Token 
*/
public class PtParser/*@bgen(jjtree)*/implements PtParserTreeConstants, PtParserConstants {/*@bgen(jjtree)*/
  protected JJTPtParserState jjtree = new JJTPtParserState();
    boolean debug = false;

    public PtParser() {
        this(new StringReader(""));
        _initialize();
    }

    /** Returns the list of undefined variables after parsing the given String.
     *  @param stringIn The expression to be parsed
     *  @exception IllegalActionException If the parse fails.
     *  @return The list of undefined variables.
     *  @deprecated Use a visitor with a ParseTreeFreeVariableCollector
     *  instead.
     */
    public LinkedList getUndefinedList(String stringIn)
            throws IllegalActionException {
        ASTPtRootNode rootNode = generateParseTree(stringIn);
        ParseTreeFreeVariableCollector collector =
            new ParseTreeFreeVariableCollector();

        Set vars = collector.collectFreeVariables(rootNode);
        return new LinkedList(vars);
    }

    /** Generates a parse tree from the given String. The root node is
     * returned. To evaluate the parse tree, use a ParseTreeEvaluator.
     *  @param stringIn The expression to be parsed.
     *  @exception IllegalActionException If the parse fails.
     *  @return The root node of the parse tree.
     */
    public ASTPtRootNode generateParseTree(String stringIn)
            throws IllegalActionException {

        Reader reader = new StringReader(stringIn);
        this.ReInit(reader);
        ASTPtRootNode rootNode;
        try {
            // Parse the expression to obtain the parse tree
            // start() can generate a TokenMgrError if we parse a "\0"
            rootNode = start();
            if (debug) {
                rootNode.displayParseTree(" ");
            }
        } catch (Throwable throwable) {
            throw new IllegalActionException(null, throwable,
                    "Error parsing expression \"" + stringIn + "\"");
        }
        ASTPtRootNode primary = (ASTPtRootNode)rootNode.jjtGetChild(0);
        primary.jjtSetParent(null);
        return primary;
    }

    /** Generates a parse tree from the given String, which may optionally
     *  contain an assignment. The root node is
     *  returned. If the string represents an assignment, then the
     *  toplevel node will be an ASTPtAssignmentNode.
     *  @param stringIn The expression to be parsed.
     *  @exception IllegalActionException If the parse fails.
     *  @return The root node of the parse tree.
     */
    public ASTPtRootNode generateSimpleAssignmentParseTree(String stringIn)
            throws IllegalActionException {

        Reader reader = new StringReader(stringIn);
        this.ReInit(reader);
        ASTPtRootNode rootNode;
        try {
            // Parse the expression to obtain the parse tree
            rootNode = startSimpleAssignment();
            if (debug) rootNode.displayParseTree(" ");
        } catch (Throwable throwable) {
            throw new IllegalActionException(null, throwable,
                    "Error parsing expression \""
                    + stringIn + "\"");
        }
        ASTPtRootNode primary = (ASTPtRootNode)rootNode.jjtGetChild(0);
        primary.jjtSetParent(null);
        return primary;
    }

    /** Generates a parse tree from the given String, which is interpreted
     *  in "String Mode" instead of as an operator expression.  In 
     *  string mode, the expression is a literal string, except for
     *  identifiers which are denoted by $param.  The root node is
     *  returned. To evaluate the parse tree, use a ParseTreeEvaluator.
     *  @param stringIn The expression to be parsed.
     *  @exception IllegalActionException If the parse fails.
     *  @return The root node of the parse tree.
     */
    public ASTPtRootNode generateStringParseTree(String stringIn)
            throws IllegalActionException {

        Reader reader = new StringReader(stringIn);
        this.ReInit(reader);
        ASTPtRootNode rootNode;
        try {
            // Parse the expression to obtain the parse tree
            token_source.SwitchTo(StringMode);
            // startString() can generate a TokenMgrError
            rootNode = startString();
            if (debug) {
                rootNode.displayParseTree(" ");
            }
        } catch (Throwable throwable) {
            throw new IllegalActionException(null, throwable,
                    "Error parsing expression \"" + stringIn + "\"");
        } finally {
            token_source.SwitchTo(DEFAULT);
        }
        ASTPtRootNode primary = (ASTPtRootNode)rootNode.jjtGetChild(0);
        primary.jjtSetParent(null);
        return primary;
    }

    /** Generates a parse tree from the given String.  
     *  The string will be parsed according to rules for assignment lists. 
     *  The returned node is a RootNode containing one assignment
     *  node for each assignment in the expression.
     *
     *  @param stringIn The expression to be parsed.
     *  @exception IllegalActionException If the parse fails.
     *  @return The root node of the parse tree.
     */
    public Map generateAssignmentMap(String stringIn)
            throws IllegalActionException {

        Reader reader = new StringReader(stringIn);
        this.ReInit(reader);
        Map map;
        try {
            // Parse the expression to obtain the parse tree.
            // startAssignmentList() might throw TokenMgrError which is 
            // an Error, not an Exception, so we catch Throwables here. 
            map = startAssignmentList();
        } catch (Throwable throwable) {
            throw new IllegalActionException(null, throwable,
                    "Error parsing expression \"" + stringIn + "\"");
        }
        return map;
    }

    /** Return the list of classes the parser searches 
     *  when a function call is encountered.  The 
     *  classes are searched in the same order that they were registered 
     *  with the parser, so the classes that are most likely to be 
     *  searched should be registered first.  This method is synchronized
     *  so that it can be called safely from multiple parsers.
     *  @return An unmodifiable list that can be iterated over.
     */
    public static synchronized List getRegisteredClasses() {
        if (_classesSearched == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(new ArrayList(_classesSearched));
    }

    /** Add a constant to the list of constants that the parser recognizes.
     *  It is a static method. The constants are stored in a hash table by
     *  the Constants class. The entry for each name is a ptolemy.data.Token 
     *  of the appropriate type. The value for the constant can be given
     *  in a ptolemy.data.Token or in one of the data wrapper classes 
     *  in java.lang.
     *  @param name The string name that the parser will recognize.
     *  @param value An Object constraining the value associated with 
     *   the constant.
     *  @exception IllegalArgumentException If the constant cannot
     *   be registered with the parser.
     */
    public static void registerConstant(String name, Object value)
            throws IllegalArgumentException {
        if ( (value == null) || (name == null)) {
            throw new IllegalArgumentException("PtParser: cannot register " +
                    "a constant if either the name or value object is null.");
        }
        ptolemy.data.Token tmp;
        if  (value instanceof ptolemy.data.Token) {
            tmp = (ptolemy.data.Token)value;
        } else if (value instanceof Integer) {
            tmp = new IntToken(((Integer)value).intValue());
        } else if (value instanceof Double) {
            tmp = new DoubleToken(((Double)value).doubleValue());
        } else if (value instanceof Long) {
            tmp = new LongToken(((Long)value).longValue());
        } else if (value instanceof String) {
            tmp = new StringToken((String)value);
        } else if (value instanceof Boolean) {
            tmp = new BooleanToken(((Boolean)value).booleanValue());
        } else if (value instanceof Complex) {
            tmp = new ComplexToken((Complex)value);
        } else {
            throw new IllegalArgumentException("PtParser: cannot register " +
                    name + "  as a constant of the parser.");
        }
        Constants.add(name, tmp);
        return;
    }

    /** Add a class to the list of classes that the parser searches 
     *  when a function call is encountered. 
     *  It is a static method. It stores the classes in a LinkedList. The 
     *  classes are searched in the same order that they were registered 
     *  with the parser, so the classes that are most likely to be 
     *  searched should be registered first.  This method is synchronized
     *  so that it can be called safely from multiple parsers.
     *  @param newClassName The fully qualified name of the Class to 
     *   be added to the search path for functions.
     *  @exception IllegalArgumentException If the Class named by the 
     *   argument cannot not be found.
     */
    public static synchronized void registerFunctionClass(String newClassName)
            throws IllegalArgumentException {
        if (_classesSearched == null) {
            _classesSearched = new ArrayList();
        }
        try {
            Class newClass = Class.forName(newClassName);
            if(!_classesSearched.contains(newClass)) {
                _classesSearched.add(newClass);
            }
        } catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(
                     "Could not find " + newClassName + ".");
        }
        CachedMethod.clear();
    }

    /** Initialize the static variable containing the classes searched by
     *  the parser upon encountering a function call.
     */
    private void _initialize() {
        if (!_alreadyInitialized) {
            _alreadyInitialized = true;
            registerFunctionClass("java.lang.Math");
            registerFunctionClass("java.lang.Double");
            registerFunctionClass("java.lang.Integer");
            registerFunctionClass("java.lang.Long");
            registerFunctionClass("java.lang.String");
            registerFunctionClass("ptolemy.data.MatrixToken");
            registerFunctionClass("ptolemy.data.RecordToken");
            registerFunctionClass("ptolemy.data.expr.UtilityFunctions");
            registerFunctionClass("ptolemy.data.expr.FixPointFunctions");
            registerFunctionClass("ptolemy.math.Complex");
            registerFunctionClass("ptolemy.math.ExtendedMath");
            registerFunctionClass("ptolemy.math.IntegerMatrixMath");
            registerFunctionClass("ptolemy.math.DoubleMatrixMath");
            registerFunctionClass("ptolemy.math.ComplexMatrixMath");
            registerFunctionClass("ptolemy.math.LongMatrixMath");
            registerFunctionClass("ptolemy.math.IntegerArrayMath");
            registerFunctionClass("ptolemy.math.DoubleArrayStat");
            registerFunctionClass("ptolemy.math.ComplexArrayMath");
            registerFunctionClass("ptolemy.math.LongArrayMath");
            registerFunctionClass("ptolemy.math.SignalProcessing");
            registerFunctionClass("ptolemy.math.FixPoint");
        }
    }

    /* Flag indicating whether the default set of classes searched 
     * by the parser has already been loaded.
     */
    private static boolean _alreadyInitialized = false;

    /*  Stores the classes that are searched by the parser when a 
     *  function call is parsed. It is static, and by default only 
     *  contains the java.lang.Math class.
     */
    private static List _classesSearched;

// A simple, optional assigment used by the expression evaluator
  final public ASTPtRootNode startSimpleAssignment() throws ParseException {
 /*@bgen(jjtree) PtRootNode */
  ASTPtRootNode jjtn000 = new ASTPtRootNode(JJTPTROOTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      if (jj_2_1(2147483647)) {
        assignment();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MINUS:
        case OPENPAREN:
        case OPENBRACE:
        case OPENBRACKET:
        case OPENUNION:
        case BOOL_NOT:
        case BITWISE_NOT:
        case INTEGER:
        case DOUBLE:
        case COMPLEX:
        case BOOLEAN:
        case FUNCTION:
        case ID:
        case STRING:
        case SMID:
        case SMIDBRACE:
        case SMIDPAREN:
          expression();
          break;
        default:
          jj_la1[0] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(0);
                jjtree.closeNodeScope(jjtn000, true);
                jjtc000 = false;
            {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Map startAssignmentList() throws ParseException {
 /*@bgen(jjtree) PtRootNode */
    ASTPtRootNode jjtn000 = new ASTPtRootNode(JJTPTROOTNODE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);Map map = new LinkedHashMap();
    try {
      assignment();
        ASTPtAssignmentNode node =
            (ASTPtAssignmentNode) jjtree.popNode();
        map.put(node.getIdentifier(), node);
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEPARATOR:
          ;
          break;
        default:
          jj_la1[1] = jj_gen;
          break label_1;
        }
        jj_consume_token(SEPARATOR);
        assignment();
        ASTPtAssignmentNode node2 =
            (ASTPtAssignmentNode) jjtree.popNode();
        map.put(node2.getIdentifier(), node2);
      }
      jj_consume_token(0);
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
      {if (true) return map;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void assignment() throws ParseException {
 /*@bgen(jjtree) PtAssignmentNode */
  ASTPtAssignmentNode jjtn000 = new ASTPtAssignmentNode(JJTPTASSIGNMENTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      assignmentIdentifier();
      jj_consume_token(SETEQUALS);
      expression();
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

// A string mode expression, using $parameter substitution.
  final public ASTPtRootNode startString() throws ParseException {
 /*@bgen(jjtree) PtRootNode */
  ASTPtRootNode jjtn000 = new ASTPtRootNode(JJTPTROOTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      ASTPtSumNode jjtn001 = new ASTPtSumNode(JJTPTSUMNODE);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      try {
        stringModeElement();
        label_2:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SMSTRING:
          case SMDOLLAR:
          case SMDOLLARBRACE:
          case SMDOLLARPAREN:
            ;
            break;
          default:
            jj_la1[2] = jj_gen;
            break label_2;
          }
          stringModeElement();
                     Token token = Token.newToken(PtParserConstants.PLUS);
                     token.kind = PtParserConstants.PLUS;
                     jjtn001._lexicalTokens.add(token);
        }
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
      }
      }
      jj_consume_token(0);
            jjtree.closeNodeScope(jjtn000, true);
            jjtc000 = false;
            {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void stringModeElement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SMSTRING:
      stringModeString();
      break;
    case SMDOLLAR:
      jj_consume_token(SMDOLLAR);
      identifier();
      break;
    case SMDOLLARBRACE:
      jj_consume_token(SMDOLLARBRACE);
      identifier();
      jj_consume_token(SMBRACE);
      break;
    case SMDOLLARPAREN:
      jj_consume_token(SMDOLLARPAREN);
      identifier();
      jj_consume_token(SMPAREN);
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void stringModeString() throws ParseException {
    jj_consume_token(SMSTRING);
                 ASTPtLeafNode jjtn001 = new ASTPtLeafNode(JJTPTLEAFNODE);
                 boolean jjtc001 = true;
                 jjtree.openNodeScope(jjtn001);
    try {
                 jjtree.closeNodeScope(jjtn001, true);
                 jjtc001 = false;
        jjtn001._ptToken =
            new StringToken(token.image.replaceAll("\\$\\$","\\$"));
        jjtn001._isConstant = true;
    } finally {
                 if (jjtc001) {
                   jjtree.closeNodeScope(jjtn001, true);
                 }
    }
  }

  final public ASTPtRootNode start() throws ParseException {
 /*@bgen(jjtree) PtRootNode */
  ASTPtRootNode jjtn000 = new ASTPtRootNode(JJTPTROOTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      expression();
      jj_consume_token(0);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
          {if (true) return jjtn000;}
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void expression() throws ParseException {
    if (jj_2_2(2147483647)) {
      functionDefinition();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
      case OPENPAREN:
      case OPENBRACE:
      case OPENBRACKET:
      case OPENUNION:
      case BOOL_NOT:
      case BITWISE_NOT:
      case INTEGER:
      case DOUBLE:
      case COMPLEX:
      case BOOLEAN:
      case ID:
      case STRING:
      case SMID:
      case SMIDBRACE:
      case SMIDPAREN:
        funcIf();
        break;
      default:
        jj_la1[4] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void funcIf() throws ParseException {
     ASTPtFunctionalIfNode jjtn001 = new ASTPtFunctionalIfNode(JJTPTFUNCTIONALIFNODE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      logicalOr();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case QUESTION:
        jj_consume_token(QUESTION);
        logicalOr();
        jj_consume_token(COLON);
        logicalOr();
        break;
      default:
        jj_la1[5] = jj_gen;
        ;
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void logicalOr() throws ParseException {
 Token x;
     ASTPtLogicalNode jjtn001 = new ASTPtLogicalNode(JJTPTLOGICALNODE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      logicalAnd();
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COND_OR:
          ;
          break;
        default:
          jj_la1[6] = jj_gen;
          break label_3;
        }
        x = jj_consume_token(COND_OR);
        logicalAnd();
                        jjtn001._lexicalToken = x;
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void logicalAnd() throws ParseException {
 Token x;
     ASTPtLogicalNode jjtn001 = new ASTPtLogicalNode(JJTPTLOGICALNODE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      bitwiseOr();
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COND_AND:
          ;
          break;
        default:
          jj_la1[7] = jj_gen;
          break label_4;
        }
        x = jj_consume_token(COND_AND);
        bitwiseOr();
                        jjtn001._lexicalToken = x;
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void bitwiseOr() throws ParseException {
 Token x;
     ASTPtBitwiseNode jjtn001 = new ASTPtBitwiseNode(JJTPTBITWISENODE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      bitwiseXor();
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OR:
          ;
          break;
        default:
          jj_la1[8] = jj_gen;
          break label_5;
        }
        x = jj_consume_token(OR);
        bitwiseXor();
                        jjtn001._lexicalToken = x;
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void bitwiseXor() throws ParseException {
 Token x;
     ASTPtBitwiseNode jjtn001 = new ASTPtBitwiseNode(JJTPTBITWISENODE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      bitwiseAnd();
      label_6:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case XOR:
          ;
          break;
        default:
          jj_la1[9] = jj_gen;
          break label_6;
        }
        x = jj_consume_token(XOR);
        bitwiseAnd();
                       jjtn001._lexicalToken = x;
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void bitwiseAnd() throws ParseException {
 Token x;
     ASTPtBitwiseNode jjtn001 = new ASTPtBitwiseNode(JJTPTBITWISENODE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      logicalEquals();
      label_7:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case AND:
          ;
          break;
        default:
          jj_la1[10] = jj_gen;
          break label_7;
        }
        x = jj_consume_token(AND);
        logicalEquals();
                       jjtn001._lexicalToken = x;
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void logicalEquals() throws ParseException {
 Token x;
     ASTPtRelationalNode jjtn001 = new ASTPtRelationalNode(JJTPTRELATIONALNODE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      relational();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOTEQUALS:
      case EQUALS:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQUALS:
          x = jj_consume_token(EQUALS);
          break;
        case NOTEQUALS:
          x = jj_consume_token(NOTEQUALS);
          break;
        default:
          jj_la1[11] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        relational();
                       jjtn001._lexicalToken = x;
        break;
      default:
        jj_la1[12] = jj_gen;
        ;
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void power() throws ParseException {
 Token x;
     ASTPtPowerNode jjtn001 = new ASTPtPowerNode(JJTPTPOWERNODE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      unary();
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case POWER:
          ;
          break;
        default:
          jj_la1[13] = jj_gen;
          break label_8;
        }
        jj_consume_token(POWER);
        unary();
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void relational() throws ParseException {
 Token x;
     ASTPtRelationalNode jjtn001 = new ASTPtRelationalNode(JJTPTRELATIONALNODE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      shift();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GT:
      case LT:
      case GTE:
      case LTE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GT:
          x = jj_consume_token(GT);
          break;
        case GTE:
          x = jj_consume_token(GTE);
          break;
        case LT:
          x = jj_consume_token(LT);
          break;
        case LTE:
          x = jj_consume_token(LTE);
          break;
        default:
          jj_la1[14] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        shift();
                       jjtn001._lexicalToken = x;
        break;
      default:
        jj_la1[15] = jj_gen;
        ;
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void shift() throws ParseException {
 Token x;
     ASTPtShiftNode jjtn001 = new ASTPtShiftNode(JJTPTSHIFTNODE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      sum();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SHL:
      case SHR:
      case LSHR:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SHL:
          x = jj_consume_token(SHL);
          break;
        case SHR:
          x = jj_consume_token(SHR);
          break;
        case LSHR:
          x = jj_consume_token(LSHR);
          break;
        default:
          jj_la1[16] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        sum();
                       jjtn001._lexicalToken = x;
        break;
      default:
        jj_la1[17] = jj_gen;
        ;
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void sum() throws ParseException {
 Token x;
     ASTPtSumNode jjtn001 = new ASTPtSumNode(JJTPTSUMNODE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      term();
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
        case MINUS:
          ;
          break;
        default:
          jj_la1[18] = jj_gen;
          break label_9;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PLUS:
          x = jj_consume_token(PLUS);
          break;
        case MINUS:
          x = jj_consume_token(MINUS);
          break;
        default:
          jj_la1[19] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        term();
                       jjtn001._lexicalTokens.add(x);
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void term() throws ParseException {
 Token x;
     ASTPtProductNode jjtn001 = new ASTPtProductNode(JJTPTPRODUCTNODE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
    try {
      power();
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MULTIPLY:
        case DIVIDE:
        case MODULO:
          ;
          break;
        default:
          jj_la1[20] = jj_gen;
          break label_10;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MULTIPLY:
          x = jj_consume_token(MULTIPLY);
          break;
        case DIVIDE:
          x = jj_consume_token(DIVIDE);
          break;
        case MODULO:
          x = jj_consume_token(MODULO);
          break;
        default:
          jj_la1[21] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        power();
                       jjtn001._lexicalTokens.add(x);
      }
    } catch (Throwable jjte001) {
     if (jjtc001) {
       jjtree.clearNodeScope(jjtn001);
       jjtc001 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte001 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte001;}
     }
     if (jjte001 instanceof ParseException) {
       {if (true) throw (ParseException)jjte001;}
     }
     {if (true) throw (Error)jjte001;}
    } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, jjtree.nodeArity() > 1);
     }
    }
  }

  final public void unary() throws ParseException {
 Token x;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      ASTPtUnaryNode jjtn001 = new ASTPtUnaryNode(JJTPTUNARYNODE);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
      try {
        x = jj_consume_token(MINUS);
        element();
                              jjtree.closeNodeScope(jjtn001, true);
                              jjtc001 = false;
        jjtn001._isMinus = true;
        jjtn001._lexicalToken = x;
      } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
      } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true);
      }
      }
      break;
    case BOOL_NOT:
      ASTPtUnaryNode jjtn002 = new ASTPtUnaryNode(JJTPTUNARYNODE);
      boolean jjtc002 = true;
      jjtree.openNodeScope(jjtn002);
      try {
        x = jj_consume_token(BOOL_NOT);
        element();
          jjtree.closeNodeScope(jjtn002, true);
          jjtc002 = false;
          jjtn002._isNot = true;
          jjtn002._lexicalToken = x;
      } catch (Throwable jjte002) {
      if (jjtc002) {
        jjtree.clearNodeScope(jjtn002);
        jjtc002 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte002 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte002;}
      }
      if (jjte002 instanceof ParseException) {
        {if (true) throw (ParseException)jjte002;}
      }
      {if (true) throw (Error)jjte002;}
      } finally {
      if (jjtc002) {
        jjtree.closeNodeScope(jjtn002, true);
      }
      }
      break;
    case BITWISE_NOT:
     ASTPtUnaryNode jjtn003 = new ASTPtUnaryNode(JJTPTUNARYNODE);
     boolean jjtc003 = true;
     jjtree.openNodeScope(jjtn003);
      try {
        x = jj_consume_token(BITWISE_NOT);
        element();
         jjtree.closeNodeScope(jjtn003, true);
         jjtc003 = false;
         jjtn003._isBitwiseNot = true;
         jjtn003._lexicalToken = x;
      } catch (Throwable jjte003) {
     if (jjtc003) {
       jjtree.clearNodeScope(jjtn003);
       jjtc003 = false;
     } else {
       jjtree.popNode();
     }
     if (jjte003 instanceof RuntimeException) {
       {if (true) throw (RuntimeException)jjte003;}
     }
     if (jjte003 instanceof ParseException) {
       {if (true) throw (ParseException)jjte003;}
     }
     {if (true) throw (Error)jjte003;}
      } finally {
     if (jjtc003) {
       jjtree.closeNodeScope(jjtn003, true);
     }
      }
      break;
    case OPENPAREN:
    case OPENBRACE:
    case OPENBRACKET:
    case OPENUNION:
    case INTEGER:
    case DOUBLE:
    case COMPLEX:
    case BOOLEAN:
    case ID:
    case STRING:
    case SMID:
    case SMIDBRACE:
    case SMIDPAREN:
      element();
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*
void element() #void :
{  
  boolean isMethodCall = false;
}
{ 
  // Note that omitting the parens is possible for a record...
  ( primaryElement()
    [ <PERIOD> <ID> {jjtThis._methodName = token.image; isMethodCall = true;}
      ( <OPENPAREN> [ funcIf() ( <COMMA> funcIf() )* ] <CLOSEPAREN> )? ]
  ) #PtMethodCallNode(isMethodCall)
}
*/
  final public void element() throws ParseException {
        boolean hasName = false;
        boolean hasCall = false;
        String name = null;
      ASTPtFunctionApplicationNode jjtn002 = new ASTPtFunctionApplicationNode(JJTPTFUNCTIONAPPLICATIONNODE);
      boolean jjtc002 = true;
      jjtree.openNodeScope(jjtn002);
    try {
          ASTPtMethodCallNode jjtn001 = new ASTPtMethodCallNode(JJTPTMETHODCALLNODE);
          boolean jjtc001 = true;
          jjtree.openNodeScope(jjtn001);
      try {
        primaryElement();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PERIOD:
          jj_consume_token(PERIOD);
          jj_consume_token(ID);
                                        name = token.image;
                                        hasName = true;
          break;
        default:
          jj_la1[23] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OPENPAREN:
          jj_consume_token(OPENPAREN);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case MINUS:
          case OPENPAREN:
          case OPENBRACE:
          case OPENBRACKET:
          case OPENUNION:
          case BOOL_NOT:
          case BITWISE_NOT:
          case INTEGER:
          case DOUBLE:
          case COMPLEX:
          case BOOLEAN:
          case FUNCTION:
          case ID:
          case STRING:
          case SMID:
          case SMIDBRACE:
          case SMIDPAREN:
            expression();
            label_11:
            while (true) {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case COMMA:
                ;
                break;
              default:
                jj_la1[24] = jj_gen;
                break label_11;
              }
              jj_consume_token(COMMA);
              expression();
            }
            break;
          default:
            jj_la1[25] = jj_gen;
            ;
          }
          jj_consume_token(CLOSEPAREN);
                                        hasCall = true;
          break;
        default:
          jj_la1[26] = jj_gen;
          ;
        }
                          jjtree.closeNodeScope(jjtn001,  hasName);
                          jjtc001 = false;
                                jjtn001._methodName = name;
      } catch (Throwable jjte001) {
          if (jjtc001) {
            jjtree.clearNodeScope(jjtn001);
            jjtc001 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte001 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte001;}
          }
          if (jjte001 instanceof ParseException) {
            {if (true) throw (ParseException)jjte001;}
          }
          {if (true) throw (Error)jjte001;}
      } finally {
          if (jjtc001) {
            jjtree.closeNodeScope(jjtn001,  hasName);
          }
      }
    } catch (Throwable jjte002) {
      if (jjtc002) {
        jjtree.clearNodeScope(jjtn002);
        jjtc002 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte002 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte002;}
      }
      if (jjte002 instanceof ParseException) {
        {if (true) throw (ParseException)jjte002;}
      }
      {if (true) throw (Error)jjte002;}
    } finally {
      if (jjtc002) {
        jjtree.closeNodeScope(jjtn002,  ! hasName && hasCall);
      }
    }
  }

  final public void primaryElement() throws ParseException {
int len;
String tidied, x;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMPLEX:
     ASTPtLeafNode jjtn001 = new ASTPtLeafNode(JJTPTLEAFNODE);
     boolean jjtc001 = true;
     jjtree.openNodeScope(jjtn001);
      try {
        jj_consume_token(COMPLEX);
          jjtree.closeNodeScope(jjtn001, true);
          jjtc001 = false;
            try
            {
                x = token.image.toLowerCase();
                len = x.length();
                Double imag = new Double(x.substring(0, len-1 ));
                Complex value = new Complex(0, imag.doubleValue());
                jjtn001._ptToken = new ComplexToken(value);
                jjtn001._isConstant = true;
            } catch (NumberFormatException ee) {
                {if (true) throw new ParseException(
                        "Unable to convert token " + token.image +
                        " to a complex number.");}
            }
      } finally {
     if (jjtc001) {
       jjtree.closeNodeScope(jjtn001, true);
     }
      }
      break;
    case DOUBLE:
     ASTPtLeafNode jjtn002 = new ASTPtLeafNode(JJTPTLEAFNODE);
     boolean jjtc002 = true;
     jjtree.openNodeScope(jjtn002);
      try {
        jj_consume_token(DOUBLE);
          jjtree.closeNodeScope(jjtn002, true);
          jjtc002 = false;
            try
            {
                x = token.image.toLowerCase();
                len = x.length();
                if ( x.endsWith("d") || x.endsWith("f")
                        || x.endsWith("p") ) {
                    // all floating point numbers are double
                    Double value = new Double(x.substring(0, len-1 ));
                    if (x.endsWith("p")) {
                        jjtn002._ptToken =
                          new PetiteToken(value.doubleValue());
                    } else {
                        jjtn002._ptToken =
                            new DoubleToken(value.doubleValue());
                    }
                } else {
                    Double value = new Double(x);
                    jjtn002._ptToken = new DoubleToken(value.doubleValue());
                }
                jjtn002._isConstant = true;
            } catch (NumberFormatException ee) {
                {if (true) throw new ParseException(
                        "Unable to convert token " + token.image +
                        " to an float or double");}
            }
      } finally {
     if (jjtc002) {
       jjtree.closeNodeScope(jjtn002, true);
     }
      }
      break;
    case INTEGER:
     ASTPtLeafNode jjtn003 = new ASTPtLeafNode(JJTPTLEAFNODE);
     boolean jjtc003 = true;
     jjtree.openNodeScope(jjtn003);
      try {
        jj_consume_token(INTEGER);
          jjtree.closeNodeScope(jjtn003, true);
          jjtc003 = false;
            try {
                x = token.image.toLowerCase();
                len = x.length();

                int radix;
                boolean mustBeLong = x.endsWith("l");
                boolean mustBeUnsignedByte = x.endsWith("ub");

                int prefixLength;
                int suffixLength;

                if(mustBeLong) {
                    suffixLength = 1;
                } else if(mustBeUnsignedByte) {
                    suffixLength = 2;
                } else {
                    suffixLength = 0;
                }

                if (x.startsWith("0x") ) {
                    // Input is a hex number.
                    radix = 16;
                    prefixLength = 2;
                } else if(x.startsWith("0")) {
                    // Input is an octal number.
                    radix = 8;
                    prefixLength = 0;
                } else {
                    // Input is a decimal number.
                    radix = 10;
                    prefixLength = 0;
                }

                // Strip off the radix prefix and the length suffix.
                x = x.substring(prefixLength, len - suffixLength);

                if (mustBeLong) {
                    // If the size was specified as long, then create a long.
                    jjtn003._ptToken = new LongToken(Long.parseLong(x, radix));
                } else if (mustBeUnsignedByte) {
                    // If the size was specified as unsignedbyte, 
                    // then create an unsigned byte, truncating if necessary.
                    jjtn003._ptToken =
                        new UnsignedByteToken(Integer.parseInt(x, radix));
                } else {
                    // Try to infer the size.  Inferred sizes are at least
                    // integer.
                    try {
                        jjtn003._ptToken =
                            new IntToken(Integer.parseInt(x, radix));
                    } catch (NumberFormatException nfe) {
                        jjtn003._ptToken =
                            new LongToken(Long.parseLong(x, radix));
                    }
                }
                jjtn003._isConstant = true;
            } catch (NumberFormatException ee) {
                {if (true) throw new ParseException(
                        "Unable to convert token " + token.image +
                        " to an integer or long");}
            }
      } finally {
     if (jjtc003) {
       jjtree.closeNodeScope(jjtn003, true);
     }
      }
      break;
    case STRING:
     ASTPtLeafNode jjtn004 = new ASTPtLeafNode(JJTPTLEAFNODE);
     boolean jjtc004 = true;
     jjtree.openNodeScope(jjtn004);
      try {
        jj_consume_token(STRING);
        jjtree.closeNodeScope(jjtn004, true);
        jjtc004 = false;
        // Check to see that the start and the end are the same.
        String start = token.image.substring(0, 1);
        if(!token.image.endsWith(start)) {
            {if (true) throw new ParseException(
                    "Found unterminated string: " + token.image);}
        }

        // Now cut the " from each end of the string.
        len = token.image.length();
        tidied = token.image.substring(1, (len -1));

        // Resolve escape sequences in the string.
        StringTokenizer st = new StringTokenizer(tidied, "\\", true);
        boolean escape = false;
        x = new String();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (escape) {
                // The previous character was a backslash that started
                // an escape sequence.
                escape = false;
                int trailingCharIndex = 1;
                switch (tok.charAt(0)) {
                    case 'n': x += "\n"; break;
                    case 't': x += "\t"; break;
                    case 'b': x += "\b"; break;
                    case 'r': x += "\r"; break;
                    case 'f': x += "\f"; break;
                    case '\\': x += "\\"; break;
                    case '\'': x += "\'"; break;
                    case '"': x += "\""; break;
                    case '0':
                    case '1':
                    case '2':
                    case '3':
                    case '4':
                    case '5':
                    case '6':
                    case '7':
                        // The escape sequence is a character
                        // specified in octal.
                        int i;
                        for (i = 1; i < tok.length(); i++) {
                            // The octal sequence stops at the first
                            // non-octal character.
                            char c = tok.charAt(i);
                            if (! (c == '0' ||
                                   c == '1' ||
                                   c == '2' ||
                                   c == '3' ||
                                   c == '4' ||
                                   c == '5' ||
                                   c == '6' ||
                                   c == '7'))
                                break;
                        }
                        trailingCharIndex = i;
                        int octVal = Integer.parseInt(
                                tok.substring(0, trailingCharIndex), 8);
                        x += (char)octVal;
                        break;
                    default:
                        {if (true) throw new ParseException("Unknown backslash sequence: "
                                + "\\" + tok);}
                }
                if (trailingCharIndex < tok.length()) {
                    // Keep any remaining characters.
                    x += tok.substring(trailingCharIndex);
                }
            }
            else if (tok.equals("\\")) {
                // Start an escape sequence.
                escape = true;
            }
            else {
                // Keep regular text.
                x += tok;
            }
        }
        if(escape) {
            {if (true) throw new ParseException("Unterminated backslash sequence in " +
                    "string: " + token.image);}
        }

        jjtn004._ptToken = new StringToken(x);
        jjtn004._isConstant = true;
      } finally {
     if (jjtc004) {
       jjtree.closeNodeScope(jjtn004, true);
     }
      }
      break;
    case BOOLEAN:
     ASTPtLeafNode jjtn005 = new ASTPtLeafNode(JJTPTLEAFNODE);
     boolean jjtc005 = true;
     jjtree.openNodeScope(jjtn005);
      try {
        jj_consume_token(BOOLEAN);
        jjtree.closeNodeScope(jjtn005, true);
        jjtc005 = false;
          if (token.image.equalsIgnoreCase("TRUE")) {
              jjtn005._ptToken = BooleanToken.TRUE;
          } else if (token.image.equalsIgnoreCase("FALSE")) {
              jjtn005._ptToken = BooleanToken.FALSE;
          }
          jjtn005._isConstant = true;
      } finally {
     if (jjtc005) {
       jjtree.closeNodeScope(jjtn005, true);
     }
      }
      break;
    default:
      jj_la1[27] = jj_gen;
      if (jj_2_3(2147483647)) {
        jj_consume_token(OPENPAREN);
        expression();
        jj_consume_token(CLOSEPAREN);
      } else if (jj_2_4(2147483647)) {
        matrixConstruct();
      } else if (jj_2_5(2147483647)) {
        recordConstruct();
      } else if (jj_2_6(2147483647)) {
        unionConstruct();
      } else if (jj_2_7(2147483647)) {
        nilArrayConstruct();
      } else if (jj_2_8(2147483647)) {
        arrayConstruct();
      } else if (jj_2_9(2147483647)) {
        function();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
        case SMID:
        case SMIDBRACE:
        case SMIDPAREN:
          identifier();
          break;
        default:
          jj_la1[28] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void functionDefinition() throws ParseException {
 /*@bgen(jjtree) PtFunctionDefinitionNode */
  ASTPtFunctionDefinitionNode jjtn000 = new ASTPtFunctionDefinitionNode(JJTPTFUNCTIONDEFINITIONNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(FUNCTION);
      jj_consume_token(OPENPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        jj_consume_token(ID);
                        jjtn000._argList.add(token.image);
        optTypeSpecifier();
        label_12:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[29] = jj_gen;
            break label_12;
          }
          jj_consume_token(COMMA);
          jj_consume_token(ID);
                                 jjtn000._argList.add(token.image);
          optTypeSpecifier();
        }
        break;
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      jj_consume_token(CLOSEPAREN);
      expression();
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            // A hack for type specification, since we don't have types in
            // the syntax.
            ParseTreeTypeInference inference = new ParseTreeTypeInference();
            int argCount = jjtn000.getArgumentNameList().size();
            jjtn000._argTypes = new ptolemy.data.type.Type[argCount];
            for(int i = 0; i < argCount; i++) {
                ASTPtRootNode argChild = ((ASTPtRootNode)jjtn000.jjtGetChild(i));
                ptolemy.data.type.Type type = inference.inferTypes(argChild);
                jjtn000._argTypes[i] = type;
            }
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void optTypeSpecifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLON:
      jj_consume_token(COLON);
      funcIf();
      break;
    default:
      jj_la1[31] = jj_gen;
        ASTPtLeafNode node = new ASTPtLeafNode(JJTPTLEAFNODE);
        node._name = "general";
        node._ptToken = new GeneralToken();
        node._ptType = ptolemy.data.type.BaseType.GENERAL;
        node._isConstant = true;
        jjtree.pushNode(node);
    }
  }

  final public void function() throws ParseException {
 /*@bgen(jjtree) PtFunctionApplicationNode */
  ASTPtFunctionApplicationNode jjtn000 = new ASTPtFunctionApplicationNode(JJTPTFUNCTIONAPPLICATIONNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      identifier();
      jj_consume_token(OPENPAREN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
      case OPENPAREN:
      case OPENBRACE:
      case OPENBRACKET:
      case OPENUNION:
      case BOOL_NOT:
      case BITWISE_NOT:
      case INTEGER:
      case DOUBLE:
      case COMPLEX:
      case BOOLEAN:
      case FUNCTION:
      case ID:
      case STRING:
      case SMID:
      case SMIDBRACE:
      case SMIDPAREN:
        expression();
        label_13:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[32] = jj_gen;
            break label_13;
          }
          jj_consume_token(COMMA);
          expression();
        }
        break;
      default:
        jj_la1[33] = jj_gen;
        ;
      }
      jj_consume_token(CLOSEPAREN);
    } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
    } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
    }
  }

  final public void assignmentIdentifier() throws ParseException {
 /*@bgen(jjtree) PtLeafNode */
 ASTPtLeafNode jjtn000 = new ASTPtLeafNode(JJTPTLEAFNODE);
 boolean jjtc000 = true;
 jjtree.openNodeScope(jjtn000);StringBuffer name;
    try {
      jj_consume_token(ID);
        // Store the name of this identifier...  This will be the
        // name of a variable, a constant, or an undefined identifier.
        // Note that this name is not actually resolved into a value
        // until the parse tree is evaluated.
        name = new StringBuffer(token.image);
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PERIOD:
          ;
          break;
        default:
          jj_la1[34] = jj_gen;
          break label_14;
        }
        jj_consume_token(PERIOD);
        jj_consume_token(ID);
        name.append(".");
        name.append(token.image);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OPENPAREN:
        jj_consume_token(OPENPAREN);
        jj_consume_token(INTEGER);
        name.append("(");
        name.append(token.image);
        name.append(")");
        jj_consume_token(CLOSEPAREN);
        break;
      default:
        jj_la1[35] = jj_gen;
        ;
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        jjtn000._name = name.toString();
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void identifier() throws ParseException {
 /*@bgen(jjtree) PtLeafNode */
  ASTPtLeafNode jjtn000 = new ASTPtLeafNode(JJTPTLEAFNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ID:
        jj_consume_token(ID);
        break;
      case SMID:
        jj_consume_token(SMID);
        break;
      case SMIDBRACE:
        jj_consume_token(SMIDBRACE);
        break;
      case SMIDPAREN:
        jj_consume_token(SMIDPAREN);
        break;
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jjtree.closeNodeScope(jjtn000, true);
      jjtc000 = false;
        // Store the name of this identifier...  This will be the
        // name of a variable, a constant, or an undefined identifier.
        // Note that this name is not actually resolved into a value
        // until the parse tree is evaluated.

        // NOTE: Parser constants *are not* evaluated here.  Doing
        // this means that they can shadow other variables in scope,
        // which is bad.
        jjtn000._name = token.image;
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void matrixConstruct() throws ParseException {
 /*@bgen(jjtree) PtMatrixConstructNode */
  ASTPtMatrixConstructNode jjtn000 = new ASTPtMatrixConstructNode(JJTPTMATRIXCONSTRUCTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);int i;
  int nRows = 0;
    try {
      jj_consume_token(OPENBRACKET);
                  ++jjtn000._nColumns; ++nRows;
      funcIf();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CLOSEBRACKET:
      case COMMA:
      case SEPARATOR:
        label_15:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case COMMA:
            ;
            break;
          default:
            jj_la1[37] = jj_gen;
            break label_15;
          }
          jj_consume_token(COMMA);
                ++jjtn000._nColumns;
          funcIf();
        }
        label_16:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SEPARATOR:
            ;
            break;
          default:
            jj_la1[38] = jj_gen;
            break label_16;
          }
          jj_consume_token(SEPARATOR);
                    ++nRows; i = 0;
          funcIf();
                                                 ++i;
          label_17:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case COMMA:
              ;
              break;
            default:
              jj_la1[39] = jj_gen;
              break label_17;
            }
            jj_consume_token(COMMA);
            funcIf();
                         ++i;
          }
        /* Assert that the following rows have the same number of terms as the
         first row. */
        if ( i != jjtn000._nColumns ) {
          {if (true) throw new ParseException("PtParser: error parsing matrix "
                  + "construction, the row "
                  + nRows + " does not have the same number of "
                  + "terms as the first row.");}
        }
        }
        jj_consume_token(CLOSEBRACKET);
                        jjtree.closeNodeScope(jjtn000, true);
                        jjtc000 = false;
                        jjtn000._form = 1; jjtn000._nRows = nRows;
        break;
      case COLON:
        jj_consume_token(COLON);
        funcIf();
        jj_consume_token(COLON);
        funcIf();
        label_18:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SEPARATOR:
            ;
            break;
          default:
            jj_la1[40] = jj_gen;
            break label_18;
          }
          jj_consume_token(SEPARATOR);
                    ++nRows;
          funcIf();
          jj_consume_token(COLON);
          funcIf();
          jj_consume_token(COLON);
          funcIf();
        }
        jj_consume_token(CLOSEBRACKET);
                     jjtree.closeNodeScope(jjtn000, true);
                     jjtc000 = false;
                     jjtn000._form = 2; jjtn000._nRows = nRows;
        break;
      default:
        jj_la1[41] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } catch (Throwable jjte000) {
    if (jjtc000) {
      jjtree.clearNodeScope(jjtn000);
      jjtc000 = false;
    } else {
      jjtree.popNode();
    }
    if (jjte000 instanceof RuntimeException) {
      {if (true) throw (RuntimeException)jjte000;}
    }
    if (jjte000 instanceof ParseException) {
      {if (true) throw (ParseException)jjte000;}
    }
    {if (true) throw (Error)jjte000;}
    } finally {
    if (jjtc000) {
      jjtree.closeNodeScope(jjtn000, true);
    }
    }
  }

  final public void recordConstruct() throws ParseException {
 /*@bgen(jjtree) PtRecordConstructNode */
  ASTPtRecordConstructNode jjtn000 = new ASTPtRecordConstructNode(JJTPTRECORDCONSTRUCTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token x = null;
    try {
      jj_consume_token(OPENBRACE);
      x = jj_consume_token(ID);
                          jjtn000._fieldNames.add(x.image);
      jj_consume_token(SETEQUALS);
      funcIf();
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[42] = jj_gen;
          break label_19;
        }
        jj_consume_token(COMMA);
        x = jj_consume_token(ID);
                           jjtn000._fieldNames.add(x.image);
        jj_consume_token(SETEQUALS);
        funcIf();
      }
      jj_consume_token(CLOSEBRACE);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void unionConstruct() throws ParseException {
 /*@bgen(jjtree) PtUnionConstructNode */
  ASTPtUnionConstructNode jjtn000 = new ASTPtUnionConstructNode(JJTPTUNIONCONSTRUCTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);Token x = null;
    try {
      jj_consume_token(OPENUNION);
      x = jj_consume_token(ID);
                          jjtn000._labelNames.add(x.image);
      jj_consume_token(SETEQUALS);
      funcIf();
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[43] = jj_gen;
          break label_20;
        }
        jj_consume_token(COMMA);
        x = jj_consume_token(ID);
                           jjtn000._labelNames.add(x.image);
        jj_consume_token(SETEQUALS);
        funcIf();
      }
      jj_consume_token(CLOSEUNION);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void arrayConstruct() throws ParseException {
 /*@bgen(jjtree) PtArrayConstructNode */
  ASTPtArrayConstructNode jjtn000 = new ASTPtArrayConstructNode(JJTPTARRAYCONSTRUCTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(OPENBRACE);
      funcIf();
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[44] = jj_gen;
          break label_21;
        }
        jj_consume_token(COMMA);
        funcIf();
      }
      jj_consume_token(CLOSEBRACE);
    } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final public void nilArrayConstruct() throws ParseException {
 /*@bgen(jjtree) PtArrayConstructNode */
  ASTPtArrayConstructNode jjtn000 = new ASTPtArrayConstructNode(JJTPTARRAYCONSTRUCTNODE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
    try {
      jj_consume_token(OPENBRACE);
      jj_consume_token(CLOSEBRACE);
    } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
    }
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_3_8() {
    if (jj_scan_token(OPENBRACE)) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_scan_token(OPENBRACE)) return true;
    if (jj_scan_token(CLOSEBRACE)) return true;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_scan_token(OPENUNION)) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_scan_token(OPENBRACE)) return true;
    if (jj_scan_token(ID)) return true;
    if (jj_scan_token(SETEQUALS)) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_scan_token(FUNCTION)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_scan_token(OPENBRACKET)) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_scan_token(OPENPAREN)) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(ID)) return true;
    if (jj_scan_token(SETEQUALS)) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_scan_token(ID)) return true;
    if (jj_scan_token(OPENPAREN)) return true;
    return false;
  }

  public PtParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[45];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x4150800,0x0,0x0,0x0,0x4150800,0x2000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0xf0000000,0xf0000000,0x0,0x0,0xc00,0xc00,0x7000,0x7000,0x4150800,0x800000,0x400000,0x4150800,0x10000,0x0,0x0,0x400000,0x0,0x1000000,0x400000,0x4150800,0x800000,0x10000,0x0,0x400000,0x0,0x400000,0x0,0x1600000,0x400000,0x400000,0x400000,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x817c1030,0x4000000,0x78000000,0x78000000,0x815c1030,0x0,0x8,0x4,0x80,0x100,0x40,0x3,0x3,0x0,0x0,0x0,0xe00,0xe00,0x0,0x0,0x0,0x0,0x815c1030,0x0,0x0,0x817c1030,0x0,0x11c1000,0x80400000,0x0,0x400000,0x0,0x0,0x817c1030,0x0,0x0,0x80400000,0x0,0x4000000,0x0,0x4000000,0x4000000,0x0,0x0,0x0,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0xa,0x0,0x0,0x0,0xa,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xa,0x0,0x0,0xa,0x0,0x0,0xa,0x0,0x0,0x0,0x0,0xa,0x0,0x0,0xa,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[9];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public PtParser(java.io.InputStream stream) {
     this(stream, null);
  }
  public PtParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new PtParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 45; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 45; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public PtParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new PtParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 45; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 45; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public PtParser(PtParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 45; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(PtParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 45; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[70];
    for (int i = 0; i < 70; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 45; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 70; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 9; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
