/** Image Crop is an image manipulation actor for cropping the desired
 * image into a smaller image.
 * Copyright (c) 2004 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package util;


import ptolemy.actor.TypedAtomicActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.data.StringToken;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.*;
import ptolemy.data.type.BaseType;
import ptolemy.data.ObjectToken;
import ptolemy.data.AWTImageToken;
import ptolemy.data.expr.Parameter;
import ptolemy.data.expr.StringParameter;
import ptolemy.actor.parameters.PortParameter;
import ptolemy.data.*;

import java.awt.*;
import java.awt.image.*;
import java.net.*;
import javax.imageio.*;
import javax.swing.*;
import java.io.*;
import java.util.*;
import java.lang.Float;

//For JAI usage
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.KernelJAI;

/**
 * ImageSharpen can be used to sharpen an image to the
 * desired level.
 *
 @author Nandita Mangal
 @version $Id: ImageCrop.java,v 1.1 2005/11/02 00:21:52
 @category.name Image Manipulation
 */

public class ImageSharpen extends TypedAtomicActor
{

    ///////////////////////////////////////////////////////////////////////
    ////                   Parameters and Ports                       ////

    /*
     * Sharpen an Image
     */
    public PortParameter sharpenLevel;

    /*
     * The input image to be manipulated
     */
    public TypedIOPort imgSrc;

    /*
     * The output manipulated image
     */
    public TypedIOPort imgDest;


  /**
   * constructor for ImageCrop with the given container and name.
   *
   *@param  container                     The container.
    *@param  name                          The name of this actor.
   *@exception  IllegalActionException    If the actor cannot be contained
   *   by the proposed container.
   *@exception  NameDuplicationException  If the container already has an
   *   actor with this name.
   */
  public ImageSharpen(CompositeEntity container, String name)
    throws
      NameDuplicationException, IllegalActionException
  {
    super(container, name);

         imgSrc = new TypedIOPort(this, "Source Image", true, false);
	 imgSrc.setTypeEquals(BaseType.OBJECT);
         imgSrc.setMultiport(false);

         sharpenLevel = new PortParameter(this,"Choose Sharpen Level:");
	 sharpenLevel.setExpression("1");
         sharpenLevel.addChoice("2");
         sharpenLevel.addChoice("3");
         sharpenLevel.addChoice("4");



         imgDest = new TypedIOPort(this, "Dest Image", false, true);
	 imgDest.setTypeEquals(BaseType.OBJECT);
         imgDest.setMultiport(false);

  }
    ////////////////////////////////////////////////////////////////////////
    ////                 public methods                                ////


  /**
   * The source image is retrieved from the input port of the actor
   * and a JAI PlanarImage is created from the input image.
   * After calculating, the cropped image's specifications such
   * as width,height,Co-ordinates the image is cropped with the JAI.create
   * operator.
   *@exception  IllegalActionException  If there is no director.
   */
  public void fire()
    throws IllegalActionException
  {
    super.fire();
    PlanarImage input=null;
    Object inputToken = imgSrc.get(0);

    if(inputToken instanceof AWTImageToken)
    {
    	Image src = (Image)((AWTImageToken)inputToken).getValue();
    	input= JAI.create("awtimage",src);
    }
    else if (inputToken instanceof ObjectToken)
    {
	input =(PlanarImage)((ObjectToken)inputToken).getValue();

    }


    sharpenLevel.update();
    int kernelSize = 0;
    Token t = sharpenLevel.getToken();
    if(t instanceof IntToken)
	  kernelSize = ((IntToken)t).intValue();

    float sharpMatrix[ ] = { -1.0f,-1.0f,-1.0f,
			     -1.0f,9.0f,-1.0f,
                             -1.0f,-1.0f,-1.0f};
     KernelJAI sharpKernel = new KernelJAI(3,3,sharpMatrix);


     for(int i=0;i<kernelSize;i++)
     {
          input = JAI.create("convolve", input, sharpKernel);

     }


      imgDest.broadcast(new ObjectToken(input));



  }

  /**
   * Post fire the actor. Return false to indicate that the
   * process has finished. If it returns true, the process will
   * continue indefinitely.
   *
   *@return
   */
  public boolean postfire()
  {
    return false;
  }

  /**
   * Pre fire the actor.
   *  Calls the super class's prefire in case something is set there.
   *
   *@return
   *@exception  IllegalActionException
   */
  public boolean prefire()
    throws IllegalActionException
  {
    return super.prefire();
  }




}
