/**
 *  '$RCSfile: EcoGridFTPClient.java,v $'
 *    Purpose: A Class that implements replication for metacat
 *  Copyright: 2000 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *    Authors: Jing Tao
 *    Release: @release@
 *
 *   '$Author: rspears $'
 *     '$Date: 2004-06-10 13:08:17 $'
 * '$Revision: 1.3 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid;

import org.globus.ftp.DataChannelAuthentication; 
import org.globus.ftp.GridFTPClient; 
import org.globus.ftp.GridFTPSession; 
import org.ietf.jgss.GSSCredential; 

/**
 * This class will represent a grid ftp client - host name, port number 
 * and other transter setting
 */
public class EcoGridFTPClient extends GridFTPClient
{
        
    // constant for buffusize 
    private static final int PROTECTIONBUFFERSIZE   = 16384;
    
    /**
     * Constructor
     * @param hostName the name of host -- dev.nceas.ucsb.edu
     * @param portNumber the number of host -- 5678
     * @param cred the credential for this client
     */
    public EcoGridFTPClient(String hostName, int portNumber, 
                          GSSCredential cred) throws Exception
    {
      super(hostName, portNumber);
      super.authenticate(cred); //authenticating 
      super.setProtectionBufferSize(PROTECTIONBUFFERSIZE); //buffersize 
      super.setType(GridFTPSession.TYPE_IMAGE); //transfertype 
      super.setMode(GridFTPSession.MODE_EBLOCK); //transfermode 
      super.setDataChannelAuthentication(DataChannelAuthentication.SELF); 
      super.setDataChannelProtection(GridFTPSession.PROTECTION_SAFE); 
    }//EcoGridFTPClient
    
   
 
}//EcoGridURLCopy
