/**
 *  '$RCSfile: EcoGridFTPTransfer.java,v $'
 *    Purpose: A Class that implements replication for metacat
 *  Copyright: 2000 Regents of the University of California and the
 *             National Center for Ecological Analysis and Synthesis
 *    Authors: Jing Tao
 *    Release: @release@
 *
 *   '$Author: rspears $'
 *     '$Date: 2004-06-10 13:08:18 $'
 * '$Revision: 1.4 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid;

import org.apache.axis.types.URI;

import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.FileRandomIO; 
import org.globus.ftp.MarkerListener;

import org.ietf.jgss.GSSCredential; 

import java.io.RandomAccessFile;

 

/**
 * This class will handle file trnasfer: from client to server, from server
 * to client, and thirdpartytransfer (from a ftpserver to another ftpserver)
 */
public class EcoGridFTPTransfer 
{
  //attributes
  private int transferType = -1;
  private String sourceScheme = null;
  private String sourceHost = null;
  private int sourcePort = -1;
  private String sourceFilePath = null;
  private String destinationScheme = null;
  private String destinationHost = null;
  private int destinationPort = -1;
  private String destinationFilePath = null;
  private GSSCredential cred = null;
  
  private static final int FAIL = 0;
  private static final int SUCCESS = 1;
  /**
   * Constructor of EcoGridFTPTRansfer. From scheme, we know the transfer type
   * @param sourceURI  source uri
   * @param destURI  destination uri
   */
  public EcoGridFTPTransfer(URI sourceURI, URI destURI, GSSCredential credt)
                            throws Exception
  {
    if (sourceURI == null || destURI == null)
    {
      
    }
    cred = credt;
    //get the source url info
    sourceScheme = sourceURI.getScheme();
    System.out.println("source scheme in sourceURI is " +sourceScheme);
    sourceHost = sourceURI.getHost();
    System.out.println("source host in sourceURI is "+sourceHost);
    sourcePort = sourceURI.getPort();
    System.out.println("source port in sourceURI is "+sourcePort);
    sourceFilePath = sourceURI.getPath();
    System.out.println("source file path in sourceURI is " + sourceFilePath);
    //get the destination url info
    destinationScheme = destURI.getScheme();
    System.out.println("destination scheme in destinationURI is " +
                        destinationScheme);
    destinationHost = destURI.getHost();
    System.out.println("destination host in destinationURI is " + 
                       destinationHost);
    destinationPort = destURI.getPort();
    System.out.println("destination port in destinationURI is " + 
                       destinationPort);
    destinationFilePath = destURI.getPath();
    System.out.println("destination path in destinationURI is " + 
                       destinationFilePath);
    checkTransferType();
  }
  
  /**
   * Get the transfer type
   */
  public int getTransferType()
  {
    return transferType;
  }
   
  
  /*
   * Method decice which transfer need to handle base one source scheme and
   * destintation scheme
   *  1-- client to server
   *  2-- server to client
   *  3-- third party
   */
   private int checkTransferType()
                                 throws Exception
   {
     //make sure the parameter is not null
     if (sourceScheme == null || destinationScheme == null)
     {
       throw new Exception("Should specify scheme in source" + 
                           " or destionation URI in get method");
     }
     
     if (sourceScheme.equals(EcoGridConstant.FILESCHEME) && 
         destinationScheme.equals(EcoGridConstant.GSIFTPSCHEME))
     {
       // it is client(file scheme) to server (gsiftp)
       transferType = EcoGridConstant.CLIENTTOSERVER;
       System.out.println("it is client to server type");
     }
     else if (sourceScheme.equals(EcoGridConstant.GSIFTPSCHEME) && 
              destinationScheme.equals(EcoGridConstant.FILESCHEME))
     {
       // it is server to client
       transferType = EcoGridConstant.SERVERTOCLIENT;
       System.out.println("it is server to client type");
     }
     else if (sourceScheme.equals(EcoGridConstant.GSIFTPSCHEME) && 
              destinationScheme.equals(EcoGridConstant.GSIFTPSCHEME))
     {
       // it is third party server to server
       transferType = EcoGridConstant.THIRDPARTY;
       System.out.println("it is third party type");
     }
     else
     {
       // Unsupport scheme
       System.out.println("unkonw type");
       throw new Exception("Unsupport scheme for transfer: " + sourceScheme +
                           " or " + destinationScheme);
     }
     
     return transferType;
   }
   
   /**
    * Method will do different transfer by on transfer type:
    * client to server
    * server to client
    * third party
    */
   public int transfer() throws Exception
   {
      System.out.println("the transferType is " + transferType);
      int flag = FAIL;
      if (transferType == EcoGridConstant.CLIENTTOSERVER )
      {
         System.out.println("in client to server transfer");
         flag = transferFromClientToServer();
      }
      else if (transferType == EcoGridConstant.SERVERTOCLIENT)
      {
        System.out.println("in server to client transfer");
        flag = transferFromServerToClient();
      }
      else if (transferType == EcoGridConstant.THIRDPARTY)
      {
        System.out.println("in third party tansfer");
        flag = thridPartyTransfer();
      }
      else
      {
        System.out.println("in unkown tansfer");
        throw new Exception("Unkown transfer");
      }
      return flag;
   }
   /*
    * Method to upload a file from client to server. Return 1 success, return 0
    * fails.
    */     
   private int transferFromClientToServer()
   {
     // flag indicate success or fail
     int flag = FAIL;
     // only run transferType is clientoserver
     if (transferType == EcoGridConstant.CLIENTTOSERVER)
     {
       System.out.println(" start tansfer from client to server");
       try
       {
         System.out.println("before instantial ftp client");
         EcoGridFTPClient client = 
                  new EcoGridFTPClient(destinationHost, destinationPort, cred);
         System.out.println("after instantial ftp client");
         DataSource datasource = null; 
         System.out.println("before instantial data source");
         datasource =
                  new FileRandomIO(new RandomAccessFile(sourceFilePath, "rw"));
         System.out.println("after instantial data source");
         System.out.println("before extendput");
         client.extendedPut(destinationFilePath, datasource, null);
         System.out.println("after extendput");
         System.out.println("before close");
         client.close();
         System.out.println("after close");
         flag = SUCCESS;
       
       }//try
       catch (Exception e)
       {
         System.out.println("Error: " + e.getMessage());
       }//catch
     }//if
     return flag;
   }//transferFromClientToServer
  
  
   /*
    * Method to download a file from server to client  Return 1 success, return 0
    * fails.
    */     
  private int transferFromServerToClient()
  {
     int flag = FAIL;
     //only do if transfertype is server to client
     if (transferType == EcoGridConstant.SERVERTOCLIENT)
     {
       System.out.println("start sever to client transfer...");
       try
       {
         System.out.println("start ftp object");
         System.out.println("hostname is " + sourceHost);
         System.out.println("portNumber is " + sourcePort);
         EcoGridFTPClient client = 
                          new EcoGridFTPClient(sourceHost, sourcePort, cred);
         System.out.println("after create client object");
         long size = client.getSize(sourceFilePath);
         System.out.println("the size of remote file is " + size);
         DataSink sink = null; 
         sink = new FileRandomIO(new RandomAccessFile(destinationFilePath, "rw")); 
         //setting FTPClient to active so be able to send file 
         client.setLocalPassive(); 
         client.setActive();
         System.out.println("start extentedGet...");
         client.extendedGet(sourceFilePath, size, sink, null);
         System.out.println("after extenedGet...");
         client.close();
         System.out.println("close the transfer...");
         flag = SUCCESS;
       }//try
       catch (Exception e)
       {
         System.out.println("Error: " + e.getMessage());
       }//catch
     }//if
     return flag;
  }//transferFromServerToClient
  
  /*
    * Method to transfer a file from server to server  Return 1 success, 
    * return 0 fails.
    */     
   private int thridPartyTransfer()
  {
   int flag = FAIL;
   // only do if transfer type is third party
   if (transferType == EcoGridConstant.THIRDPARTY)
   {
     try
     {
       //init source client
       EcoGridFTPClient sClient = 
                          new EcoGridFTPClient(sourceHost, sourcePort, cred);
       //init dest client
       EcoGridFTPClient dClient = 
                  new EcoGridFTPClient(destinationHost, destinationPort, cred);
       // tansfer
       boolean append = false;
       MarkerListener mListener = null;
       System.out.println("before transfer ....");
       System.out.println("source file path is " + sourceFilePath);
       System.out.println("destination file path is " + destinationFilePath);
       //srcFile, destFTp, destFile, boolean append, MarkerListener mListener
       sClient.transfer(sourceFilePath, dClient, destinationFilePath, 
                       append, mListener);
       System.out.println("after transfer ....");
       flag = SUCCESS;
     }
     catch (Exception e)
     {
       System.out.println("Error: " + e.getMessage());
     }
   }//if
   return flag;
 }
}//EcoGridFTPTransfer
