/**
 *    '$RCSfile: AuthenticationServiceClient.java,v $'
 *
 *     '$Author: tao $'
 *       '$Date: 2008-01-31 01:52:54 $'
 *   '$Revision: 1.2 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2007 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.ecogrid.client;

import org.ecoinformatics.ecogrid.EcogridUtils;

import org.ecoinformatics.ecogrid.auth.stub.AuthenticationServicePortType;
import org.ecoinformatics.ecogrid.auth.stub.AuthenticationServiceLocator;
import org.ecoinformatics.ecogrid.auth.stub.AuthenticationServiceLoginRequestElementType;

/**
 * authentication client for the ecogrid
 */
public class AuthenticationServiceClient
{
  private String serviceURL = null;
  private AuthenticationServicePortType ecogrid = null;

  /**
   *  The main program for the AuthenticationServiceClient class
   *
   *@param  args  The command line arguments
   */
  public static void main(String[] args)
  {
    String opMode = "";
    String userName = "";
    String passWord = "";
    String sessionId = "";
    String gsh_str = "";
    String retStr;

    if(args.length <= 0)
    {
      PrintAuthUsage();
      System.exit(0);
    }
    else
    {
      opMode = args[0];

      if(opMode.compareToIgnoreCase("login") == 0)
      {
      	System.out.println("Logging in");
        if(args.length != 4)
        {
          PrintAuthUsage();
          System.exit(0);
        }
        userName = args[1];
        passWord = args[2];
        gsh_str = args[3];
      }
      else if(opMode.compareToIgnoreCase("logout") == 0)
      {
    	System.out.println("Logging out");
        if(args.length != 3)
        {
          PrintAuthUsage();
          System.exit(0);
        }
        sessionId = args[1];
        gsh_str = args[2];
      }
      else if(opMode.compareToIgnoreCase("validateSession") == 0)
      {
        System.out.println("validating session");
        if(args.length != 3)
        {
          PrintAuthUsage();
          System.exit(0);
        }
        sessionId = args[1];
        gsh_str = args[2];
      }
      else
      {
        PrintAuthUsage();
        System.exit(0);
      }
    } 

    try
    {

      // create a client object
      AuthenticationServiceClient client = new AuthenticationServiceClient(gsh_str);
      if(opMode.compareToIgnoreCase("login") == 0)
      {
        client.login_action(userName, passWord);
      }
      else if(opMode.compareToIgnoreCase("logout") == 0)
      {
        client.logout_action(sessionId);
      }
      else if(opMode.compareToIgnoreCase("validateSession") == 0)
      {
        client.validate_session_action(sessionId);
      }
    }
    catch(Exception e)
    {
      // System.out.println("Exception in main : "+ e.getMessage());
      e.printStackTrace();
    }

  }
  //main

  /**
   *  Constructor for the AuthenticationServiceClient object
   *
   *@param  serviceGSH     Description of the Parameter
   *@exception  Exception  Description of the Exception
   */
  public AuthenticationServiceClient(String serviceGSH)
    throws Exception
  {
    this.serviceURL = serviceGSH;
    EcogridUtils.setDebug(true);
    // Get a reference to the AuthenticationService Factory
    long startFactory = System.currentTimeMillis();

    AuthenticationServiceLocator loc = 
    	new AuthenticationServiceLocator();

    ecogrid = loc.getLogin(new java.net.URL(serviceURL));

    org.apache.axis.client.Stub stub = (org.apache.axis.client.Stub)ecogrid;

    stub.setTimeout(10000000);
    long endInstance = System.currentTimeMillis();

    EcogridUtils.debugMessage("The time to create instance is =========== " +
        (endInstance - startFactory) / 1000, 30);
  }

  /**
   * login to the ecogrid and get a sessionid
   * 
   *@param  UserName       Description of the Parameter
   *@param  PassWord       Description of the Parameter
   *@return                Description of the Return Value
   *@exception  Exception  Description of the Exception
   */
  public String login_action(String UserName, String PassWord)
    throws Exception
  {
    String retStr;

    AuthenticationServiceLoginRequestElementType loginReq = new AuthenticationServiceLoginRequestElementType();
    loginReq.setUserName(UserName);
    loginReq.setPassWd(PassWord);
    retStr = ecogrid.login(loginReq);

    System.out.println("AuthenticationServiceClient.login_action - return string: " + retStr);
    return retStr;
  }

  /**
   * logout of a current session
   * 
   *@param  SessionId      Description of the Parameter
   *@exception  Exception  Description of the Exception
   */
  public String logout_action(String SessionId)
    throws Exception
  {
    String retStr;
    retStr = ecogrid.logout(SessionId);
    return retStr;
  }
  
  /**
   * login to the ecogrid and get a sessionid
   * 
   *@param  UserName       Description of the Parameter
   *@param  PassWord       Description of the Parameter
   *@return                Description of the Return Value
   *@exception  Exception  Description of the Exception
   */
  public String validate_session_action(String sessionId)
    throws Exception
  {
    String retStr;
    System.out.println("AuthenticationServiceClient.validate_session_action - validating session: " + sessionId);

    retStr = ecogrid.validateSession(sessionId);

    System.out.println("AuthenticationServiceClient.validate_session_action - return string: " + retStr);
    return retStr;
  }


  /**
   * print the usage statement
   */
  private static void PrintAuthUsage()
  {
    System.out.println("Usage: java org.ecoinformatics.ecogrid.client.AuthenticationServiceClient login userName passWord GSH");
    System.out.println("Usage: java org.ecoinformatics.ecogrid.client.AuthenticationServiceClient logout sessionId GSH");
    System.out.println("Usage: java org.ecoinformatics.ecogrid.client.AuthenticationServiceClient validateSession sessionId GSH");
  }

}

