/**
 *    '$RCSfile: PutServiceClient.java,v $'
 *
 *     '$Author: leinfelder $'
 *       '$Date: 2008-01-22 22:44:06 $'
 *   '$Revision: 1.2 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2007 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.ecogrid.client;

import java.io.FileInputStream;

import org.ecoinformatics.ecogrid.EcogridObjType;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.put.stub.PutServicePortType;
import org.ecoinformatics.ecogrid.put.stub.PutServiceLocator;
import org.ecoinformatics.ecogrid.put.stub.PutServiceElementType;

/**
 * client to put documents into the ecogrid
 */
public class PutServiceClient
{
  private final static int QUERY_OPERATION = 1;
  private final static int GET_OPERATION = 2;

  private String serviceURL = null;
  private PutServicePortType ecogrid = null;

  /**
   *  The main program for the PutServiceClient class
   *
   *@param  args  The command line arguments
   */
  public static void main(String[] args)
  {
    if(args.length < 5)
    {
      System.out.println("Usage: java org.ecoinformatics.ecogrid.client.PutServiceClient obj_type filename ecogrid_obj_id sessionId GSH");
      System.out.println("       where obj_type is \"data\" or \"metadata\".");
      System.exit(0);
    }

    System.out.println("datatype is: " + args[0]);
    System.out.println("localfilename is: " + args[1]);
    System.out.println("ecogrid object ID is:" + args[2]);
    System.out.println("GSH is: " + args[4]);

    int objType = EcogridObjType.DATA;
    String strObjType = args[0];
    if(strObjType.compareToIgnoreCase("data") == 0)
    {
      objType = EcogridObjType.DATA;
    }
    else if(strObjType.compareToIgnoreCase("metadata") == 0)
    {
      objType = EcogridObjType.METADATA;
    }
    else
    {
      System.out.println("Unknow object type ==> " + args[0] + ". The object type is either \"data\" or \"metadata\".");
      System.exit(0);
    }

    try
    {
      // get argument
      String fileName = args[1];
      String ecogridObjId = args[2];
      String sessionId = args[3];
      String GSH = args[4];

      // create a client object
      PutServiceClient client = new PutServiceClient(GSH);

      client.put(fileName, ecogridObjId, objType, sessionId);
    }
    catch(Exception e)
    {
      // System.out.println("Exception in main : "+ e.getMessage());
      e.printStackTrace();
    }

  }
  //main

  /**
   *  Constructor for the PutServiceClient object
   *
   *@param  serviceGSH     Description of the Parameter
   *@exception  Exception  Description of the Exception
   */
  public PutServiceClient(String serviceGSH)
    throws Exception
  {
    this.serviceURL = serviceGSH;
    // Get a reference to the PutServiceClient Factory
    long startFactory = System.currentTimeMillis();

    PutServiceLocator loc = 
    	new PutServiceLocator();

    ecogrid = loc.getPut(new java.net.URL(serviceURL));

    org.apache.axis.client.Stub stub = (org.apache.axis.client.Stub)ecogrid;

    stub.setTimeout(10000000);
    long endInstance = System.currentTimeMillis();

    EcogridUtils.debugMessage("The time to create instance is =========== " +
        (endInstance - startFactory) / 1000, 30);
  }

  /**
   * put a file
   * 
   *@param  fileName       Description of the Parameter
   *@param  ecogridOgjId   Description of the Parameter
   *@param  objType        Description of the Parameter
   *@param  sessionId      Description of the Parameter
   *@exception  Exception  Description of the Exception
   */
  public void put(String fileName, String ecogridOgjId, int objType, String sessionId)
    throws Exception
  {
    byte[] bytes;

    bytes = GetBytesFromFile(fileName);

    // debug code: test if the bytes are goos.
    /*
     *  FileOutputStream fout = new FileOutputStream("fun.fun");
     *  fout.write(bytes, 0, bytes.length);
     *  fout.close();
     */
    PutServiceElementType putElement = new PutServiceElementType(bytes, ecogridOgjId, fileName, objType, sessionId);
    ecogrid.put(putElement);
  }

  /**
   * put a byte array
   * 
   *@param  bytes          Description of the Parameter
   *@param  ecogridOgjId   Description of the Parameter
   *@param  objName        Name of the [file] object
   *@param  objType        Description of the Parameter
   *@param  sessionId      Description of the Parameter
   *@exception  Exception  Description of the Exception
   */
  public void put(byte[] bytes, String ecogridOgjId, String objName, int objType, String sessionId)
    throws Exception
  {
	  PutServiceElementType putElement = new PutServiceElementType(bytes, ecogridOgjId, objName, objType, sessionId);
	  ecogrid.put(putElement);
  }
  
  /**
   * put some bytes (no filename, even!)  this is to allow use without providing a name
   * for the putElement
   * @param bytes
   * @param ecogridOgjId
   * @param objType
   * @param sessionId
   * @throws Exception
   */
  public void put(byte[] bytes, String ecogridOgjId, int objType, String sessionId) 
  throws Exception {
	  PutServiceElementType putElement = new PutServiceElementType(bytes, ecogridOgjId, null, objType, sessionId);
	  ecogrid.put(putElement);
}

  /**
   * get the bytes from a file
   * 
   *@param  fileName  Description of the Parameter
   *@return           Description of the Return Value
   */
  byte[] GetBytesFromFile(String fileName) throws Exception
  {
    byte[] readBytes = new byte[2000];
    int n;
    int i;

    byte[] total_bytes = null;
    byte[] tmp_bytes = null;
    int cur_byte_cnt;
    try
    {
      FileInputStream file = new FileInputStream(fileName);
      n = file.read(readBytes, 0, 2000);
      cur_byte_cnt = 0;
      while(n > 0)
      {
        if(total_bytes == null)
        {
          total_bytes = new byte[n];
          for(i = 0; i < n; i++)
          {
            total_bytes[i] = readBytes[i];
          }
        }
        else
        {
          tmp_bytes = new byte[total_bytes.length];
          for(i = 0; i < total_bytes.length; i++)
          {
            tmp_bytes[i] = total_bytes[i];
          }

          total_bytes = null;
          total_bytes = new byte[tmp_bytes.length + n];
          for(i = 0; i < tmp_bytes.length; i++)
          {
            total_bytes[i] = tmp_bytes[i];
          }
          for(i = 0; i < n; i++)
          {
            total_bytes[tmp_bytes.length + i] = readBytes[i];
          }

          tmp_bytes = null;
        }

        n = file.read(readBytes, 0, 2000);
      }

      file.close();
    }
    catch(Exception e)
    {
      System.out.println("Exception in reading data from file: " + e.getMessage());
      //System.exit(1);
      throw e;
    }

    return total_bytes;
  }
}

