/****************************************************************************
**
** California Academy of Sciences
**
** FILENAME:      DateUtil.java
**
** CLASS:         DateUtil
**
** PACKAGE:       org.calacademy.digir.util
**
** CREATED BY:    P.J. Schwartz (pschwartz@calacademy.org)
**
** DATE CREATED:  02-Jun-2002
**
****************************************************************************/

// Package
//*********************
// NOTE: This class was borrowed from DiGIR 
//       so we didn't make everyone have the DiGIR src to build this
//package org.calacademy.digir.util;
//*********************

package org.ecoinformatics.ecogrid.digir.impl;



// Imports

import java.util.Date;
import java.text.SimpleDateFormat;
import java.text.ParseException;


// Code

/****************************************************************************
**
** The class DateUtil provides a variety of static utility methods that perform
**	various Date related functions, such as formatting.
**
** @author  P.J. Schwartz (pschwartz@calacademy.org)
** @version $Id: DateUtil.java,v 1.2 2004-02-04 20:20:44 rspears Exp $
**
****************************************************************************/

public class DateUtil
{


   // Constants

	private static final String DIGIR_DATE_FORMAT
	//											= "yyyy-MM-dd'T'HH:mm:ss:SSZ";
												= "yyyy-MM-dd'T'HH:mm:ssZ";


   // Member Variables



   /**
    *  Default Constructor is private, no instance is needed
    */

   private DateUtil()
   {
   }


   /**
    *  Returns a String format, in the DiGIR accepted format, of the date.
	 *
	 *  @param date	date
	 *  @return		String of date in proper format
    */
	public static String formatDate(Date date)
	{

		SimpleDateFormat formatter = new SimpleDateFormat(DIGIR_DATE_FORMAT);
		String interimDate = formatter.format(date);

		//because of formatting differences for GMT offset with java versus
		//XML schema, we need to add a colon before returning.
		//(i.e. java represents offset as -0500 and xml expects it as -05:00)
		int len = interimDate.length();
		String finalDate = interimDate.substring(0,len-2)
									+ ":" + interimDate.substring(len-2);
		

		return finalDate;

	}

   /**
    *  Returns a String format, in the DiGIR accepted format, of the date
	 *  at time of calling (i.e. now).
	 *
	 *  @return		String of date in proper format
    */
	public static String formatNow()
	{
		return formatDate(new Date());
	}


   /**
    *  Returns a Date object as a result of parsing a string representation
	 *  of a date in the DiGIR accepted format.
	 *
	 *  @return		Date object
    */
	public static Date parseDate(String dateStr) throws ParseException
	{
		SimpleDateFormat formatter = new SimpleDateFormat(DIGIR_DATE_FORMAT);
		return formatter.parse(dateStr);
	}

}
