package org.ecoinformatics.ecogrid.queryservice;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.Deserializer;

import org.apache.axis.encoding.Base64;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.ser.Base64Deserializer;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.ecogrid.queryservice.stub.QueryServiceStub;
import org.xml.sax.SAXException;

public class QueryServiceGetToStreamClient extends QueryServiceStub {
    
    static private Log log;
    static private boolean isDebugging;
    
    static {
        log = LogFactory.getLog(QueryServiceGetToStreamClient.class.getName());
        isDebugging = log.isDebugEnabled();
    }
    
    private OutputStream os = null;
    
    
    public QueryServiceGetToStreamClient() throws org.apache.axis.AxisFault {
        super();
    }
    
    public QueryServiceGetToStreamClient(java.net.URL endpointURL ) throws org.apache.axis.AxisFault {
        super(endpointURL,null);
    }
    
    public QueryServiceGetToStreamClient(java.net.URL endpointURL, javax.xml.rpc.Service service) throws org.apache.axis.AxisFault {
        super(endpointURL,service);
    }
    
    public QueryServiceGetToStreamClient(javax.xml.rpc.Service service) throws org.apache.axis.AxisFault {
        super( service );
    }
    
    protected org.apache.axis.client.Call createCall() throws java.rmi.RemoteException {
        org.apache.axis.client.Call _call  = super.createCall();
        
        //
        // We setStreaming to true which turns off the "High Fidelty" options
        // in the MessageContext.  This in turn prevents the SOAP message parser
        // system from "copying" all the SAX events into an internal data structure.
        // Without this, this method takes a whole lot of memory when parsing large
        // structures.
        _call.setStreaming(true);
        
        //
        // Need to tie the ByteStreamDeserializerFactory object into the type mapping
        // registry.  It will be used to deserialze base64Binary datatypes - which is the
        // datatype of the getResponseElement.
        final Class javaType = byte[].class;
        final QName xmlType = new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "base64Binary");
        ByteStreamDeserializerFactory streamDf = new ByteStreamDeserializerFactory(javaType, xmlType);
        SerializerFactory   sf =  BaseSerializerFactory.createFactory(org.apache.axis.encoding.ser.Base64SerializerFactory.class, javaType, xmlType);
        _call.registerTypeMapping( javaType, xmlType, sf, streamDf );
        
        return _call;
    }
    
    public void get(java.lang.String parameter, OutputStream os) throws java.rmi.RemoteException {
        this.os = os;
        Object o  = super.get(parameter);
        return;
    }
    
    public static void main(String[] args)
    {
        if (args.length != 3)
        {
            
            System.out.println("Usage: java  QueryServiceGetToStreamClient <service url> <docid> <outputfile>");
            System.exit(0);
        }
        String GSH = args[0];
        String commandarg = args[1];
        String outputfile = args[2]; 
        try
        {
            URL endpoint = new URL(GSH);
            
            QueryServiceGetToStreamClient client = new QueryServiceGetToStreamClient( endpoint );
            
            String resultStr = null;
            
            System.out.println("start to get docoument");
            OutputStream os = new FileOutputStream(outputfile);
            client.get(commandarg, os);
            os.close();
            System.out.println("after get doc and testing is done");
            
        }
        catch (Exception e)
        {
            System.err.println("Exception in main : " + e.getMessage());
            e.printStackTrace();
        }
        
    }//main
    
    public class ByteStreamDeserializerFactory extends BaseDeserializerFactory {
        
        public ByteStreamDeserializerFactory(Class javaType, QName xmlType) {
            super(Base64Deserializer.class, xmlType, javaType);
        }
        
        public Deserializer getDeserializerAs(String mechanismType) throws JAXRPCException {
            return new ByteStreamDeserializer( javaType, xmlType );
        }
        
    }
    
    public class ByteStreamDeserializer extends SimpleDeserializer {
        
        private int carryoverlength = 0;
        private char[] carryoverchars = new char[4];
        
        public ByteStreamDeserializer( Class javaType, QName xmlType ) {
            super(javaType, xmlType);
        }
        
        /*
         * Process characters and write to output stream.
         * The characters are actually Base64 encoded.  However, the sax parser does not always
         * give us characters at a 4-byte boundary for base 64 encoding.  So we need to process only
         * characters up to the 4-byte boundary, then carry the extra characters over to the next call.
         * The carry over characters are stored in the carryover char[], and the number of characters
         * carried in carryoverlength.
         *  (non-Javadoc)
         * @see org.xml.sax.ContentHandler#characters(char[], int, int)
         */
        public void characters(char[] chars, int start, int length) throws SAXException {
            // Note:  I've used the isDebugging tests around each of these log
            // statements to prevent unnecessary synchronization on the log.debug() call
            // when no debugging.
	    //
	    // Also, need to explictly use the log member variable from
	    // EcogridGetToStreamClient.  The SimpleDeserializer super class
	    // also has a log member variable.
            if ( isDebugging ) {
                QueryServiceGetToStreamClient.log.debug( "Calling characters start = " + start + " length = " + length );
	    }
            try {
                // Test if we have carry over:
                if ( carryoverlength > 0 ) {
                    if ( isDebugging ) {
                        QueryServiceGetToStreamClient.log.debug("We have carryover of " + carryoverlength );
		    }
                    // We have carry over from previous call.
                    // This loop copies over the 4-carryoverlength first characters from chars.
                    while( carryoverlength < 4 ) {
                        if ( isDebugging ) {
                            QueryServiceGetToStreamClient.log.debug( " append to carryover: " + chars[start]);
			}
                        carryoverchars[carryoverlength] = chars[ start ];
                        carryoverlength++;
                        // increment the start position because the character is now in carryoverchars.
                        start++;
                        // decrement the length value because one character has been absorbed.
                        length--;
                    }
                    // Decode these 4 characters.
                    byte[] b = Base64.decode( carryoverchars, 0, 4 );
                    os.write(b);
                }
                
                // Now test if we need to carry over next call:
                carryoverlength = length % 4;
                if ( isDebugging ) {
                    QueryServiceGetToStreamClient.log.debug("New carry over = " + carryoverlength);
		}
                // The last carryoverlength characters will be copied into carryoverchars
                // to be used during the next iteration.
                length -= carryoverlength;
                // i indexes in carryoverchars.  It goes [0,..,carryoverlength)
                // j indexes in chars.  It goes [ start+lenght-carryoverlength,..,start+length)
                for( int i = 0, j = start+ length; i<carryoverlength; i++,j++ ) {
                    carryoverchars[i] = chars[j];
                }
                
                // Decode the caracters.
                byte[] b = Base64.decode(chars, start, length);
                os.write(b);
            }
            catch (IOException e) {
                throw new SAXException("Unable to write to outputstream",e);
            }
            return;
        }
    }
    
}
