/**
 *  '$RCSfile: EcoRegInterface.java,v $'
 *  Copyright: 2004 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *  Purpose: To test the MetaCatURL class by JUnit
 *    Authors: @Rod Spears@
 *    Release: @release@
 *
 *   '$Author: rspears $'
 *     '$Date: 2004-06-10 13:08:18 $'
 * '$Revision: 1.2 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 

package org.ecoinformatics.ecogrid.registry;

/**
 * Interface to Ecogrid registry
 * @author  Rod Spears
 */
public interface EcoRegInterface {
    
  /**
   * Creates an entry in the registry, "name" must be unique
   * @param aName name of service
   * @param aRegName urn name of service
   * @param aRegAddr web address of the service
   * @return status code from EcoRegInterface's error codes
   */
  public int registerEntry(String aName, String aRegName, String aRegAddr);

  /**
   * Updates existing entry the registry database
   * @param aName name of service
   * @param aRegName urn name of service
   * @param aRegAddr web address of the service
   * @return status code from EcoRegInterface's error codes
   */
  public int updateEntry(String aName, String aRegName, String aRegAddr);
  
  /**
   * Removes an entry in the registry, "name" must be unique
   * @param aName name of service
   * @return status code from EcoRegInterface's error codes
   */
  public int removeEntry(String aName);
  
  /**
   * Looks up an entry by name
   * @param aName name of entry to be returned
   * @return returns a RegEntry object
   */
  public RegEntry getEntry(String aName);
  
  /**
   * Looks up a entry by Registration name (URN)
   * @param aRegName name of entry to be returned
   * @return returns a RegEntry object
   */
  public RegEntry getEntryByRegName(String aName);
  
  /**
   * Returns an array list of all registry entries
   * @return returns an XML string of all the entries in the registry
   */
  public RegEntry[] getList();

  /**
   * Returns an XML list of all registry entries
   * @return returns an XML string of all the entries in the registry
   */
  public String getXMLListing();

  /**
   * Returns an XML string representing the entry
   * @param aName name of service
   * @return returns an XML string of all the entries in the registry
   */
  public String getXMLEntryByName(String aName);

  /**
   * Returns an XML string representing the entry
   * @param aRegName name of entry to be returned
   * @return returns an XML string of all the entries in the registry
   */
  public String getXMLEntryByRegName(String aRegName);
  
}
