/**
 *    Purpose: A Class that implements registry service.
 *  Copyright: 2004 Regents of the University of California and
 *             San Diego Supercomputer Center
 *    Authors: Bing Zhu 
 *             Sept 14, 2004
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package org.ecoinformatics.ecogrid.registry.impl;


import java.io.StringReader;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Properties;

import org.apache.log4j.Logger;

import org.ecoinformatics.ecogrid.queryservice.stub.EcoGridQueryInterfaceLevelOnePortType;
import org.ecoinformatics.ecogrid.queryservice.EcogridQueryClient;
import org.ecoinformatics.ecogrid.queryservice.query.ANDType;
import org.ecoinformatics.ecogrid.queryservice.query.ConditionType;
//import org.ecoinformatics.ecogrid.queryservice.query.LimitedXPathExpression;
import org.ecoinformatics.ecogrid.queryservice.query.OperatorType;
import org.ecoinformatics.ecogrid.queryservice.query.ORType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryTypeNamespace;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataNamespace;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeRecord;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadata;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeRecordReturnField;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataSystem;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataRecordStructure;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataRecordStructureReturnField;
import org.ecoinformatics.ecogrid.queryservice.util.EcogridResultsetFactory;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.registry.stub.EcoRegInterfaceLevelOnePortType;
import org.ecoinformatics.ecogrid.registry.stub.EcogridRemoveRegEntryRequestElement;
import org.ecoinformatics.ecogrid.registry.stub.EcogridAddRegEntryRequestElement;
import org.ecoinformatics.ecogrid.registry.stub.EcogridUpdateRegEntryRequestElement;
import org.ecoinformatics.ecogrid.registry.stub.EcogridGetAllRegServicesRequestElement;
import org.ecoinformatics.ecogrid.registry.stub.EcogridGetAllRegServicesResponseElement;
import org.ecoinformatics.ecogrid.registry.stub.EcogridQueryRegServiceRequestElement;
import org.ecoinformatics.ecogrid.registry.stub.EcogridQueryRegServiceResponseElement;
import org.ecoinformatics.ecogrid.registry.stub.EcogridRegEntryTypeDocumentType;
import org.ecoinformatics.ecogrid.registry.stub.EcogridRegEntryArrayType;
import org.ecoinformatics.ecogrid.registry.stub.EcogridRegEntryType;
import org.ecoinformatics.ecogrid.registry.stub.EcoGridRegLevelOneServiceLocator;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import edu.ucsb.nceas.metacat.client.MetacatClient;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;


/**
 * The class implements Metacat put service
 */
//public class EcoRegistryImpl extends PersistentGridServiceImpl implements EcoRegInterfaceLevelOnePortType
public class EcoRegistryImpl implements EcoRegInterfaceLevelOnePortType
{
   private static String metacatURL = "http://knb.ecoinformatics.org/knb/metacat";
   private static String metacatQueryServiceGSH = "http://ecogrid.ecoinformatics.org/ogsa/services/org/ecoinformatics/ecogrid/EcoGridQueryInterfaceLevelOneService";
   private static Logger logMetacat = Logger.getLogger(EcoRegistryImpl.class);
   static final int NumPredefinedFields = 10;
   private static String[] PredefinedFieldIds = new String[NumPredefinedFields];
   private static String[] PredefinedFieldNames = {
	   								"EcogridRegEntry/serviceName",   
                                    "EcogridRegEntry/serviceGroup",     
                                    "EcogridRegEntry/serviceClassification",                  
                                    "EcogridRegEntry/wsdlURL",                      
                                    "EcogridRegEntry/serviceType",   
                                    "EcogridRegEntry/endPoint",                     
                                    "EcogridRegEntry/documentType/namespace",       
                                    "EcogridRegEntry/documentType/label",
                                    "EcogridRegEntry/description",
                                    "EcogridRegEntry/provider"
                                    };                          

   static
   {
      
      try
      {
          
          String tmp = SystemUtil.getServletURL();
          if (tmp != null && tmp.length() >0)
          {
              metacatURL = tmp;
          }
          
          String tmp1 = SystemUtil.getContextURL() +
        	  /*"http://"
    			+ PropertyService.getProperty("server.name")
    			+ ":"
    			+ PropertyService.getProperty("server.httpPort")
    			+ "/"
    			+ PropertyService.getProperty("application.context")*/
    			+ "/services/QueryService";
          if (tmp != null && tmp.length() >0)
          {
              metacatQueryServiceGSH = tmp1;
          }
      }
      catch (Exception e)
      {
          e.printStackTrace(System.err);
      }
   }

   

   public EcoRegistryImpl()
   {
      
   }

 

   // public  String addRegEntry(java.lang.String sessionId, org.ecoinformatics.ecogrid.registry.stub.EcogridRegEntryType regEntry) throws RemoteException
   public  String addRegEntry(EcogridAddRegEntryRequestElement parameter) throws RemoteException
   {
      //GetEcogridRegistryConfig();

      // build the xml document and store it in Metacat
      /*String xml_doc_string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
      xml_doc_string += "<reg:EcogridRegEntry xmlns:reg=\"ecogrid://registry.ecogrid.ecoinformatis/beta1\">\n";
      xml_doc_string += "  <serviceName>" + regEntry.getServiceName() + "</serviceName>\n";
      xml_doc_string += "  <wsdlURL>" + regEntry.getWsdlURL() + "</wsdlURL>\n";
      xml_doc_string += "  <serviceType>" + regEntry.getServiceType() + "</serviceType>\n";
      xml_doc_string += "  <endPoint>" + regEntry.getEndPoint() + "</endPoint>\n";
      xml_doc_string += "  <serviceClassification>" + regEntry.getServiceClassification() + "</serviceClassification>\n";
      xml_doc_string += "  <description>EcogridServiceRegistry</description>\n";
      int i,j;
      EcogridRegEntryType_documentType[] docTypes = regEntry.getDocumentType();
      if(docTypes != null)
      {
         for(i=0;i<docTypes.length;i++)
         {
            xml_doc_string += "  <documentType>\n";
            xml_doc_string += "     <namespace>" + docTypes[i].getNamespace() + "</namespace>\n";
            if(docTypes[i].getLabel() != null)
              xml_doc_string += "     <label>" + docTypes[i].getLabel() + "</label>\n"; 
            else
              xml_doc_string += "     <label></label>\n";
            xml_doc_string += "  </documentType>\n";
         }
      }

      String[] providers = regEntry.getProvider();
      if(providers != null)
      {
         for(i=0;i<providers.length;i++)
         {
            xml_doc_string += "  <provider>" + providers[i] + "</provider>\n";
         }
      }
      xml_doc_string += "</reg:EcogridRegEntry>";

      EcogridUtils.debugMessage(xml_doc_string);*/
      String docid = generateDocId();
      try
      {
         String sessionId = parameter.getSessionId();
         String xml_doc_string = parameter.getRegEntry();
         
         MetacatClient mc = (MetacatClient)MetacatFactory.createMetacatConnection(metacatURL);
         mc.setSessionId(sessionId);
         String response = mc.insert(docid, new StringReader(xml_doc_string), null);

         // set the permission of the document to public readable
         response = mc.setAccess(docid, "public", "read", "allow", "denyFirst");
      }
      catch(Exception e)
      {
         logMetacat.error("addRegEntry() exception: " + e.getMessage());
         throw new RemoteException(e.getMessage());
      } 
      return docid;
   }
   
   /**
    * Update the registry entry
    * @param parameter
    * @return
    * @throws RemoteException
    */
   public String updateRegEntry(EcogridUpdateRegEntryRequestElement parameter) throws RemoteException
   {
       String response = null;
       try
       {
          String docid = parameter.getDocid();
          String sessionId = parameter.getSessionId();
          String xml_doc_string = parameter.getRegEntry();
          
          MetacatClient mc = (MetacatClient)MetacatFactory.createMetacatConnection(metacatURL);
          mc.setSessionId(sessionId);
          response = mc.update(docid, new StringReader(xml_doc_string), null);

          // set the permission of the document to public readable
          mc.setAccess(docid, "public", "read", "allow", "denyFirst");
       }
       catch(Exception e)
       {
          logMetacat.error("updateRegEntry() exception: " + e.getMessage());
          throw new RemoteException(e.getMessage());
       } 
       return response;
   }

   public String removeRegEntry(EcogridRemoveRegEntryRequestElement parameter) throws RemoteException
   {
      
      String response = null;
      try
      {
         String docid = parameter.getDocid();
         String sessionId = parameter.getSessionId();
         MetacatClient mc = (MetacatClient)MetacatFactory.createMetacatConnection(metacatURL);
         mc.setSessionId(sessionId);
         response = mc.delete(docid);
      }
      catch(Exception e)
      {
         logMetacat.error("removeRegEntry() exception: " + e.getMessage());
         throw new RemoteException(e.getMessage());
      }
      logMetacat.info(response);
      return response;
   }

   
   public EcogridGetAllRegServicesResponseElement getAllRegServices(EcogridGetAllRegServicesRequestElement rqstElement) throws RemoteException
   {
      

      String query_doc_string = getPartEcogridQueryDoc();
      query_doc_string += "    </AND>\n";
      query_doc_string += "</egq:query>";
      logMetacat.info(query_doc_string);
      // submit the 'query_doc_string' to ecogrid's query service
      EcogridRegEntryArrayType regEnteryArray = null;

      try
      {
         regEnteryArray = submitQueryDoc(query_doc_string);
      }
      catch(Exception e)
      {
         EcogridUtils.debugMessage(e.getMessage());
         e.printStackTrace();
         throw new RemoteException(e.getMessage());
      }



      EcogridGetAllRegServicesResponseElement getAllServiceResponse = null;

      if(regEnteryArray != null)
      {
         getAllServiceResponse = new EcogridGetAllRegServicesResponseElement(regEnteryArray);
        
      }
      else
      {
         logMetacat.warn("get null return after calling Metacat query service.");
      }

      return getAllServiceResponse;
   }

   public EcogridQueryRegServiceResponseElement queryRegServices(EcogridQueryRegServiceRequestElement parameter) throws RemoteException
   {
      String sessionId = parameter.getSessionId();
      String queryField = parameter.getQueryField();
      String queryString = parameter.getQueryString();
      String QueryField = "";
      String QueryOp = "";
      String RivisedQueryStr = "";

      if(queryField.compareToIgnoreCase("serviceName") == 0)
      {
         QueryField = "EcogridRegEntry/serviceName";
      }
      else if(queryField.compareToIgnoreCase("serviceGroup") == 0)
      {
         QueryField = "EcogridRegEntry/serviceGroup";
      }
      else if(queryField.compareToIgnoreCase("wsdlURL") == 0)
      {
         QueryField = "EcogridRegEntry/wsdlURL";
      }
      else if(queryField.compareToIgnoreCase("serviceType") == 0)
      {
         QueryField = "EcogridRegEntry/serviceType";
      }
      else if(queryField.compareToIgnoreCase("endPoint") == 0)
      {
         QueryField = "EcogridRegEntry/endPoint";
      }
      else if(queryField.compareToIgnoreCase("serviceClassification") == 0)
      {
         QueryField = "EcogridRegEntry/serviceClassification";
      }
      else if (queryField.compareToIgnoreCase("namespace") == 0)
      {
          QueryField = "EcogridRegEntry/documentType/namespace";
      }
      else
      {
          throw new RemoteException("Unknow search field: " + queryField);
      }

      // check if there is a wild card such as '%' or '*'
      if((queryString.indexOf('%') >=0 ) || (queryString.indexOf('*') >= 0))
      {
          QueryOp = "LIKE";
          // replace all '*' with '%';
          RivisedQueryStr = queryString.replace('*','%');
      }
      else
      {
          QueryOp = "EQUALS";
          RivisedQueryStr = queryString;
      }


      String query_doc_string = getPartEcogridQueryDoc();
      query_doc_string += "       <condition operator=\"" + QueryOp + "\" concept=\""+ QueryField + "\">" + RivisedQueryStr + "</condition>\n";

      query_doc_string += "    </AND>\n";
      query_doc_string += "</egq:query>";

      logMetacat.info(query_doc_string);
      // submit the 'query_doc_string' to ecogrid's query service
      EcogridRegEntryArrayType  regEnteryArray = null;
      try
      {
         regEnteryArray = submitQueryDoc(query_doc_string);
      }
      catch(Exception e)
      {
         throw new RemoteException(e.getMessage());
      }
      EcogridQueryRegServiceResponseElement getServiceResponse = null;

      if(regEnteryArray != null)
      {
         getServiceResponse = new EcogridQueryRegServiceResponseElement(regEnteryArray);
        
      }
      else
      {
         logMetacat.warn("get null return after calling Metacat query service.");
      }

      return getServiceResponse;
   }
   
   
   private String getPartEcogridQueryDoc()
   {
      // build the query document for Metacat system
      String query_doc_string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
      query_doc_string += "<egq:query queryId=\"query_reg.1.1\" system=\"http://pine.nceas.ucsb.edu:8090/ogsa/metacat\"\n";
      query_doc_string += "  xmlns:egq=\"ecogrid://ecoinformatics.org/ecogrid-query-1.0.0beta2\"\n";
      query_doc_string += "  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n";
      query_doc_string += "  xsi:schemaLocation=\"ecogrid://ecoinformatics.org/ecogrid-query-1.0.0beta2 ../../src/xsd/query.xsd\">\n";
      query_doc_string += "    <namespace prefix=\"reg\">ecogrid://ecoinformatics.org/ecogrid-regentry-1.0.0beta1</namespace>\n";

      // return fields
      query_doc_string += "    <returnField>EcogridRegEntry/serviceName</returnField>\n";
      query_doc_string += "    <returnField>EcogridRegEntry/serviceGroup</returnField>\n";
      query_doc_string += "    <returnField>EcogridRegEntry/wsdlURL</returnField>\n";
      query_doc_string += "    <returnField>EcogridRegEntry/serviceType</returnField>\n";
      query_doc_string += "    <returnField>EcogridRegEntry/endPoint</returnField>\n";
      query_doc_string += "    <returnField>EcogridRegEntry/description</returnField>\n";
      query_doc_string += "    <returnField>EcogridRegEntry/serviceClassification</returnField>\n";
      query_doc_string += "    <returnField>EcogridRegEntry/documentType/namespace</returnField>\n";
      query_doc_string += "    <returnField>EcogridRegEntry/documentType/label</returnField>\n";
      query_doc_string += "    <returnField>EcogridRegEntry/provider</returnField>\n";
      

      query_doc_string += "    <title>query ecogrid registries</title>\n";

      query_doc_string += "    <AND>\n";

      // magic part
      query_doc_string += "       <condition operator=\"EQUALS\" concept=\"EcogridRegEntry/serviceClassification\">EcogridServiceRegistry</condition>\n";

      return query_doc_string;
   }

   private EcogridRegEntryArrayType submitQueryDoc(String query_doc) throws Exception
   {
      int i,j;
      String tmpstr;
      logMetacat.info("++++++++start of submitQueryDoc");
      EcogridQueryClient client = new EcogridQueryClient(metacatQueryServiceGSH);
      StringReader queryReader = new StringReader(query_doc);
      ResultsetType queryResults = client.query(queryReader);

      if(queryResults == null)
      {
        logMetacat.warn("Result set from ecogrid is null");
        return null; 
      }
      
      ResultsetTypeRecord[] queryRecords = queryResults.getRecord();

      if((queryRecords == null) || (queryRecords.length <= 0))
      {
          logMetacat.warn("Result records from ecogrid is null or is empty");
          return null;
      }

      logMetacat.info("++++++++start to handle resultset");
      // get prefinedFields IDs.
      // ResultsetType_resultsetMetadata_recordStructure[] rsMetaStruct = queryResults.getResultsetMetadata().getRecordStructure();
      //rsMetaStruct[0].getReturnField();

      // Here rsMetaStruct.length should be 1
      ResultsetTypeResultsetMetadata metadata = queryResults.getResultsetMetadata();
      //logMetacat.info("after get metadata");
      ResultsetTypeResultsetMetadataRecordStructure structure = metadata.getRecordStructure();
      //System.out.println("get sturcture array");
      //System.out.println("get the structure");
      ResultsetTypeResultsetMetadataRecordStructureReturnField[] metaReturnFields = 
               structure.getReturnField();
      //System.out.println("++++++++after getting resultset metadata");
      int idx;
      for(i=0;i<metaReturnFields.length;i++)
      {
          tmpstr = metaReturnFields[i].getName();

          // get index
          idx = GetIdxByPredefinedFieldName(tmpstr);
          if(idx >= 0)
          {
            PredefinedFieldIds[idx] = metaReturnFields[i].getId();

            logMetacat.info(""+tmpstr + " ==> idx=" + idx);
          }
      }

      EcogridRegEntryType[] regEntries = new EcogridRegEntryType[queryRecords.length];
      EcogridRegEntryType regEntry;
      ResultsetTypeRecord queryRecord;


      String[] nameSpaces = null;
      String[] labels = null;
      int namSpacesCnt, labelsCnt;
      String[] providers = null;
      int providerCnt;
      
      // EcogridUtils.debugMessage("after calling query service -- get record counts: " + queryRecords.length);

      // loop results and create entries
      for(i=0;i<queryRecords.length;i++)
      {
         regEntry = new EcogridRegEntryType();
         queryRecord = queryRecords[i];  
     
         ResultsetTypeRecordReturnField[] queryReturnFields = queryRecord.getReturnField();

         if((queryReturnFields == null) || (queryReturnFields.length <= 0))
         {
            regEntries[i] = null;
            break;
         }

         logMetacat.info("+++++++++queryReturnFields.length=" + queryReturnFields.length);
         nameSpaces = new String[queryReturnFields.length];
         labels = new String[queryReturnFields.length];
         providers = new String[queryReturnFields.length];

         namSpacesCnt = 0;
         labelsCnt = 0;
         providerCnt = 0;
         
         //get the docid
         logMetacat.info("++++++++ id " + queryRecord.getIdentifier());
         regEntry.setId(queryRecord.getIdentifier()); 

         for(j=0;j<queryReturnFields.length;j++)
         {
            idx = GetIdxByPredefinedFieldId(queryReturnFields[j].getId());
            // EcogridUtils.debugMessage("getName=" + queryReturnFields[j].getName() + ", getContent=" + queryReturnFields[j].getContent() + ", getId=" + queryReturnFields[j].getId() + ", idx=" + idx);
            switch(idx)
            {
               case 0:
                 logMetacat.info("++++++++ service name "+queryReturnFields[j].get_value());
                 regEntry.setServiceName(queryReturnFields[j].get_value());
                 break;
               case 1:
                 logMetacat.info("++++++++ serviceGroup "+queryReturnFields[j].get_value());
                 regEntry.setServiceGroup(queryReturnFields[j].get_value()); 
                 break;  
               case 2:
                 logMetacat.info("++++++++ service classification "+queryReturnFields[j].get_value());
                 regEntry.setServiceClassification(queryReturnFields[j].get_value());
                 break;
               case 3:
                 logMetacat.info("++++++++ wsdlurl "+queryReturnFields[j].get_value());
                 regEntry.setWsdlURL(queryReturnFields[j].get_value()); 
                 break;
               case 4:
                 logMetacat.info("++++++++ service type "+queryReturnFields[j].get_value());
                 regEntry.setServiceType(queryReturnFields[j].get_value()); 
                 break;                                
               case 5:
                 logMetacat.info("++++++++ endpoint "+queryReturnFields[j].get_value());
                 regEntry.setEndPoint(queryReturnFields[j].get_value());
                 break;
               case 6:
                 logMetacat.info("++++++++ namespace "+queryReturnFields[j].get_value().toString());
                 nameSpaces[namSpacesCnt++] = queryReturnFields[j].get_value().toString();
                 break;
               case 7:
                 logMetacat.info("++++++++ label "+queryReturnFields[j].get_value().toString());
                 labels[labelsCnt++] = queryReturnFields[j].get_value().toString();
                 break;
               case 8:
                   logMetacat.info("++++++++ description "+queryReturnFields[j].get_value());
                   regEntry.setDescription(queryReturnFields[j].get_value()); 
                   break;
               case 9:
                 logMetacat.info("++++++++ provider "+queryReturnFields[j].get_value().toString());
                 providers[providerCnt++] = queryReturnFields[j].get_value().toString();
                 break;  
            }
         }

         //EcogridUtils.debugMessage("namSpacesCnt=" + namSpacesCnt);
         //EcogridUtils.debugMessage("labelsCnt=" + labelsCnt);
         //EcogridUtils.debugMessage("providerCnt=" + providerCnt);
         if(namSpacesCnt > 0)
         {
            logMetacat.info("++++++++ setup doc type");
            EcogridRegEntryTypeDocumentType[] doctypes = new EcogridRegEntryTypeDocumentType[namSpacesCnt];
            for(j=0;j<namSpacesCnt;j++)
            {
               doctypes[j] = new EcogridRegEntryTypeDocumentType();
               doctypes[j].setNamespace(nameSpaces[j]);
               if(labels[j] != null)
                 doctypes[j].setLabel(labels[j]);
            }

            regEntry.setDocumentType(doctypes);
         }

         if(providerCnt > 0)
         {
            logMetacat.info("++++++++ namespace setup provider");
            String[] realSizedProviders = new String[providerCnt];
            for(j=0;j<providerCnt;j++)
              realSizedProviders[j] = providers[j];

            regEntry.setProvider(realSizedProviders);
         }

         regEntries[i] = regEntry;
      }

      // finally return the arrayElement
      EcogridRegEntryArrayType regArray = new EcogridRegEntryArrayType();
      logMetacat.info("++++++++ after create recogridRegarraytype");
      regArray.setRegEntry(regEntries);
      logMetacat.info("++++++++ end of submit query");
      return regArray;
   }


  
   
   private int GetIdxByPredefinedFieldName(String instr)
   {
      for(int i=0;i<NumPredefinedFields;i++)
      {
         if(instr.compareToIgnoreCase(PredefinedFieldNames[i]) == 0)
           return i;
      }
      return -1;
   }

   private int GetIdxByPredefinedFieldId(String instr)
   {
      for(int i=0;i<NumPredefinedFields;i++)
      {
         if(instr.compareToIgnoreCase(PredefinedFieldIds[i]) == 0)
           return i;
      }

      return -1;
   }
   
   /*
    * This method will automatic assign a docid for the given document
    */
   private String generateDocId()
   {
       String prefix = "ecogridService";
       int index1 = (new Double(Math.random() * 100)).intValue();
       int index2 = (new Double(System.currentTimeMillis()/10000)).intValue();
       int rev = 1;
       String docid = prefix+"."+index2+index1+"."+rev;
       logMetacat.info("Generated docid for registry document is "+docid);
       return docid;
   }
   // for testing purpose
   private void viewQuery(QueryType query)
   {
     if (query == null)
     {
       System.out.println("start to check the query");
       System.out.println("  query is null");
       System.out.println("end to check the query");
       return;
     }
     if (query.getAND() != null)
     {
       System.out.println("start to check the query");
       System.out.println("start first level of AND");
       ANDType and1= query.getAND();
       ORType [] orList = and1.getOR();
       if (orList != null)
       {
         for (int i =0; i< orList.length; i++)
         {
           ORType or = orList[i];
           System.out.println("  child " + i + "ORType start");
           ConditionType[] conditionList = or.getCondition();
           if (conditionList != null)
           {
             for (int j=0; j< conditionList.length; j++)
             {
                ConditionType condition = conditionList[j];
                System.out.println("    condtion kid " + j + " of ORType " + i +
                                    " start");
                 if (condition != null)
                 {
                    System.out.println("      expresspath is " +
                                             condition.getConcept().toString());
                    System.out.println("      operator is "+
                                            condition.getOperator().toString());
                    System.out.println("      value is "+ condition.get_value());
                  }//if
                System.out.println("    condtion kid " + j + " of ORType " + i +
                                   " end");
             }//for
           }//if
           System.out.println("  child " + i + " ORType end");
         }//for
       }//if
      System.out.println("end first level of AND");
      System.out.println("end to check the query");
     }//if
  }
}
