/**
 *    '$RCSfile: LoginDlg.java,v $'
 *
 *     '$Author: rspears $'
 *       '$Date: 2004-10-20 16:06:23 $'
 *   '$Revision: 1.1 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.ecogrid.registry.ui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

/**
 * @author Rod Spears
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
class LoginDlg extends RegBaseDlg implements ActionListener, PropertyChangeListener 
{
    private static final String LOGIN_STR  = "Login";
    private static final String CANCEL_STR = "Cancel";
    
    private static final String UID_LOGIN = "UID";
    private static final String O_LOGIN   = "O";
    private static final String DC_LOGIN  = "DC";
    private static final String DC2_LOGIN = " DC";
    private static final String[] TITLES = {UID_LOGIN, O_LOGIN, DC_LOGIN, DC2_LOGIN};

    private RegistryViewer mRegViewer;
    
    private JPasswordField mPassword;

    /** Creates the reusable dialog. */
    public LoginDlg(Frame aFrame, RegistryViewer parent) 
    {
        super(aFrame, true);
        mRegViewer = parent;

        setTitle("Login");

        mPassword = new JPasswordField("");
       
       //Create an array of the text and components to be displayed.
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        
        addFields(panel, TITLES);
        addField(panel, "Password", TITLES.length+1, mPassword);
        
        // preset some values
        //setFieldValue(UID_LOGIN, "rods");
        //setFieldValue(O_LOGIN, "KU");
        setFieldValue(DC_LOGIN, "ecoinformatics");
        setFieldValue(DC2_LOGIN, "org");
        
        //Create an array specifying the number of dialog buttons
        //and their text.
        Object[] options = {LOGIN_STR, CANCEL_STR};

        //Create the JOptionPane.
        mOptionPane = new JOptionPane(panel,
                                    JOptionPane.PLAIN_MESSAGE,
                                    JOptionPane.YES_NO_OPTION,
                                    null,
                                    options,
                                    options[0]);

        //Make this dialog display it.
        setContentPane(mOptionPane);

        //Handle window closing correctly.
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent we) {
                /*
                 * Instead of directly closing the window,
                 * we're going to change the JOptionPane's
                 * value property.
                 */
                    mOptionPane.setValue(new Integer(
                                        JOptionPane.CLOSED_OPTION));
            }
        });

        //Ensure the text field always gets the first focus.
        addComponentListener(new ComponentAdapter() {
            public void componentShown(ComponentEvent ce) {
              getCompByName(UID_LOGIN).requestFocusInWindow();
            }
        });

        //Register an event handler that puts the text into the option pane.
        //mUsername.addActionListener(this);

        //Register an event handler that reacts to option pane state changes.
        mOptionPane.addPropertyChangeListener(this);
        
        Dimension dlgDim = new Dimension(300, 200);
        setSize(dlgDim);
        
        Dimension screenDim = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        
        setLocation((screenDim.width - dlgDim.width)/2, (screenDim.height - dlgDim.height)/2);
    }

    /** This method handles events for the text field. */
    public void actionPerformed(ActionEvent e) {
        mOptionPane.setValue(LOGIN_STR);
    }

    /**
     * Returns the username
     */
    public String getUsername() 
    {
      StringBuffer strBuf = new StringBuffer();
      strBuf.append("uid=");
      strBuf.append(getFieldValue(UID_LOGIN));
      strBuf.append(",o=");
      strBuf.append(getFieldValue(O_LOGIN));
      strBuf.append(",dc=");
      strBuf.append(getFieldValue(DC_LOGIN));
      strBuf.append(",dc=");
      strBuf.append(getFieldValue(DC2_LOGIN));
      return strBuf.toString();
    }

    /**
     * Returns the password
     */
    public String getPassword() {
        return new String(mPassword.getPassword());
    }

    /** This method reacts to state changes in the option pane. */
    public void propertyChange(PropertyChangeEvent e) 
    {
        String prop = e.getPropertyName();

        if (isVisible() && 
             (e.getSource() == mOptionPane) && 
             (JOptionPane.VALUE_PROPERTY.equals(prop) ||
             JOptionPane.INPUT_VALUE_PROPERTY.equals(prop))) 
        {
            Object value = mOptionPane.getValue();

            if (value == JOptionPane.UNINITIALIZED_VALUE) 
            {
                //ignore reset
                return;
            }

            //Reset the JOptionPane's value.
            //If you don't do this, then if the user
            //presses the same button next time, no
            //property change event will be fired.
            mOptionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);

            if (LOGIN_STR.equals(value)) 
            {
                //System.out.println("U: "+ getUsername());
                //System.out.println("P: "+ getPassword());
                if (getUsername().length() == 0 || 
                    getPassword().length() == 0)
                {
                    JOptionPane.showMessageDialog(
                                    LoginDlg.this,
                                    "You must enter a Username and Password!",
                                    "Try again",
                                    JOptionPane.ERROR_MESSAGE);
                } else
                {
                    setVisible(false);
                }
            } else 
            { //user closed dialog or clicked cancel
                setVisible(false);
                setWasCancelled(true);
            }
        }
    }
}
