/**
 *    '$RCSfile: RegBaseDlg.java,v $'
 *
 *     '$Author: rspears $'
 *       '$Date: 2004-10-26 15:15:08 $'
 *   '$Revision: 1.2 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.ecogrid.registry.ui;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.util.Hashtable;

import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

/**
 * @author Rod Spears
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
class RegBaseDlg extends JDialog 
{
    protected JOptionPane  mOptionPane = null;

    protected JTextField[] mFields     = null;
    protected Hashtable    mFieldHash  = new Hashtable();
    protected boolean      mWasCancelled = false;

    /**
     * 
     * @param aFrame
     * @param aModal
     */
    public RegBaseDlg(Frame aFrame, boolean aModal)
    {
      super(aFrame, aModal);
    }
    
    /**
     * 
     * @return
     */
    public boolean wasCancelled()
    {
      return mWasCancelled;
    }
    
    /**
     * 
     * @param aWas
     */
    protected void setWasCancelled(boolean aWas)
    {
      mWasCancelled = aWas;
    }

    /**
     * 
     * @param aPanel
     * @param aTitles
     */
    protected void addFields(JPanel aPanel, String[] aTitles)
    {
      mFields = new JTextField[aTitles.length];
      for (int i=0;i<aTitles.length;i++) 
      {
          addField(aPanel, aTitles[i], i);
      }
    }
    
    /**
     * 
     * @param aPanel
     * @param aTitle
     * @param aRow
     */
    private void addField(JPanel aPanel, String aTitle, int aRow)
    {
        mFields[aRow] = new JTextField();
        mFieldHash.put(aTitle, mFields[aRow]);
        addField(aPanel, aTitle, aRow, mFields[aRow]);   
    }
    
    /**
     * 
     * @param aPanel
     * @param aTitle
     * @param aRow
     */
    static protected void addField(JPanel aPanel, String aTitle, int aRow, JComponent aComp)
    {
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        
        c.gridx   = 0;
        c.gridy   = aRow;
        c.weightx = 0.0;
        c.fill    = GridBagConstraints.HORIZONTAL;
        JLabel label = new JLabel(aTitle + ":");
        label.setHorizontalAlignment(JLabel.RIGHT);
        aPanel.add(label, c);
        
        c.weightx = 1.0;
        c.gridx = 1;
        c.fill = GridBagConstraints.HORIZONTAL;
        aPanel.add(aComp, c);
        
    }
    
    /**
     * 
     * @param aName
     * @return
     */
    protected JComponent getCompByName(String aName)
    {
      return (JComponent)mFieldHash.get(aName);
    }
    
    /**
     * Returns the username
     */
    public String getFieldValue(String aName) 
    {
        JTextField tf = (JTextField)getCompByName(aName);
        if (tf != null)
        {
            return tf.getText();
        }
        return "";
    }
    
    /**
     * Returns the username
     */
    public void setFieldValue(String aName, String aValue) 
    {
        JTextField tf = (JTextField)getCompByName(aName);
        if (tf != null)
        {
            tf.setText(aValue);
        }
    }
}
