/**
 *    '$RCSfile: RegEntryDlg.java,v $'
 *
 *     '$Author: rspears $'
 *       '$Date: 2004-10-26 19:53:54 $'
 *   '$Revision: 1.3 $'
 *
 *  For Details: http://kepler.ecoinformatics.org
 *
 * Copyright (c) 2003 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
 * FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
 * IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
 * PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY
 * OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT,
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

package org.ecoinformatics.ecogrid.registry.ui;

import java.awt.*;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;

import javax.swing.*;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import org.ecoinformatics.ecogrid.registry.stub.EcogridRegEntryType;
import org.ecoinformatics.ecogrid.registry.stub.EcogridRegEntryType_documentType;

/**
 * @author Rod Spears
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
class RegEntryDlg extends RegBaseDlg implements PropertyChangeListener 
{
    private static final String ADD_STR    = "Add";
    private static final String UPDATE_STR = "Update";
    private static final String CANCEL_STR = "Cancel";
    
    private static final String NAME     = "Name";
    private static final String TYPE     = "Type";
    private static final String ENDPOINT = "End Point";
    private static final String CLASSIF  = "Classification";

    
    private JTabbedPane         mTabbedPane     = null;
    private RegistryViewer      mRegViewer;

    private Hashtable           mFieldHash      = new Hashtable();
    private EcogridRegEntryType mRegEntry       = null;
    private ProvidersPanel      mProvidersPanel = null;
    private DocTypesPanel        mDocTypesPanel = null;

    private static final String[] TITLES = {NAME, TYPE, ENDPOINT, CLASSIF};
     
    /** Creates the reusable dialog. */
    public RegEntryDlg(Frame          aFrame, 
                       RegistryViewer aParent, 
                       boolean        aDoingAdd) 
    {
        super(aFrame, true);
        mRegViewer = aParent;

        setTitle("Registry Entry");

        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBackground(Color.GREEN);
        mainPanel.setOpaque(true);
        
        // create tab
        mTabbedPane  = new JTabbedPane();
        mainPanel.add(mTabbedPane, BorderLayout.NORTH);
        mTabbedPane.setMinimumSize(new Dimension(300, 175));
        
        //Create an array of the text and components to be displayed.
        JPanel panel1 = new JPanel(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        addFields(panel, TITLES);       
        panel1.add(panel, BorderLayout.NORTH);
        
        mTabbedPane.add("General", panel1);
        mTabbedPane.add("Doc Types", createDocTypesPanel());
        mTabbedPane.add("Providers", createProvidersPanel());
        
        
        //Create an array specifying the number of dialog buttons
        //and their text.
        Object[] options = {(aDoingAdd ?ADD_STR:UPDATE_STR), CANCEL_STR};

        //Create the JOptionPane.
        mOptionPane = new JOptionPane(mTabbedPane,
                                    JOptionPane.PLAIN_MESSAGE,
                                    JOptionPane.YES_NO_OPTION,
                                    null,
                                    options,
                                    options[0]);

        //Make this dialog display it.
        setContentPane(mOptionPane);

        //Handle window closing correctly.
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent we) {
                /*
                 * Instead of directly closing the window,
                 * we're going to change the JOptionPane's
                 * value property.
                 */
                    mOptionPane.setValue(new Integer(
                                        JOptionPane.CLOSED_OPTION));
            }
        });

        //Ensure the text field always gets the first focus.
        addComponentListener(new ComponentAdapter() {
            public void componentShown(ComponentEvent ce) {
                mFields[0].requestFocusInWindow();
            }
        });

        //Register an event handler that reacts to option pane state changes.
        mOptionPane.addPropertyChangeListener(this);
        
        Dimension dlgDim = new Dimension(400,275);
        setSize(dlgDim);
        
        Dimension screenDim = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        
        setLocation((screenDim.width - dlgDim.width)/2, (screenDim.height - dlgDim.height)/2);
    }
    
    private JComponent createProvidersPanel()
    {
        mProvidersPanel = new ProvidersPanel();
        return mProvidersPanel;
      
    }
    
    private JComponent createDocTypesPanel()
    {
      mDocTypesPanel = new DocTypesPanel();
      return mDocTypesPanel;
      
    }
    
    /**
     * 
     * @param aRegEntry
     */
    public void setRegEntry(EcogridRegEntryType aRegEntry)
    {
        mRegEntry = aRegEntry;
        if (aRegEntry != null)
        {
          setFieldValue(NAME, aRegEntry.getServiceName());
          setFieldValue(TYPE, aRegEntry.getServiceType());
          setFieldValue(ENDPOINT, aRegEntry.getEndPoint());
          setFieldValue(CLASSIF, aRegEntry.getServiceClassification());
          mProvidersPanel.setProviders(aRegEntry.getProvider());
          mDocTypesPanel.setDocTypes(aRegEntry.getDocumentType());
        }
        
    }

    /**
     * 
     * @param aRegEntry
     */
    public EcogridRegEntryType getRegEntry()
    {
        if (mRegEntry == null)
        {
            mRegEntry = new EcogridRegEntryType();
        }
        mRegEntry.setServiceName(getFieldValue(NAME));
        mRegEntry.setServiceType(getFieldValue(TYPE));
        mRegEntry.setEndPoint(getFieldValue(ENDPOINT));
        mRegEntry.setServiceClassification(getFieldValue(CLASSIF));
        
        if (mProvidersPanel.isChanged())
        {
            String[] nameSpaces = mProvidersPanel.getProviders();
            if (nameSpaces != null)
            {
              mRegEntry.setProvider(nameSpaces);
            }
        }
        
        if (mDocTypesPanel.isChanged())
        {
            EcogridRegEntryType_documentType[] docTypes = mDocTypesPanel.getDocTypes();
            if (docTypes != null)
            {
              mRegEntry.setDocumentType(docTypes);
            }
        }
        return mRegEntry;
    }

    /** This method reacts to state changes in the option pane. */
    public void propertyChange(PropertyChangeEvent e) 
    {
        String prop = e.getPropertyName();

        if (isVisible() && 
             (e.getSource() == mOptionPane) && 
             (JOptionPane.VALUE_PROPERTY.equals(prop) ||
             JOptionPane.INPUT_VALUE_PROPERTY.equals(prop))) 
        {
            Object value = mOptionPane.getValue();

            if (value == JOptionPane.UNINITIALIZED_VALUE) 
            {
                //ignore reset
                return;
            }

            //Reset the JOptionPane's value.
            //If you don't do this, then if the user
            //presses the same button next time, no
            //property change event will be fired.
            mOptionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);

            if (ADD_STR.equals(value) || UPDATE_STR.equals(value)) 
            {
                if (getFieldValue(NAME).length() == 0 || 
                    getFieldValue(ENDPOINT).length() == 0)
                {
                    JOptionPane.showMessageDialog(
                                    RegEntryDlg.this,
                                    "You must enter a name and an endpoint!",
                                    "Try again",
                                    JOptionPane.ERROR_MESSAGE);
                    for (int i=0;i<TITLES.length;i++)
                    {
                        if (getFieldValue(TITLES[i]).length() == 0)
                        {
                          JComponent comp = (JComponent)mFieldHash.get(TITLES[i]);
                          if (comp != null)
                          {
                            comp.requestFocusInWindow();
                          }
                        }
                        
                    }
                } else
                {
                    setVisible(false);
                 }
            } else 
            { //user closed dialog or clicked cancel
                setVisible(false);
                setWasCancelled(true);
           }
        }
    }
}
