<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ page contentType="text/html" %>
<%@ page import="java.net.URL" %>
<%@ page import="java.net.MalformedURLException" %>
<%@ page import="java.util.Vector" %>
<%@ page import="java.util.Enumeration" %>
<%@ page import="org.w3c.dom.Document" %>
<%@ page import="org.w3c.dom.Node" %>
<%@ page import="org.w3c.dom.NodeList" %>

<%@ page import="org.ecoinformatics.ecogrid.EcogridUtils" %>
<%@ page import="org.ecoinformatics.ecogrid.registry.impl.EcogridJSPBeanFactory" %>
<%@ page import="org.ecoinformatics.ecogrid.registry.impl.EcogridJSPBeanIFace" %>
<%@ page import="org.ecoinformatics.ecogrid.registry.EcoRegInterface" %>
<%@ page import="org.ecoinformatics.ecogrid.registry.EcoRegConstants" %>
<%@ page import="org.ecoinformatics.ecogrid.registry.RegEntry" %>

<jsp:useBean id="ecogridBeanFactory" class="org.ecoinformatics.ecogrid.registry.impl.EcogridJSPBeanFactory">
  <jsp:setProperty name="ecogridBeanFactory" property="*" />
</jsp:useBean>

<jsp:useBean id="entry" class="org.ecoinformatics.ecogrid.registry.RegEntry">
  <jsp:setProperty name="entry" property="*" />
</jsp:useBean>

<%
  EcogridJSPBeanIFace ecogridBean = ecogridBeanFactory.createEcogridJSPBean("GLOBUS");
  String urlStr = "http://kuecogrid.ittc.ku.edu:8080/ogsa/services/org/ecoinformatics/ecogrid/registry/EcoRegInterfaceService"; // testing only
  String siteStr = "kuecogrid.ittc.ku.edu";
  String srvPath = "ogsa";

  //String siteStr = "localhost";
  //String srvPath = "axis";
  //String urlStr = "http://" + siteStr + ":8080/axis/services/EcoRegInterface";
%>

<c:set var="isProcessing" value="true" />

<c:if test="${empty param.process}">
  <c:set var="isProcessing" value="false" />
</c:if>

<%
  String status = "";
  String argName    = request == null ? "" : (String)request.getParameter("name"); 
  String argRegName = "";//request == null ? "" : (String)request.getParameter("regName"); 
  String argRegAddr = request == null ? "" : (String)request.getParameter("regAddr");
%>

<c:if test="${param.process eq 'register'}">
<%
  entry.set(argName, argRegName, argRegAddr);
  if (ecogridBean.registerEntry(urlStr, entry) != EcoRegConstants.kNoError) {
    status = "Error updating " + argName;
  } else {
    status = argName + ": was registered.";
  }
%>
</c:if>


<c:if test="${param.process eq 'update'}">
<%
  entry.set(argName, argRegName, argRegAddr);
  if (ecogridBean.updateEntry(urlStr, entry) != EcoRegConstants.kNoError) {
    status = "Error updating " + argName;
  } else {
    status = argName + ": registry values have been updated.";
  }

%>
</c:if>
<c:if test="${param.process eq 'remove'}">
<%
  if (ecogridBean.removeEntry(urlStr, argName) != EcoRegConstants.kNoError) {
    status = "Error updating " + argName;
  } else {
    status = argName + ": was removed.";
  }
%>
</c:if>
<%
  String       xmlStr  = ecogridBean.getXMLListing(urlStr);
  StringBuffer htmlStr = new StringBuffer("");
  Document     dom     = EcogridUtils.convertXMLStr2DOM(xmlStr);

  int numEntries = 0;
  if (dom != null)
  {
    Node listing = EcogridUtils.findNode(dom, "listing");
    if (listing != null) 
    {
      NodeList list = listing.getChildNodes();
      numEntries = list.getLength();
    }
  }

%>
<html>
<title>Registry</title>
<script>
  var values = [
<%

  if (dom != null)
  {
    Node listing = EcogridUtils.findNode(dom, "listing");
    if (listing != null) 
    {
      NodeList list = listing.getChildNodes();
      for (int i=0;i<list.getLength();i++) 
      {
        Node child = list.item(i);
        if (child != null && child.getNodeType() != Node.TEXT_NODE)
        {
          String name    = EcogridUtils.findNodeValue(child, "name");
          String regName = "";//EcogridUtils.findNodeValue(child, "regName");
          String regAddr = EcogridUtils.findNodeValue(child, "regAddr");
%>
                "<%= name %>", "<%= regName %>", "<%= regAddr %>",
<%

        }
      }
    }
  }
%>
];

function setProcess(value)
{
  document.entry.process.value = value;
}

function resourceSelected(list)
{
  var inx = list.selectedIndex * 3;
  if (inx > -1) {
    document.entry.name.value = values[inx] != null ? values[inx] : "";
    //document.entry.regName.value = values[inx+1] != null ? values[inx+1] : "";
    document.entry.regAddr.value = values[inx+2] != null ? values[inx+2] : "";

    document.entry.clear.disabled    = false;
    document.entry.update.disabled   = false;
    document.entry.remove.disabled   = false;
    document.entry.register.disabled = true;
  }
}

function clearEntries()
{
  document.entry.listing.selectedIndex = -1;
  document.entry.remove.disabled = true;
  document.entry.update.disabled = true;
  document.entry.register.disabled = false;
  document.entry.name.value = "";
  //document.entry.regName.value = "";
  document.entry.regAddr.value = "";
}

function checkName()
{
  if (document.entry.name.value == "") {
    alert("The name cannot be blank.");
    return false;
  }

  var list = document.entry.listing;
  var inx = list.selectedIndex * 3;
  if (inx > -1) {
    var options = list.options;
    var name = values[inx];
    if (options[list.selectedIndex].value != document.entry.name.value) {
      alert("There is a mismatch between the item selected in the list and the name that is entered.");
      return false;
    }
  }
  return true;
}

</script>
<body onload="clearEntries();">
<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr>
    <td bgcolor="#294563" width=60><a href="http://pbi.ecoinformatics.org/"><img border="0" src="pbi_world.png"></a></td>
    <td bgcolor="#294563" align=center><a href="http://pbi.ecoinformatics.org/"><img border="0" src="seeklogo.png"></a></td>
    <td bgcolor="#294563" width=60>&nbsp;</td>
  </tr>
</table>
<br>
<br>
<center>
<%


  boolean ok = false;
  htmlStr.append("<select size=10 name=listing onChange=\"resourceSelected(this);\">\n");
  if (dom != null)
  {
    Node listing = EcogridUtils.findNode(dom, "listing");
    if (listing != null) 
    {
      NodeList list = listing.getChildNodes();
      ok = list.getLength() > 0;
      for (int i=0;i<list.getLength();i++) 
      {
        Node child = list.item(i);
        if (child != null && child.getNodeType() != Node.TEXT_NODE)
        {
          String name = EcogridUtils.findNodeValue(child, "name");

          htmlStr.append("<option value=\""+name+"\">"+name+"</option>\n");
        }
      }
    }
  }

  if (!ok) 
  {
    htmlStr.append("<option value=\"\">No Items</option>\n");
  }
  htmlStr.append("</select>");

%>
<b>Ecogrid Registry Entries</b><br>
<form name=entry action="http://<%= siteStr %>:8080/<%= srvPath %>/registry.jsp" onsubmit="return checkName();" >

  <input type=hidden name=process value="">

  <%= htmlStr %><br><br>
  <table border=0>
    <tr><td align=right><b>Name:</b></td><td><input type=text size=30 name=name></td></tr>
    <!-- <tr><td align=right><b>Registry Name:</b></td><td><input type=text size=50 name=regName></td></tr> -->
    <tr><td align=right><b>Registry Address:</b></td><td><input type=text size=60 name=regAddr></td></tr>
    <tr>
      <td>&nbsp;</td>
      <td>
        <table border=0>
          <tr>
            <td><input type=button name=clear value="Clear" onClick="clearEntries();"></td>
            <td><input type=submit name=register value="Register"onClick="setProcess('register');" ></td>
            <td><input type=submit name=update value="Update" onClick="setProcess('update');" disabled></td>
            <td><input type=submit name=remove value="Remove" onClick="setProcess('remove');" disabled></td>
          </tr>
        </table>
      </td>
    </tr>
  </table>
</form>
<br>
<%= status %><br><br>
<a href="http://<%= siteStr %>:8080/<%= srvPath %>/queryForm.jsp">Ecogrid Query Builder</a><br>
<a href="http://<%= siteStr %>:8080/<%= srvPath %>/query.jsp">Ecogrid Query Text Entry Form</a>
</center>
</body>
</html>
