package org.ecoinformatics.ecogrid.srb.impl;

import java.util.Vector;

import org.apache.axis.types.URI;

import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeRecord;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadata;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeRecordReturnField;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetTypeResultsetMetadataNamespace;
import org.ecoinformatics.ecogrid.EcogridUtils;

import org.ecoinformatics.ecogrid.queryservice.util.EcogridResultsetFactory;


import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import edu.sdsc.grid.io.srb.*;
import edu.sdsc.grid.io.*;

/**
 *  This class will transform a hashtable which is the result set come from
 *  metacat searching to ecogrid result set java object
 */
public class SRB2ResultsetType
{
   private static final String SRB_SYSTEM = "http://srb.sdsc.edu";
   private static final String SRB_NAMESPACE = "srb://srb.sdsc.edu";

   /**
    * default constructor
    */
   public SRB2ResultsetType()
   {
   }

   /*
   public void SetReturnFields(String[] inReturnFields)
   {
      if(inReturnFields.length <= 0)
        return;

      ReturnFields = new String[inReturnFields.length];

      for(int i=0;i<inReturnFields.length;i++)
        ReturnFields[i] = inReturnFields[i];
   }
   */

   // SRB's time stamp has format of 2002-08-02-10.43.21 and needs conversion to the fomrat of yyyy-mm-dd hh:mm:ss.fffffffff
   String TimeFormatConverion(String inTime)
   {
      String outTime = inTime;

      int i = inTime.lastIndexOf('-');
      if(i<= 0)
        return outTime;

      String str1,str2;
      str1 = inTime.substring(0,i-1);
      str2 = inTime.substring(i+1);
      str2 = str2.replace('.',':');
      outTime = str1 + " " + str2;

      return outTime;
   }

   // for an array of SRB object IDs.
   public ResultsetType transform(Vector srbObjVector, String[] returnFields) throws Exception
   {
      EcogridUtils.debugMessage("transform()");
      int i,j;

      if (srbObjVector == null)
      {
         EcogridUtils.debugMessage("transform(): input is null.");
         return null;
      }

      ResultsetType ecogridResult = new ResultsetType();

      // set system
      ecogridResult.setSystem(new URI("http://knb.ecoinformatics.org"));

      // set resultsetId
      ecogridResult.setResultsetId("SeekSRB_001");
      // set meta data
      ResultsetTypeResultsetMetadata metadata =
                                         new ResultsetTypeResultsetMetadata();
      // set send time
      TimeZone local = TimeZone.getTimeZone(System.getProperty("user.timezone"));
      Calendar calendar = Calendar.getInstance(local);
      Date now = new Date();
      calendar.setTime(now);
      metadata.setSendTime(calendar);

      int size = srbObjVector.size();
      EcogridUtils.debugMessage("input record size: " + size);

      // if size is zero, it start 0
      if ( size == 0)
      {
         metadata.setStartRecord(size);
      }
      else
      {
         metadata.setStartRecord(1);
      }
      metadata.setEndRecord(size);
      metadata.setRecordCount(size);


      ResultsetTypeResultsetMetadataNamespace ns = EcogridResultsetFactory.createNameSpace(SRB_NAMESPACE, null);
      metadata.setNamespace(ns);

      ecogridResult.setResultsetMetadata(metadata);

      if(size == 0)
        return ecogridResult;

      ResultsetTypeRecord[] recordList = new ResultsetTypeRecord[size];
      // SRB record
      MetaDataRecordList srbRecord;
      String FldStr;

      String CollName,DatasetName,ReplNum,ModificationDate,CreateDate;
      String SrbObjId;

      for(i=0;i<size;i++)
      {
          srbRecord = (MetaDataRecordList)srbObjVector.elementAt(i);

          ResultsetTypeRecord record = new ResultsetTypeRecord();
          record.setNumber(i+1);

          record.setSystem(SRB_SYSTEM);

          CollName = "";
          DatasetName = "";
          ReplNum = "";
          ModificationDate = "";
          CreateDate = "";

          SrbObjId = "";

          Vector vSrbReturnedAtts = new Vector();
          Vector vSrbReturnedVals = new Vector();

          // table stores user-defined metadata
          MetaDataTable table = null;


          // save search results into poaired arrays.
          for(j=0;j<srbRecord.getRecordCount();j++)
          {
             if(srbRecord.getFieldType(j) == MetaDataField.TABLE)
             {
                table = srbRecord.getTableValue(j);
             }
             else
             {
                FldStr = srbRecord.getFieldName(j);
                if(FldStr.equalsIgnoreCase(SRBMetaDataSet.DIRECTORY_NAME))
                  CollName = srbRecord.getStringValue(j);
                else if(FldStr.equalsIgnoreCase(SRBMetaDataSet.FILE_NAME))
                  DatasetName = srbRecord.getStringValue(j);
                else if(FldStr.equalsIgnoreCase(SRBMetaDataSet.FILE_REPLICATION_ENUM))
                  ReplNum = srbRecord.getStringValue(j);
                else if(FldStr.equalsIgnoreCase(SRBMetaDataSet.MODIFICATION_DATE))
                  ModificationDate = srbRecord.getStringValue(j);
                else if(FldStr.equalsIgnoreCase(SRBMetaDataSet.CREATION_DATE))
                  CreateDate = srbRecord.getStringValue(j);

                vSrbReturnedAtts.add(srbRecord.getFieldName(j));
                vSrbReturnedVals.add(srbRecord.getStringValue(j));
             }
          }

          // continue to fill the search result arrays if there is user-defined metadata
          if(table != null)
          {
             for(j=0;j<table.getRowCount();j++)
             {
                String cl1 = table.getStringValue(j,0);
                String cl2 = table.getStringValue(j,1);

                if(cl1 != null)
                {
                    vSrbReturnedAtts.add(cl1);
                    if(cl2 == null)
                      vSrbReturnedVals.add("");
                    else
                      vSrbReturnedVals.add(cl2);
                }
             }
          }

          // set up some top level info of search result.
          SrbObjId = CollName + "/" + DatasetName + "::" + ReplNum;
          record.setIdentifier(SrbObjId);

          // SRB's time stamp has format of 2002-08-02-10.43.21 and needs conversion to the fomrat of yyyy-mm-dd hh:mm:ss.fffffffff
          ModificationDate = TimeFormatConverion(ModificationDate);
          CreateDate = TimeFormatConverion(CreateDate);

          try
          {
             Timestamp modifyTime = Timestamp.valueOf(ModificationDate);
             Calendar calendarModify = Calendar.getInstance();
             calendarModify.setTime(modifyTime);
             record.setLastModifiedDate(calendarModify);

             Timestamp creationDate = Timestamp.valueOf(CreateDate);
             Calendar calendarCreation = Calendar.getInstance();
             calendarCreation.setTime(creationDate);
             record.setCreationDate(calendarCreation);
          }
          catch(IllegalArgumentException e)
          {
             throw new Exception(e.getMessage());
          }

          ////////////////////////////////////////////////////
          // now we need to build return metadata list
          ////////////////////////////////////////////////////

          ResultsetTypeRecordReturnField retFld = null;

          Vector returnFieldList = new Vector();

          // setting the return fields which includes system metadat and user-defined metadata
          if((returnFields != null) && (returnFields.length > 0))
          {
             for(j=0;j<returnFields.length;j++)
             {
                for(int k=0;k<vSrbReturnedAtts.size();k++)
                {
                   String s1, s2;
                   s1 = (String)vSrbReturnedAtts.elementAt(k);
                   s2 = (String)vSrbReturnedVals.elementAt(k);
                   if(returnFields[j].compareTo(s1) == 0)
                   {
                      retFld = EcogridResultsetFactory.createRecordReturnField( s1, s2);
                      returnFieldList.add(retFld);
                   }
                }
             }
          }

          EcogridUtils.debugMessage("transform return field list from vector to array. returnFieldList.size()=" + returnFieldList.size());
          if(returnFieldList.size() > 0)
          {
             ResultsetTypeRecordReturnField array[] = new ResultsetTypeRecordReturnField[returnFieldList.size()];
             for(j=0;j<returnFieldList.size();j++)
               array[j] = (ResultsetTypeRecordReturnField)returnFieldList.elementAt(j);
             record.setReturnField(array);
          }

          EcogridUtils.debugMessage("adding record " + i + " to recordlist.");
          recordList[i] = record;
      }

      EcogridUtils.debugMessage("transform() loop finished.");

      // set record array to ecogrid result object
      ecogridResult.setRecord(recordList);

      return ecogridResult;
   }
}
