package org.ecoinformatics.ecogrid.srb.impl;

import java.util.Vector;

import org.ecoinformatics.ecogrid.queryservice.stub.QueryServicePortType;
import org.ecoinformatics.ecogrid.queryservice.resultset.ResultsetType;
import org.ecoinformatics.ecogrid.queryservice.query.QueryType;
import org.ecoinformatics.ecogrid.EcoGridErrorCode;

import java.rmi.RemoteException;

import edu.sdsc.grid.io.srb.*;
import edu.sdsc.grid.io.*;

import java.net.URI;
import java.net.MalformedURLException;
import java.io.IOException;

import org.ecoinformatics.ecogrid.EcogridUtils;

import java.io.ByteArrayOutputStream;


/**
 * The class implements ecogrid query to srb query
 */
// public class SRBImpl extends GridServiceImpl implements EcoGridQueryInterfaceLevelOnePortType
public class SRBImpl implements QueryServicePortType
{
   public SRBImpl()
   {
   }

   public ResultsetType query(QueryType query) throws RemoteException
   {
       EcogridUtils.debugMessage("query()");

       SrbEcogridQuery srbQuery=null;
       ResultsetType ResultSet = null;
       SeekXMLQueryDocSRBParser queryParser = new SeekXMLQueryDocSRBParser();

       // the return metadata includes system and user-defined metadata defined in ecogrid qoery doc.
       String[] ReturnMetadatFields = query.getReturnField();
       EcogridUtils.debugMessage("===============================");
       EcogridUtils.debugMessage("number of request return fields: " + ReturnMetadatFields.length);
       for(int ji=0;ji<ReturnMetadatFields.length;ji++)
          EcogridUtils.debugMessage("     " + ji + ":" + ReturnMetadatFields[ji]);
       EcogridUtils.debugMessage("===============================");

       try
       {
          srbQuery = queryParser.ParseQueryType(query);
       }
       catch(Exception e)
       {
          EcogridUtils.debugMessage("parsing QueryType failed. " + e.getMessage());
          throw new RemoteException(e.getMessage());
       }

       // print some debug info if debug flag is set.
       srbQuery.PrintUserInfo();

       // submit our parsed query. The return result is the size of first page.
       EcogridUtils.debugMessage("submitting query to SRB...");
       int qr_cnt = srbQuery.SubmitQuery();
       if(qr_cnt < 0)
       {
          String ErrMsg = InterpretSrbError(qr_cnt);
          EcogridUtils.debugMessage("submit query failed: " + ErrMsg);
          srbQuery = null;
          throw new RemoteException(ErrMsg);
       }

       int i;
       MetaDataRecordList srbRecord;

       EcogridUtils.debugMessage("retrieving query results...");
       Vector SrbObjVector = new Vector();
       qr_cnt = srbQuery.GetCurrentSrhResultLength();
       while(qr_cnt > 0)
       {
          for(i=0;i<qr_cnt;i++)
          {
             srbRecord = srbQuery.CurrentSrhResultAt(i);
             SrbObjVector.add(srbRecord);
          }
          qr_cnt = srbQuery.GetMoreSrhResult();
       }

       if(SrbObjVector.size() == 0)
       {
          EcogridUtils.debugMessage("get 0 return from query.");
          srbQuery = null;
          return null;
       }

       EcogridUtils.debugMessage("get number of return: " + SrbObjVector.size());

       SRB2ResultsetType Srb2Resultset = new SRB2ResultsetType();

       try
       {
          EcogridUtils.debugMessage("transform SRB results to result sets...");
          ResultSet = Srb2Resultset.transform(SrbObjVector,ReturnMetadatFields);
       }
       catch(Exception e)
       {
          srbQuery = null;
          throw new RemoteException(e.getMessage());
       }

       srbQuery = null;

       EcogridUtils.debugMessage("return result sets to client...");
       return ResultSet;
   }


  /**
   * Performs a get
   * @param identifier identifies the object to be "gotten"
   * @return returns bytes of identifier
   * @exception RemoteException
   */
  public byte[] get(String identifier) throws RemoteException
  {
      EcogridUtils.debugMessage("get() identifier=" + identifier);

      if (identifier == null)
      {
         EcogridUtils.debugMessage("get() has empty string for identifier.");
         throw new RemoteException("Please sepcify the identifier");
      }
      GeneralRandomAccessFile randomAccessFile = null;

      ByteArrayOutputStream outStream = null;

      int nBytesRead  = 1;
      byte[] bytesRead = new byte[120000];

      SRBFileSystem srbFileSystem = null;
      URI uri = null;

      try
      {
          uri = new URI( identifier );

          outStream = new ByteArrayOutputStream();

          srbFileSystem = getFileSystem( uri );

          randomAccessFile = FileFactory.newRandomAccessFile(
//            FileFactory.newFile(new URI( identifier ))
            FileFactory.newFile( srbFileSystem, uri.getPath() ), "r" );

          nBytesRead = randomAccessFile.read(bytesRead);

           while(nBytesRead > 0)
          {
             outStream.write(bytesRead,0,nBytesRead);
             nBytesRead = randomAccessFile.read(bytesRead);
          }
      }
      catch(Exception e)
      {
          e.printStackTrace();
          throw new RemoteException(e.getMessage());
      }
      finally
      {
        if (randomAccessFile != null) {
          try {
            // close connection
            randomAccessFile.close();
            randomAccessFile = null;
          }
          catch(SRBException e)
          {
            EcogridUtils.debugMessage("Error on close of file "+e.getMessage()+" "+e.getType());
          }
          catch(Exception e)
          {
            EcogridUtils.debugMessage("Error on close of file "+e.getMessage());
          }
          randomAccessFile = null;
        }

        if (srbFileSystem != null) {
          try {
            srbFileSystem.close();
          }
          catch(SRBException e)
          {
            EcogridUtils.debugMessage("Error on close of SRB "+e.getMessage()+" "+e.getType());
          }
          catch(Exception e)
          {
            EcogridUtils.debugMessage("Error on close of SRB "+e.getMessage());
          }
          srbFileSystem = null;
        }
	    }

      if(outStream == null)
      {
         EcogridUtils.debugMessage("outStream is null.");
         return null;
      }

      byte[] retbytes = outStream.toByteArray();

      EcogridUtils.debugMessage("number of bytes: " + retbytes.length);
      return retbytes;
  } //get

  public String InterpretSrbError(int errCode)
  {
     String ErrMsg = "An unknown error occured";

     switch(errCode)
     {
        case EcoGridErrorCode.SRB_UNSUPPORTED_QUERY_OPERATION:
          ErrMsg = "There is an query operation which is not supported by SRB system.";
          break;
        case EcoGridErrorCode.SRB_UNSUPPORTED_QUERY_OPERATOR:
          ErrMsg = "There is an query operation which is not supported by SRB system.";
          break;
        case EcoGridErrorCode.SRB_UM_NO_FLOAT_TYPE:
          ErrMsg = "Float data type is not supported in SRB user defined metadata.";
          break;
        case EcoGridErrorCode.SRB_SUBMIT_QUERY_FAILED:
          ErrMsg = "The service failed to submit a SRB query.";
          break;
        case EcoGridErrorCode.SRB_CANNOT_SET_CONNECTION:
          ErrMsg = "The service failed to establish a connection to SRB MCAT server. MCAT server might be down.";
          break;
        case EcoGridErrorCode.GET_MORE_RESULTS_FAILED:
          ErrMsg = "The service failed in calling SRB getMoreResult().";
          break;
        case EcoGridErrorCode.SRB_INVALID_URI:
          ErrMsg = "The SRB URI is invalid.";
          break;
        case EcoGridErrorCode.INVALID_CONDITION_OP:
          ErrMsg = "An invalid condition operator is detected.";
          break;
     }

     return ErrMsg;
  }

//----------------------------------------------------------------------
// Initialization for URIs
//----------------------------------------------------------------------
  /**
   * Copied this out of SRBFile, because the connection pool was
   * causing bugs in the ecogrid. It wouldn't release connections.
   */
  static SRBFileSystem getFileSystem( URI uri )
    throws IOException
  {
    //srb://userName.mdasDomain:password@host:port/path
    if (!uri.getScheme().equals("srb")) {
      throw new IllegalArgumentException();
    }

    SRBAccount account = uriInitialAccount( uri );
    String zone = null;
    SRBFileSystem srbFileSystem = new SRBFileSystem( account );
/*
er, private methods. don't actually need them for get
    zone = getProperZone( srbFileSystem );
    srbFileSystem.setProxyMcatZone( zone );
    srbFileSystem.setMcatZone( zone );

    srbFileSystem.setDefaultStorageResource(
      getAvailableResource( srbFileSystem ) );
*/
    return srbFileSystem;
  }

  /**
   * Step one of SRBFile( uri )
   */
  static SRBAccount uriInitialAccount( URI uri )
    throws IOException
  {
    String host = uri.getHost();
    int port = uri.getPort();
    String path = uri.getPath();
    String userInfo = uri.getUserInfo();
    String userName = null, mdasDomain = null, password = null;
    String homeDirectory = null;
    int index = -1;

    if ((userInfo == null) || (userInfo == "")) {
      //anon. login
      userName = "public";
      mdasDomain = "npaci";
      password = "CANDO";
      homeDirectory = "/home/public.npaci/";
    }
    else {
      index = userInfo.indexOf( "." );
      if (index < 0) {
        throw new MalformedURLException();
      }
      userName = userInfo.substring( 0, index );

      if (index < 0) {
        throw new MalformedURLException();
      }
      userInfo = userInfo.substring( index+1 );

      index = userInfo.indexOf( ":" );
      if (index > 0) {
        mdasDomain = userInfo.substring( 0, index );
        password = userInfo.substring( index+1 );
      }
      else {
        mdasDomain = userInfo;
      }
      //set the home directory to the local zone
      homeDirectory = "/home/"+userName+"."+mdasDomain;
    }

    index = host.indexOf( "." );
    if ( index < 0 ) {
      //removed zone authority part
      throw new MalformedURLException();
    }

    if ( port < 0 ) {
      port = 5544;
    }

    //Have to find a storage resource after connection.
    return new SRBAccount( host, port, userName, password,
      homeDirectory, mdasDomain, "" );
  }
}
