package org.ecoinformatics.ecogrid.srb.impl;

import java.net.URI;
import java.io.*;
import java.net.URISyntaxException;

public class SRBuri
{
    URI u;

    // some deault values
    public final static String SEEK_DEFAULT_RESOURCE = "sfs-tape-lter";
    public final static int SEEK_DEFAULT_PORT = 7614;
    public final static String SEEK_DEFAULT_SRB_HOST = "srb.sdsc.edu";

    String srbHost, srbUserName, srbPasswd,  srbMdasDomainHome, srbDefaultResource;
    String srbParentCollection, srbFilename;
    int srbPort;

    boolean srbOverrideFlag;

    String[] opNames;
    String[] opValues;

    String srbDataMethod;

    // anonymous can be used in the case of query and get
    public SRBuri(String srb_uri) throws URISyntaxException
    {
        u = new URI(srb_uri);

        srbHost = null;
        srbPort = -1;
        srbUserName = null;
        srbMdasDomainHome = null;
        srbPasswd = null;
        srbParentCollection = null;
        srbDefaultResource = null;

        srbOverrideFlag = false;

        opNames = null;
        opValues = null;

        srbDataMethod = null;

        int i,t;

        // set the SEEK Default
        if((u.getHost()==null) || (u.getHost().compareToIgnoreCase("defaulthost") == 0))
        {
           srbHost = SRBuri.SEEK_DEFAULT_SRB_HOST;
        }
        else
        {
           srbHost = u.getHost();
        }

        if(u.getPort() > 0)
          srbPort = u.getPort();
        else  // set SEEK Default
          srbPort = SRBuri.SEEK_DEFAULT_PORT;

        if(u.getUserInfo() != null)
        {
           String user_and_domain = null;
           String userinfo = u.getUserInfo();
           t = userinfo.length();
           i = userinfo.lastIndexOf(':');
           if(i < 0)
             user_and_domain = userinfo;
           else if(i == 0)
             srbPasswd = userinfo.substring(i+1,t);
           else if((i+1) == t)
             user_and_domain = userinfo;
           else
           {
             user_and_domain = userinfo.substring(0,i);
             srbPasswd = userinfo.substring(i+1,t);
           }

           if(user_and_domain != null)
           {
              t = user_and_domain.length();
              i = user_and_domain.lastIndexOf('.');
              if(i <= 0)
              {
                 throw new URISyntaxException(user_and_domain,"Incorrect input for user and domain.");
              }
              srbUserName = user_and_domain.substring(0,i);
              srbMdasDomainHome = user_and_domain.substring(i+1,t);
           }
        }

        if(u.getPath() != null)
        {
           String filename_w_path = u.getPath();
           t = filename_w_path.length();
           i = filename_w_path.lastIndexOf('/');
           if(i <= 0)
           {
              throw new URISyntaxException(filename_w_path,"The collection or filename is invalid");
           }
           else
           {
              srbParentCollection = filename_w_path.substring(0,i);
              srbFilename = filename_w_path.substring(i+1,t);
           }
        }

        // get all cgi-style queries
        String[] tmpstrs;
        String rs_query = u.getQuery();
        if((rs_query != null)&&(rs_query.length() > 0))
        {
            String[] paired_queries = rs_query.split("&");
            t = paired_queries.length;

            opNames = new String[t];
            opValues = new String[t];

            for(i=0;i<t;i++)
            {
               if((paired_queries[i] == null) || (paired_queries[i].length() == 0))
               {
                  throw new URISyntaxException(rs_query,"Invalid query string in URI.");
               }

               tmpstrs = paired_queries[i].split("=");
               if((tmpstrs == null) || (tmpstrs.length != 2))
               {
                  throw new URISyntaxException(rs_query,"Invalid query string in URI.");
               }

               if((tmpstrs[0]==null)||(tmpstrs[0].length()==0)||(tmpstrs[1]==null)||(tmpstrs[1].length()==0))
               {
                  throw new URISyntaxException(rs_query,"Invalid query string in URI.");
               }

               opNames[i] = tmpstrs[0];
               opValues[i] = tmpstrs[1];
            }
        }

        // process the query list
        if((opNames != null)&&(opNames.length > 0))
        {
            for(i=0;i<opNames.length;i++)
            {
               if(opNames[i].compareToIgnoreCase("defaultResource") == 0)
               {
                  srbDefaultResource = opValues[i];
               }
               else if(opNames[i].compareToIgnoreCase("override") == 0)
               {
                  if(opValues[i].compareToIgnoreCase("true") == 0)
                    srbOverrideFlag = true;
                  else if(opValues[i].compareToIgnoreCase("false") == 0)
                    srbOverrideFlag = false;
                  else
                  {
                    throw new URISyntaxException(rs_query,"Invalid boolean value in override flag in URI's query part.");
                  }
               }
               else if(opValues[i].compareToIgnoreCase("method") == 0)
               {
                  srbDataMethod = opValues[i];
               }
            }
        }

        if((srbDefaultResource == null) || (srbDefaultResource.length() <= 0))   // set to SEEK Defalut
          srbDefaultResource = SRBuri.SEEK_DEFAULT_RESOURCE;
    }

    public String getSrbHost()
    {
       return srbHost;
    }
    public int getSrbPort()
    {
       return srbPort;
    }
    public String getSrbUserName()
    {
       return srbUserName;
    }
    public String getSrbPassword()
    {
       return srbPasswd;
    }
    public String getSrbParentCollection()
    {
       return srbParentCollection;
    }
    public String getSrbMdasDomainHome()
    {
       return srbMdasDomainHome;
    }
    public String getSrbDefaultResource()
    {
       return srbDefaultResource;
    }
    public String getSrbFilename()
    {
       return srbFilename;
    }
    public boolean getSrbOverrideFlag()
    {
       return srbOverrideFlag;
    }
    public String getSrbDataMethod()
    {
       return srbDataMethod;
    }
    public String getOpValueByOpName(String OpName)
    {
       if((opNames == null) || (opValues == null))
         return null;

       int i;
       for(i=0;i<opNames.length;i++)
       {
          if(opNames[i].compareTo(OpName) == 0)
            return opValues[i];
       }

       return null;
    }
}
