package org.ecoinformatics.ecogrid.srb.impl;

import org.ecoinformatics.ecogrid.queryservice.query.*;
import org.ecoinformatics.ecogrid.EcoGridErrorCode;

import org.ecoinformatics.ecogrid.EcogridUtils;


public class SeekXMLQueryDocSRBParser 
{
  int NumOfConditions;

  SrbEcogridQuery SrbQuery = null;

  // constructor
  public SeekXMLQueryDocSRBParser()
  {
  }

  int AddCondition(ConditionType condition)
  {
     OperatorType operator = condition.getOperator();
     String OpStr = operator.getValue();

     String SrhString = condition.get_value();

     // LimitedXPathExpression.
     String AttName = condition.getConcept();

     int t = SrbQuery.AddCondition(AttName,OpStr,SrhString);

     return t;
  }

  int AddConditionArray(ConditionType[] conditions)
  {
     int n = conditions.length;

     int LocalStatus;

     for(int i=0;i<n;i++)
     {
        LocalStatus = AddCondition(conditions[i]);

        if(LocalStatus != 0)
          return LocalStatus;
     }

     return 0;
  }
  
  int HandleAND(ANDType andParent)
  {
     int LocalStatus = 0;

     if(andParent == null)
       return 0;

     if(andParent.getCondition() != null)
     {
        LocalStatus = AddConditionArray(andParent.getCondition());
        if(LocalStatus != 0)
          return LocalStatus;
     }

     if(andParent.getAND() != null)
     {
        HandleAndArray(andParent.getAND());
        if(LocalStatus != 0)
          return LocalStatus;
     }

     if(andParent.getOR() != null)
     {
        HandleORarray(andParent.getOR());
        if(LocalStatus != 0)
          return LocalStatus;
     }

     return 0;
  }

  int HandleAndArray(ANDType[] andArray)
  {
     int LocalStatus;

     if(andArray == null)
       return 0;

     int n = andArray.length;

     for(int i=0;i<n;i++)
     {
        LocalStatus = HandleAND(andArray[i]);
        if(LocalStatus != 0)
          return LocalStatus;
     }

     return 0;
  }

  int HandleOR(ORType orParent)
  {
     if(orParent ==  null)
       return 0;

     return EcoGridErrorCode.SRB_UNSUPPORTED_QUERY_OPERATION;
  }

  int HandleORarray(ORType[] orArray)
  {
     if(orArray == null)
       return 0;

     return EcoGridErrorCode.SRB_UNSUPPORTED_QUERY_OPERATION;
  }

  int TraverseQueryTypeTree(QueryType eq)
  {
     ///////////////////////////////////////////////////////////////////////////////////
     // Important NOTICE: currently we support AND only. So if there is a 'or' we quit.
     ///////////////////////////////////////////////////////////////////////////////////

     int LocalStatus;

     
     String id = eq.getQueryId();
     SrbQuery.SetQueryId(id);

     String[] titleList = eq.getTitle();
     SrbQuery.SetQueryTitle(titleList[0]);

     QueryTypeNamespace NameSpace =  eq.getNamespace();

     // loop again Tree again to get all AND conditions. The current solution is 
     // a temp solution and will be modified to handle complicated one later.
    
     // check the first level operation. We should not see multiple conditions here.
     if(eq.getAND() != null)
     {
        LocalStatus = HandleAND(eq.getAND());       
        if(LocalStatus != 0)
          return LocalStatus;
     }

     // currently SRB don't support OR operation.
     if (eq.getOR() != null)
     {
        LocalStatus = HandleOR(eq.getOR());
        if(LocalStatus != 0)
          return LocalStatus;
     }

     if (eq.getCondition() != null)
        // In this case there is only one condition for the whole query.
     {
        LocalStatus = AddCondition(eq.getCondition());
        if(LocalStatus != 0)
          return LocalStatus;
     }

     return 0;
  } 

  public SrbEcogridQuery ParseQueryType(QueryType ecogridQuery) throws Exception
  {
     int LocalStatus;
     String ErrMsg;

     if(SrbQuery != null)
       SrbQuery = null;

     SrbQuery = new SrbEcogridQuery(SrbEcogridQuery.AND_ONLY_METADATA_CONDITION);

     // set query ID
     SrbQuery.SetQueryId(ecogridQuery.getQueryId());

     // set title
     SrbQuery.SetQueryTitle((ecogridQuery.getTitle())[0]);

     // will traverse Ecogrid Query type and send query info into 'SrbQuery'.
     LocalStatus = TraverseQueryTypeTree(ecogridQuery);

     if(LocalStatus != 0)
     { 
        ErrMsg = "Failed to translate the Ecogrid QueryType into SRB query. Error Code: " + LocalStatus;
        throw new Exception(ErrMsg);
     }

     /*
     if(SrbQuery.GetSrbURI() == null)
     {
        ErrMsg = "There is no SRB URI supplied in the query document.";
        throw new Exception(ErrMsg);
     }
     */

     // double check top level search collection.
     SrbQuery.CheckTopLevelSearchCollection();  

     return SrbQuery;
  }
}
