/**
 *  '$RCSfile: TestEcogridRegistry.java,v $'
 *  Copyright: 2004 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *  Purpose: To test the MetaCatURL class by JUnit
 *    Authors: @Rod SPears@
 *    Release: @release@
 *
 *   '$Author: rspears $'
 *     '$Date: 2004-07-26 22:59:38 $'
 * '$Revision: 1.2 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

import edu.ucsb.nceas.metacat.MetaCatUtil;
import edu.ucsb.nceas.metacat.*;
import edu.ucsb.nceas.utilities.IOUtil;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;

import java.io.*;
import java.net.*;
import java.util.*;

import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.ecoinformatics.ecogrid.registry.EcoRegInterfacePortType;
import org.ecoinformatics.ecogrid.registry.EcoRegInterfaceServiceLocator;
import org.ecoinformatics.ecogrid.registry.EcoRegInterface;

import java.net.URL;
import java.rmi.RemoteException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;

import org.ecoinformatics.ecogrid.EcogridUtils;

import org.ecoinformatics.ecogrid.registry.EcoRegConstants;
import org.ecoinformatics.ecogrid.registry.impl.EcogridJSPBeanIFace;
import org.ecoinformatics.ecogrid.registry.impl.EcogridJSPBeanFactory;
import org.ecoinformatics.ecogrid.registry.impl.EcoRegMetacat;
import org.ecoinformatics.ecogrid.registry.RegEntry;

import org.w3c.dom.Document;
import org.w3c.dom.Node;


/**
 * A JUnit test for testing Query and Resultset Transforms
 */
public class TestEcogridRegistry extends TestCase
{
  EcoRegMetacat regMetacat = null;

  /**  setUp DB Connection */
  public void setUp() {
    EcogridUtils.setDebug(true);

    boolean status = true;
    try {
      regMetacat = new EcoRegMetacat();
      if (regMetacat != null) {
        status = regMetacat.openRegistry("");
        regMetacat.removeEntry("testEntry");
        regMetacat.removeEntry("testEntryXXX");
      }
    } catch (Exception e) {
      System.err.println(e);
      e.printStackTrace(System.err);
    }
  }

  /**  setUp DB Connection */
  public void tearDown() {
    regMetacat = null;
  }

  /**  Test the registry getXMLListing */
  public void testGetXMLListing() {

    boolean status = true;
    try {
      if (regMetacat != null) {
        String results = regMetacat.getXMLListing();
        regMetacat.closeRegistry();
      }
    } catch (Exception e) {
      System.err.println(e);
      e.printStackTrace(System.err);
    }

    assertTrue(status);
  }

  /**  Test the registry getList */
  public void testGetList() {

    boolean status = true;
    try {
      if (regMetacat != null) {
        RegEntry[] entries = regMetacat.getList();
        status = entries.length > 0;
        regMetacat.closeRegistry();
      }
    } catch (Exception e) {
      System.err.println(e);
      e.printStackTrace(System.err);
    }

    assertTrue(status);
  }

  /**  Test the registry registerEntry */
  public void testRegisterEntry() {

    boolean status = true;
    try {
      if (regMetacat != null) {
        status = regMetacat.registerEntry("testEntry", "", "testEntry/Resource") == EcoRegConstants.kNoError;
      }
    } catch (Exception e) {
      System.err.println(e);
      e.printStackTrace(System.err);
    }

    assertTrue(status);
  }

  /**  Test the registry removeEntry */
  public void testRemoveEntry() {

    boolean status = true;
    try {
      if (regMetacat != null) {
        status = regMetacat.removeEntry("testEntry") == EcoRegConstants.kNoError;
      }
    } catch (Exception e) {
      System.err.println(e);
      e.printStackTrace(System.err);
    }

    assertTrue(status);
  }

  /**  Test the registry updateEntry */
  public void testUpdateEntry() {
    System.err.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXxx");

    boolean status = true;
    try {
      if (regMetacat != null) {
        boolean rv = regMetacat.registerEntry("testEntryXXX", "", "testEntry/Resource") == EcoRegConstants.kNoError;
        regMetacat.logout();
        regMetacat.login();
        if (rv) {
          System.err.println("==========================================");
          String results = regMetacat.getXMLListing();
          System.err.println(results);
          int rc = regMetacat.updateEntry("testEntryXXX", "", "testEntry/ResourceXXX");
          System.err.println("rc = " + rc);
          status = rc == EcoRegConstants.kNoError;
          System.err.println("==========================================");
          rv = regMetacat.removeEntry("testEntryXXX") == EcoRegConstants.kNoError;
        }
      }

    } catch (Exception e) {
      System.err.println(e);
      e.printStackTrace(System.err);
    }
    System.err.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXxx");

    assertTrue(status);
  }
}
