/**
 *  '$RCSfile: AuthenticationServiceClientTest.java,v $'
 *  Copyright: 2004 Regents of the University of California and the
 *              National Center for Ecological Analysis and Synthesis
 *
 *   '$Author: leinfelder $'
 *     '$Date: 2008-10-31 17:48:27 $'
 * '$Revision: 1.3 $'
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.ecoinformatics.ecogrid.client;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * A JUnit test for testing the service client
 */
public class AuthenticationServiceClientTest extends TestCase {
	private String username = "uid=test,o=NCEAS,dc=ecoinformatics,dc=org";
	private String password = "test";
	private String badPassword = "xxx";
	private String endpoint = "http://dev.nceas.ucsb.edu/knb/services/AuthenticationService";// "@baseURL@/@authen.service.name@";
	private String sessionId = null;

	/**
	 * Constructor to build the test
	 * 
	 * @param name
	 *            the name of the test method
	 */
	public AuthenticationServiceClientTest(String name) {
		super(name);
	}

	/**
	 * Establish a testing framework by initializing appropriate objects
	 */
	public void setUp() {

	}

	/**
	 * Release any objects after tests are complete
	 */
	public void tearDown() {
	}

	/**
	 * Create a suite of tests to be run together
	 */
	public static Test suite() {
		TestSuite suite = new TestSuite();
		suite.addTest(new AuthenticationServiceClientTest("initialize"));
		suite.addTest(new AuthenticationServiceClientTest("loginFailed"));
		suite.addTest(new AuthenticationServiceClientTest("loginSuccess"));
		suite.addTest(new AuthenticationServiceClientTest("logout"));
		return suite;
	}

	/**
	 * Run an initial test that always passes to check that the test harness is
	 * working.
	 */
	public void initialize() {
		assertTrue(1 == 1);
	}
	

	/**
	 * Method to test login failed
	 */
	public void loginFailed() {
		try {
			// create a client object
			AuthenticationServiceClient client = 
				new AuthenticationServiceClient(endpoint);
			sessionId = client.login_action(username, badPassword);
		    fail("login successfule with wrong password");
		} catch (Exception e) {
			e.printStackTrace();
		    assertTrue(1==1);
		}
	}// login
	/**
	 * Method to test login success method
	 */
	public void loginSuccess() {
		try {
			// create a client object
			AuthenticationServiceClient client = 
				new AuthenticationServiceClient(endpoint);
			sessionId = client.login_action(username, password);
			System.out.println("login success "+sessionId);
			assertFalse(sessionId.equals("an unknown error"));
		} catch (Exception e) {
			e.printStackTrace();
			fail("Authentication exception:\n" + e.getMessage());
		}
	}// login

	/**
	 * Method to test logout method
	 */
	public void logout() {
		try {
			// create a client object
			AuthenticationServiceClient client = 
				new AuthenticationServiceClient(endpoint);
			String response = client.logout_action(sessionId);
			System.out.println("logout out "+response);
			assertTrue("logout didn't success "+response, response.indexOf("logout succeeded") != -1);
		} catch (Exception e) {
			e.printStackTrace();
			fail("Authentication exception:\n" + e.getMessage());
		}

	}

}
