#!/usr/bin/env python

from ZSI.client import Binding
from ZSI.TC import *
from ZSI import AUTH

import sys
from string import join

from time import time

from Ft.Xml.Domlette import NonvalidatingReader
from Ft.Lib import Uri

print "Creating Binding object"

host = "ecogrid.ecoinformatics.org"
url='/knb/services/EcoGridQuery'

print "Loading file %s" % sys.argv[1] 

file_uri = Uri.OsPathToUri(sys.argv[1], attemptAbsolute=1 )
doc = NonvalidatingReader.parseUri( file_uri )

queryid = doc.xpath("/*[local-name()='query']/@queryId")[0]
queryid.value = sys.argv[2]

b = Binding( url=url, host=host, port="80", tracefile=sys.stdout)

t1 = time()

b.Send( None, 'query',  doc, soapaction='ecogrid://ecoinformatics.org/ecogrid-queryinterface-levelone-1.0.0beta2#query', requesttypecode=XML(wrapped=1,pname='query',inline=1) )

t2 = time()

resp = b.ReceiveRaw()
print resp

t3 = time()

print "Times: %.10f %.10f %.10f" % ( t1, t2-t1, t3-t2 )

