<?xml version="1.0"?>
<!--
  *  '$RCSfile: ecogridToPathquery.xsl,v $'
  *      Authors: Matt Jones
  *    Copyright: 2000 Regents of the University of California and the
  *               National Center for Ecological Analysis and Synthesis
  *  For Details: http://www.nceas.ucsb.edu/
  *
  *   '$Author: leinfelder $'
  *     '$Date: 2007-12-01 00:27:17 $'
  * '$Revision: 1.3 $'
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 2 of the License, or
  * (at your option) any later version.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  *
  * This is an XSLT (http://www.w3.org/TR/xslt) stylesheet designed to
  * convert an eco grid query XML file to metacat path query XML file
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="xml" encoding="utf-8"/>
   <xsl:template match="/">
    <xsl:apply-templates select="./*"/>
   </xsl:template>
   
   <xsl:template match="*[local-name()='query']">
     <pathquery version="1.2">
         <xsl:for-each select=".">
            <xsl:call-template name="getQueryId"/>
         </xsl:for-each>
         <xsl:for-each select="title">
             <xsl:call-template name="getQueryTitle"/>
         </xsl:for-each>
         <xsl:for-each select="namespace">
             <xsl:call-template name="getReturnDocType"/>
         </xsl:for-each>
         <xsl:for-each select="returnField">
             <xsl:call-template name="getReturnField"/>
         </xsl:for-each>
         <xsl:for-each select="AND">
          <xsl:call-template name="andType"/>
        </xsl:for-each>
        <xsl:for-each select="OR">
          <xsl:call-template name="orType"/>
        </xsl:for-each>
        <xsl:for-each select="condition">
          <querygroup operator="INTERSECT" >
            <xsl:call-template name="conditionType"/>
          </querygroup>
      </xsl:for-each>
     </pathquery>
   </xsl:template>
   
   <xsl:template name="getQueryId">
       <xsl:if test="./@queryId">
          <meta_file_id><xsl:value-of select="./@queryId"/></meta_file_id>
       </xsl:if>
   </xsl:template>
   
   <xsl:template name="getQueryTitle">
      <querytitle><xsl:value-of select="."/></querytitle>
   </xsl:template>
   
   <xsl:template name="getReturnDocType">
       <returndoctype><xsl:value-of select="."/></returndoctype>
   </xsl:template>
   
   <xsl:template name="getReturnField">
       <returnfield><xsl:value-of select="."/></returnfield>
   </xsl:template>
   
   <xsl:template name="andType">
      <querygroup operator="INTERSECT">
        <xsl:call-template name="choice"/>
      </querygroup>  
  </xsl:template>
   
   <xsl:template name="orType">
     <querygroup operator="UNION">
        <xsl:call-template name="choice"/>
     </querygroup>  
   </xsl:template>
   
   <xsl:template name="conditionType">
      <xsl:if test="normalize-space(./@operator)='LIKE' ">
          <xsl:variable name="mode">contains</xsl:variable>
          <queryterm casesensitive="false" searchmode="contains">
           <value><xsl:value-of select="."/></value>
	   <xsl:if test="./@concept != '/'">
	       <pathexpr><xsl:value-of select="./@concept"/></pathexpr>
	   </xsl:if>
        </queryterm>
      </xsl:if>
      <xsl:if test="normalize-space(./@operator)='EQUALS' ">
            <xsl:variable name="mode">equals</xsl:variable>
            <queryterm casesensitive="false" searchmode="equals">
             <value><xsl:value-of select="."/></value>
	     <xsl:if test="./@concept != '/'">
		<pathexpr><xsl:value-of select="./@concept"/></pathexpr>
	     </xsl:if>
           </queryterm>
      </xsl:if>
      <xsl:if test="./@operator='NOT LIKE' or normalize-space(./@operator)='NOT EQUALS' ">
            <xsl:variable name="mode">isnot-equals</xsl:variable>
            <queryterm casesensitive="false" searchmode="isnot-equals">
               <value><xsl:value-of select="."/></value>
		<xsl:if test="./@concept != '/'">
		  <pathexpr><xsl:value-of select="./@concept"/></pathexpr>
		</xsl:if>
         </queryterm>
      </xsl:if>
      <xsl:if test="normalize-space(./@operator)='LESS THAN' ">
            <xsl:variable name="mode">less-than</xsl:variable>
            <queryterm casesensitive="false" searchmode="less-than">
              <value><xsl:value-of select="."/></value>
		<xsl:if test="./@concept != '/'">
                  <pathexpr><xsl:value-of select="./@concept"/></pathexpr>
		</xsl:if>
            </queryterm>
      </xsl:if>
       <xsl:if test="normalize-space(./@operator)='LESS THAN OR EQUALS' ">
            <xsl:variable name="mode">less-than-equals</xsl:variable>
            <queryterm casesensitive="false" searchmode="less-than-equals">
              <value><xsl:value-of select="."/></value>
		<xsl:if test="./@concept != '/'">
		   <pathexpr><xsl:value-of select="./@concept"/></pathexpr>
		</xsl:if>
          </queryterm>
      </xsl:if>
       <xsl:if test="./@operator='GREATER THAN' ">
            <xsl:variable name="mode">greater-than</xsl:variable>
            <queryterm casesensitive="false" searchmode="greater-than">
               <value><xsl:value-of select="."/></value>
		<xsl:if test="./@concept != '/'">
                   <pathexpr><xsl:value-of select="./@concept"/></pathexpr>
		</xsl:if>
            </queryterm>
      </xsl:if>
       <xsl:if test="normalize-space(./@operator)='GREATER THAN OR EQUALS' ">
            <xsl:variable name="mode">greater-than-equals</xsl:variable>
            <queryterm casesensitive="false" searchmode="greater-than-equals">
               <value><xsl:value-of select="."/></value>
		<xsl:if test="./@concept != '/'">
                   <pathexpr><xsl:value-of select="./@concept"/></pathexpr>
		</xsl:if>
            </queryterm>
      </xsl:if>
     
    
   </xsl:template>
   
   <xsl:template name="choice">
     <xsl:for-each select="AND">
          <xsl:call-template name="andType"/>
        </xsl:for-each>
        <xsl:for-each select="OR">
          <xsl:call-template name="orType"/>
        </xsl:for-each>
        <xsl:for-each select="condition">
          <xsl:call-template name="conditionType"/>
      </xsl:for-each>
   </xsl:template>
   
 </xsl:stylesheet>
