/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;

public class DBSimpleQuery {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Wrong number of arguments!!!");
            System.err.println("USAGE: java DBSimpleQuery <query> <doctype>");
            return;
        }
        try {
            String query = args[0];
            String doctype = args[1];
            DBSimpleQuery rd = new DBSimpleQuery();
            Hashtable nodelist = null;
            nodelist = doctype.equals("any") || doctype.equals("ANY") ? rd.findDocuments(query) : rd.findDocuments(query, doctype);
            StringBuffer result = new StringBuffer();
            String document = null;
            String docid = null;
            result.append("<?xml version=\"1.0\"?>\n");
            result.append("<resultset>\n");
            Enumeration doclist = nodelist.keys();
            while (doclist.hasMoreElements()) {
                docid = (String)doclist.nextElement();
                document = (String)nodelist.get(docid);
                result.append("  <document>\n    " + document + "\n  </document>\n");
            }
            result.append("</resultset>\n");
            System.out.println(result);
        }
        catch (Exception e) {
            System.err.println("Error in DBSimpleQuery.main");
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public Hashtable findDocuments(String query) {
        return this.findDocuments(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable findDocuments(String query, String requestedDoctype) {
        Hashtable<String, String> docListResult = new Hashtable<String, String>();
        PreparedStatement pstmt = null;
        DBConnection dbConn = null;
        int serialNumber = -1;
        String docid = null;
        String docname = null;
        String doctype = null;
        String doctitle = null;
        try {
            dbConn = DBConnectionPool.getDBConnection("DBSimpleQuery.findDocuments");
            serialNumber = dbConn.getCheckOutSerialNumber();
            if (requestedDoctype == null || requestedDoctype.equals("any") || requestedDoctype.equals("ANY")) {
                pstmt = dbConn.prepareStatement("SELECT docid,docname,doctype,doctitle FROM xml_documents WHERE docid IN (SELECT docid FROM xml_nodes WHERE nodedata LIKE ? )");
                pstmt.setString(1, query);
            } else {
                pstmt = dbConn.prepareStatement("SELECT docid,docname,doctype,doctitle FROM xml_documents WHERE docid IN (SELECT docid FROM xml_nodes WHERE nodedata LIKE ? ) AND doctype = ?");
                pstmt.setString(1, query);
                pstmt.setString(2, requestedDoctype);
            }
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean tableHasRows = rs.next();
            while (tableHasRows) {
                docid = rs.getString(1);
                docname = rs.getString(2);
                doctype = rs.getString(3);
                doctitle = rs.getString(4);
                StringBuffer document = new StringBuffer();
                document.append("<docid>").append(docid).append("</docid>");
                if (docname != null) {
                    document.append("<docname>" + docname + "</docname>");
                }
                if (doctype != null) {
                    document.append("<doctype>" + doctype + "</doctype>");
                }
                if (doctitle != null) {
                    document.append("<doctitle>" + doctitle + "</doctitle>");
                }
                docListResult.put(docid, document.toString());
                tableHasRows = rs.next();
            }
            pstmt.close();
        }
        catch (SQLException e) {
            System.out.println("Error in DBSimpleQuery.findDocuments: " + e.getMessage());
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return docListResult;
    }
}

