/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.accesscontrol;

import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.PermissionController;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlException;
import edu.ucsb.nceas.metacat.accesscontrol.PermOrderException;
import edu.ucsb.nceas.metacat.accesscontrol.XMLAccessAccess;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.AccessException;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.access.AccessControlInterface;
import edu.ucsb.nceas.utilities.access.DocInfoHandler;
import edu.ucsb.nceas.utilities.access.XMLAccessDAO;
import java.io.IOException;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class AccessControlForSingleFile
implements AccessControlInterface {
    private String _guid;
    private Logger logMetacat = Logger.getLogger(AccessControlForSingleFile.class);

    public AccessControlForSingleFile(String accessionNumber) throws AccessControlException {
        String docid = DocumentUtil.getDocIdFromString(accessionNumber);
        String revision = DocumentUtil.getRevisionStringFromString(accessionNumber);
        int rev = -1;
        if (revision != null) {
            rev = Integer.valueOf(revision);
        } else {
            try {
                rev = DBUtil.getLatestRevisionInDocumentTable(docid);
            }
            catch (SQLException e) {
                AccessControlException ace = new AccessControlException(e.getMessage());
                ace.initCause(e);
                throw ace;
            }
            if (rev <= 0) {
                try {
                    rev = DBUtil.getMaxRevFromRevisionTable(docid);
                }
                catch (SQLException e) {
                    AccessControlException ace = new AccessControlException(e.getMessage());
                    ace.initCause(e);
                    throw ace;
                }
            }
        }
        try {
            this._guid = IdentifierManager.getInstance().getGUID(docid, rev);
        }
        catch (McdbDocNotFoundException e) {
            AccessControlException ace = new AccessControlException(e.getMessage());
            ace.initCause(e);
            throw ace;
        }
        if (this._guid == null || this._guid.equals("")) {
            throw new AccessControlException("Guid cannot be null");
        }
        this.logMetacat.debug((Object)("AccessControlForSingleFile() - docid: " + this._guid));
    }

    public void insertPermissions(XMLAccessDAO xmlAccessDAO) throws AccessControlException, PermOrderException {
        this.insertPermissions(xmlAccessDAO.getPrincipalName(), xmlAccessDAO.getPermission(), xmlAccessDAO.getPermType(), xmlAccessDAO.getPermOrder(), xmlAccessDAO.getAccessFileId(), xmlAccessDAO.getSubTreeId());
    }

    public void insertPermissions(String principalName, Long permission, String permType, String permOrder, String accessFileId, String subTreeId) throws AccessControlException, PermOrderException {
        try {
            XMLAccessAccess xmlAccessAccess = new XMLAccessAccess();
            xmlAccessAccess.addXMLAccess(this._guid, principalName, new Long(permission), permType, permOrder, accessFileId, subTreeId);
        }
        catch (AccessException ae) {
            throw new AccessControlException("AccessControlForSingleFile.insertPermissions - DB access error when inserting permissions: " + ae.getMessage());
        }
    }

    public void insertPermissions(String accessBlock) throws AccessControlException {
        try {
            DocInfoHandler docInfoHandler;
            XMLReader parser = null;
            DocInfoHandler chandler = docInfoHandler = new DocInfoHandler(this._guid);
            String parserName = PropertyService.getProperty("xml.saxparser");
            parser = XMLReaderFactory.createXMLReader(parserName);
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setContentHandler((ContentHandler)chandler);
            parser.setErrorHandler((ErrorHandler)chandler);
            parser.parse(new InputSource(new StringReader(accessBlock)));
            XMLAccessAccess xmlAccessAccess = new XMLAccessAccess();
            Vector accessControlList = docInfoHandler.getAccessControlList();
            xmlAccessAccess.replaceAccess(this._guid, accessControlList);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new AccessControlException("AccessControlForSingleFile.insertPermissions - property error when replacing permissions: " + pnfe.getMessage());
        }
        catch (AccessException ae) {
            throw new AccessControlException("AccessControlForSingleFile.insertPermissions - DB access error when replacing permissions: " + ae.getMessage());
        }
        catch (SAXException se) {
            throw new AccessControlException("AccessControlForSingleFile.insertPermissions - SAX error when replacing permissions: " + se.getMessage());
        }
        catch (IOException ioe) {
            throw new AccessControlException("AccessControlForSingleFile.insertPermissions - I/O error when replacing permissions: " + ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accessControlExists(XMLAccessDAO xmlAccessDAO) throws AccessControlException {
        boolean exists = false;
        Statement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            conn = DBConnectionPool.getDBConnection("AccessControlForSingleFiel.accessControlExists");
            serialNumber = conn.getCheckOutSerialNumber();
            pstmt = conn.prepareStatement("SELECT * FROM xml_access WHERE guid = ? AND principal_name = ? AND permission = ? AND perm_type = ? AND perm_order = ? ");
            pstmt.setString(1, this._guid);
            pstmt.setString(2, xmlAccessDAO.getPrincipalName());
            pstmt.setLong(3, xmlAccessDAO.getPermission());
            pstmt.setString(4, xmlAccessDAO.getPermType());
            pstmt.setString(5, xmlAccessDAO.getPermOrder());
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            exists = rs.next();
            return exists;
        }
        catch (SQLException sqle) {
            throw new AccessControlException("AccessControlForSingleFile.accessControlExists - SQL error when checking if access control exists: " + sqle.getMessage());
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (SQLException sqle) {
                this.logMetacat.error((Object)("AccessControlForSingleFile.accessControlExists - Could not close prepared statement: " + sqle.getMessage()));
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
    }

    public String getACL(String user, String[] groups) throws AccessControlException {
        StringBuffer output = new StringBuffer();
        boolean hasPermission = false;
        try {
            hasPermission = this.isOwned(user);
            if (!hasPermission) {
                String docid = IdentifierManager.getInstance().getLocalId(this._guid);
                PermissionController controller = new PermissionController(docid);
                hasPermission = controller.hasPermission(user, groups, "READ");
            }
            if (hasPermission) {
                XMLAccessAccess xmlAccessAccess = new XMLAccessAccess();
                Vector<XMLAccessDAO> xmlAccessDAOList = xmlAccessAccess.getXMLAccessForDoc(this._guid);
                output.append(this.getAccessString(xmlAccessDAOList));
            } else {
                output.append(this.getAccessString(new Vector<XMLAccessDAO>()));
            }
            return output.toString();
        }
        catch (SQLException sqle) {
            throw new AccessControlException("AccessControlForSingleFile.getACL() - SQL error when getting ACL: " + sqle.getMessage());
        }
        catch (AccessException ae) {
            throw new AccessControlException("AccessControlForSingleFile.getACL() - DB access error when getting ACL: " + ae.getMessage());
        }
        catch (McdbException mcdb) {
            throw new AccessControlException("AccessControlForSingleFile.getACL() - MCDB error when getting ACL: " + mcdb.getMessage());
        }
    }

    public String getAccessString() throws AccessControlException {
        Vector<XMLAccessDAO> xmlAccessDAOList = null;
        try {
            XMLAccessAccess xmlAccessAccess = new XMLAccessAccess();
            xmlAccessDAOList = xmlAccessAccess.getXMLAccessForDoc(this._guid);
        }
        catch (AccessException ae) {
            throw new AccessControlException("AccessControlForSingleFile.getAccessString() - DB access error when getting access string: " + ae.getMessage());
        }
        return this.getAccessString(xmlAccessDAOList);
    }

    public String getAccessString(Vector<XMLAccessDAO> xmlAccessDAOList) throws AccessControlException {
        StringBuffer output = new StringBuffer();
        StringBuffer tmpOutput = new StringBuffer();
        StringBuffer allowOutput = new StringBuffer();
        StringBuffer denyOutput = new StringBuffer();
        String principal = null;
        int permission = -1;
        String permOrder = "allowFirst";
        String permType = null;
        String accessfileid = null;
        String subtreeid = null;
        if (xmlAccessDAOList.size() > 0) {
            permOrder = xmlAccessDAOList.get(0).getPermOrder();
            accessfileid = xmlAccessDAOList.get(0).getAccessFileId();
            subtreeid = xmlAccessDAOList.get(0).getSubTreeId();
        }
        String docid = this._guid;
        try {
            docid = IdentifierManager.getInstance().getLocalId(this._guid);
        }
        catch (McdbDocNotFoundException e) {
            this.logMetacat.warn((Object)("Could not lookup docid for guid, defaulting to guid: " + this._guid), (Throwable)e);
        }
        catch (SQLException e) {
            throw new AccessControlException("Couldn't identify the local id of the object with the specified identifier " + this._guid + " since " + e.getMessage());
        }
        output.append("<access authSystem=\"knb\" order=\"" + permOrder + "\" id=\"" + docid + "\" scope=\"document\"");
        if (accessfileid != null) {
            output.append(" accessfileid=\"" + accessfileid + "\"");
        }
        if (subtreeid != null) {
            output.append(" subtreeid=\"" + subtreeid + "\"");
        }
        output.append(">\n");
        for (XMLAccessDAO xmlAccessDAO : xmlAccessDAOList) {
            principal = xmlAccessDAO.getPrincipalName();
            permission = xmlAccessDAO.getPermission().intValue();
            permType = xmlAccessDAO.getPermType();
            tmpOutput.append("    <" + permType + ">\n");
            tmpOutput.append("      <principal>" + principal + "</principal>\n");
            if ((permission & 4) == 4) {
                tmpOutput.append("      <permission>read</permission>\n");
            }
            if ((permission & 2) == 2) {
                tmpOutput.append("      <permission>write</permission>\n");
            }
            if ((permission & 7) == 7) {
                tmpOutput.append("      <permission>all</permission>\n");
            }
            if ((permission & 1) == 1) {
                tmpOutput.append("      <permission>chmod</permission>\n");
            }
            tmpOutput.append("    </" + permType + ">\n");
            if (permType.equals("allow")) {
                allowOutput.append(tmpOutput);
            } else if (permType.equals("deny")) {
                denyOutput.append(tmpOutput);
            }
            tmpOutput = new StringBuffer();
        }
        if (permOrder.equals("allowFirst")) {
            output.append(allowOutput);
            output.append(denyOutput);
        } else if (permOrder.equals("denyFirst")) {
            output.append(denyOutput);
            output.append(allowOutput);
        }
        output.append("</access>");
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOwned(String user) throws SQLException {
        Statement pstmt = null;
        DBConnection conn = null;
        int serialNumber = -1;
        try {
            boolean hasRow;
            conn = DBConnectionPool.getDBConnection("AccessControlList.isOwned");
            serialNumber = conn.getCheckOutSerialNumber();
            String query = "SELECT id.guid FROM xml_documents xd, identifier id WHERE xd.docid = id.docid AND xd.rev = id.rev AND id.guid = ? AND user_owner = ? ";
            pstmt = conn.prepareStatement(query);
            pstmt.setString(1, this._guid);
            pstmt.setString(2, user);
            pstmt.execute();
            ResultSet rs = pstmt.getResultSet();
            boolean bl = hasRow = rs.next();
            return bl;
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            finally {
                DBConnectionPool.returnDBConnection(conn, serialNumber);
            }
        }
    }
}

