/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.advancedsearch;

import edu.ucsb.nceas.metacat.advancedsearch.AdvancedSearchBean;
import edu.ucsb.nceas.metacat.advancedsearch.AdvancedSearchPathQuery;
import edu.ucsb.nceas.metacat.advancedsearch.AdvancedSearchQueryGroup;
import edu.ucsb.nceas.metacat.advancedsearch.AdvancedSearchQueryTerm;
import edu.ucsb.nceas.metacat.advancedsearch.LTERSite;
import edu.ucsb.nceas.metacat.advancedsearch.MetacatHelper;
import edu.ucsb.nceas.metacat.advancedsearch.Stylizer;
import edu.ucsb.nceas.metacat.client.Metacat;
import edu.ucsb.nceas.metacat.client.MetacatFactory;
import edu.ucsb.nceas.metacat.client.MetacatInaccessibleException;
import edu.ucsb.nceas.utilities.IOUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public class AdvancedSearch {
    private AdvancedSearchBean advancedSearchBean = null;
    private String caseSensitive;
    private final String globalOperator;
    private boolean hasSubjectSearch = false;
    private boolean hasAuthorSearch = false;
    private boolean hasSpatialSearch = false;
    private boolean hasTaxonomicSearch = false;
    private boolean hasTemporalSearch = false;
    private boolean hasSiteFilter = false;
    private int indentLevel = 2;
    private boolean isCaseSensitive = false;
    private AdvancedSearchPathQuery pathQuery;
    private AdvancedSearchQueryGroup queryGroup;
    private String queryString;
    private String site;
    private final String title = "Advanced Search";

    public AdvancedSearch(AdvancedSearchBean advancedSearchBean) {
        int allAny = 0;
        String indent = this.getIndent(this.indentLevel * 1);
        if (advancedSearchBean != null) {
            allAny = advancedSearchBean.getFormAllAny();
            this.isCaseSensitive = advancedSearchBean.isCaseSensitive();
            this.site = advancedSearchBean.getSiteValue();
        }
        this.globalOperator = allAny == 0 ? "INTERSECT" : "UNION";
        this.caseSensitive = this.isCaseSensitive ? "true" : "false";
        this.queryGroup = new AdvancedSearchQueryGroup(this.globalOperator, indent);
        this.pathQuery = new AdvancedSearchPathQuery("Advanced Search", this.queryGroup, indent);
        this.advancedSearchBean = advancedSearchBean;
    }

    private void addTerm(ArrayList terms, StringBuffer term) {
        String s = term.toString().trim();
        if (s.length() > 0) {
            terms.add(s);
        }
    }

    private void buildQuerySubject() {
        int allAny = this.advancedSearchBean.getSubjectAllAny();
        String innerOperator = "UNION";
        AdvancedSearchQueryGroup innerQuery = null;
        String subjectField = this.advancedSearchBean.getSubjectField();
        int subjectQueryType = this.advancedSearchBean.getSubjectQueryType();
        String value = this.advancedSearchBean.getSubjectValue();
        if (value != null && !value.equals("")) {
            this.hasSubjectSearch = true;
            String outerOperator = allAny == 0 ? "INTERSECT" : "UNION";
            String indent = this.getIndent(this.indentLevel * 2);
            AdvancedSearchQueryGroup outerQuery = new AdvancedSearchQueryGroup(outerOperator, indent);
            ArrayList terms = this.parseTermsAdvanced(value);
            String searchMode = this.metacatSearchMode(subjectQueryType);
            for (int i = 0; i < terms.size(); ++i) {
                AdvancedSearchQueryTerm qt;
                String emlField;
                String term = (String)terms.get(i);
                indent = this.getIndent(this.indentLevel * 3);
                innerQuery = new AdvancedSearchQueryGroup("UNION", indent);
                indent = this.getIndent(this.indentLevel * 4);
                if (subjectField.equals("ALL") || subjectField.equals("TITLE")) {
                    emlField = "dataset/title";
                    qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, term, indent);
                    innerQuery.addQueryTerm(qt);
                }
                if (subjectField.equals("ALL") || subjectField.equals("ABSTRACT")) {
                    emlField = "dataset/abstract/para";
                    qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, term, indent);
                    innerQuery.addQueryTerm(qt);
                    emlField = "dataset/abstract/section/para";
                    qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, term, indent);
                    innerQuery.addQueryTerm(qt);
                }
                if (subjectField.equals("ALL") || subjectField.equals("KEYWORDS")) {
                    emlField = "keywordSet/keyword";
                    qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, term, indent);
                    innerQuery.addQueryTerm(qt);
                }
                outerQuery.addQueryGroup(innerQuery);
            }
            if (terms.size() > 1) {
                this.queryGroup.addQueryGroup(outerQuery);
            } else if (terms.size() == 1) {
                this.queryGroup.addQueryGroup(innerQuery);
            }
        }
    }

    private void buildQueryAuthor() {
        AdvancedSearchQueryTerm qt;
        String searchMode;
        String emlField;
        boolean addQueryGroup = false;
        int creatorSurnameQueryType = this.advancedSearchBean.getCreatorSurnameQueryType();
        int creatorOrganizationQueryType = this.advancedSearchBean.getCreatorOrganizationQueryType();
        String indent = this.getIndent(this.indentLevel * 2);
        AdvancedSearchQueryGroup qg = new AdvancedSearchQueryGroup(this.globalOperator, indent);
        String value = this.advancedSearchBean.getCreatorSurname();
        indent = this.getIndent(this.indentLevel * 3);
        if (value != null && !value.equals("")) {
            emlField = "dataset/creator/individualName/surName";
            searchMode = this.metacatSearchMode(creatorSurnameQueryType);
            qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, value, indent);
            qg.addQueryTerm(qt);
            addQueryGroup = true;
        }
        if ((value = this.advancedSearchBean.getCreatorOrganization()) != null && !value.equals("")) {
            emlField = "creator/organizationName";
            searchMode = this.metacatSearchMode(creatorOrganizationQueryType);
            qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, value, indent);
            qg.addQueryTerm(qt);
            addQueryGroup = true;
        }
        if (addQueryGroup) {
            this.hasAuthorSearch = true;
            this.queryGroup.addQueryGroup(qg);
        }
    }

    private void buildQuerySpatialCriteria() {
        AdvancedSearchQueryTerm qt;
        String emlField;
        String searchMode;
        boolean addBoundingValues = false;
        boolean addGeographicDescription = false;
        boolean boundaryContained = this.advancedSearchBean.isBoundaryContained();
        String operator = "INTERSECT";
        String indent = this.getIndent(this.indentLevel * 2);
        AdvancedSearchQueryGroup qgSpatial = new AdvancedSearchQueryGroup(this.globalOperator, indent);
        indent = this.getIndent(this.indentLevel * 3);
        AdvancedSearchQueryGroup qgBounding = new AdvancedSearchQueryGroup("INTERSECT", indent);
        AdvancedSearchQueryGroup qgGeographicDescription = new AdvancedSearchQueryGroup("INTERSECT", indent);
        indent = this.getIndent(this.indentLevel * 4);
        String value = this.advancedSearchBean.getLocationName();
        if (value != null && !value.equals("")) {
            searchMode = "contains";
            emlField = "geographicCoverage/geographicDescription";
            qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, value, indent);
            qgGeographicDescription.addQueryTerm(qt);
            addGeographicDescription = true;
        }
        if (boundaryContained) {
            String westValue;
            String eastValue;
            String southValue;
            String northValue = this.advancedSearchBean.getNorthBound();
            if (northValue != null && !northValue.equals("")) {
                emlField = "geographicCoverage/boundingCoordinates/northBoundingCoordinate";
                searchMode = "less-than-equals";
                qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, northValue, indent);
                qgBounding.addQueryTerm(qt);
                addBoundingValues = true;
            }
            if ((southValue = this.advancedSearchBean.getSouthBound()) != null && !southValue.equals("")) {
                emlField = "geographicCoverage/boundingCoordinates/southBoundingCoordinate";
                searchMode = "greater-than-equals";
                qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, southValue, indent);
                qgBounding.addQueryTerm(qt);
                addBoundingValues = true;
            }
            if ((eastValue = this.advancedSearchBean.getEastBound()) != null && !eastValue.equals("")) {
                emlField = "geographicCoverage/boundingCoordinates/eastBoundingCoordinate";
                searchMode = "less-than-equals";
                qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, eastValue, indent);
                qgBounding.addQueryTerm(qt);
                addBoundingValues = true;
            }
            if ((westValue = this.advancedSearchBean.getWestBound()) != null && !westValue.equals("")) {
                emlField = "geographicCoverage/boundingCoordinates/westBoundingCoordinate";
                searchMode = "greater-than-equals";
                qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, westValue, indent);
                qgBounding.addQueryTerm(qt);
                addBoundingValues = true;
            }
        } else {
            String westValue;
            String eastValue;
            String southValue;
            String northValue = this.advancedSearchBean.getNorthBound();
            if (northValue != null && !northValue.equals("")) {
                emlField = "geographicCoverage/boundingCoordinates/southBoundingCoordinate";
                searchMode = "less-than";
                qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, northValue, indent);
                qgBounding.addQueryTerm(qt);
                addBoundingValues = true;
            }
            if ((southValue = this.advancedSearchBean.getSouthBound()) != null && !southValue.equals("")) {
                emlField = "geographicCoverage/boundingCoordinates/northBoundingCoordinate";
                searchMode = "greater-than";
                qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, southValue, indent);
                qgBounding.addQueryTerm(qt);
                addBoundingValues = true;
            }
            if ((eastValue = this.advancedSearchBean.getEastBound()) != null && !eastValue.equals("")) {
                emlField = "geographicCoverage/boundingCoordinates/westBoundingCoordinate";
                searchMode = "less-than";
                qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, eastValue, indent);
                qgBounding.addQueryTerm(qt);
                addBoundingValues = true;
            }
            if ((westValue = this.advancedSearchBean.getWestBound()) != null && !westValue.equals("")) {
                emlField = "geographicCoverage/boundingCoordinates/eastBoundingCoordinate";
                searchMode = "greater-than";
                qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, westValue, indent);
                qgBounding.addQueryTerm(qt);
                addBoundingValues = true;
            }
        }
        if (addBoundingValues || addGeographicDescription) {
            this.hasSpatialSearch = true;
            if (addBoundingValues && addGeographicDescription) {
                qgSpatial.addQueryGroup(qgBounding);
                qgSpatial.addQueryGroup(qgGeographicDescription);
                this.queryGroup.addQueryGroup(qgSpatial);
            } else if (addBoundingValues) {
                this.queryGroup.addQueryGroup(qgBounding);
            } else {
                this.queryGroup.addQueryGroup(qgGeographicDescription);
            }
        }
    }

    private void buildQueryTemporalCriteria() {
        AdvancedSearchQueryTerm qt;
        String emlField;
        String searchMode;
        boolean addQueryGroup = false;
        boolean addQueryGroupDates = false;
        boolean addQueryGroupNamed = false;
        String dateField = this.advancedSearchBean.getDateField();
        String operator = "INTERSECT";
        String indent = this.getIndent(this.indentLevel * 2);
        int namedTimescaleQueryType = this.advancedSearchBean.getNamedTimescaleQueryType();
        AdvancedSearchQueryGroup qg = new AdvancedSearchQueryGroup("INTERSECT", indent);
        indent = this.getIndent(this.indentLevel * 3);
        String namedTimescale = this.advancedSearchBean.getNamedTimescale();
        String startDate = this.advancedSearchBean.getStartDate();
        String endDate = this.advancedSearchBean.getEndDate();
        AdvancedSearchQueryGroup qgNamed = new AdvancedSearchQueryGroup("UNION", indent);
        if (namedTimescale != null && !namedTimescale.equals("")) {
            indent = this.getIndent(this.indentLevel * 4);
            searchMode = this.metacatSearchMode(namedTimescaleQueryType);
            emlField = "temporalCoverage/singleDateTime/alternativeTimeScale/timeScaleName";
            qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, namedTimescale, indent);
            qgNamed.addQueryTerm(qt);
            emlField = "temporalCoverage/rangeOfDates/beginDate/alternativeTimeScale/timeScaleName";
            qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, namedTimescale, indent);
            qgNamed.addQueryTerm(qt);
            emlField = "temporalCoverage/rangeOfDates/endDate/alternativeTimeScale/timeScaleName";
            qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, namedTimescale, indent);
            qgNamed.addQueryTerm(qt);
            addQueryGroupNamed = true;
        }
        AdvancedSearchQueryGroup qgDates = new AdvancedSearchQueryGroup("INTERSECT", indent);
        if (startDate != null && !startDate.equals("")) {
            indent = this.getIndent(this.indentLevel * 4);
            AdvancedSearchQueryGroup qgDatesStart = new AdvancedSearchQueryGroup("UNION", indent);
            indent = this.getIndent(this.indentLevel * 5);
            searchMode = "greater-than-equals";
            if (dateField.equals("ALL") || dateField.equals("COLLECTION")) {
                emlField = "temporalCoverage/rangeOfDates/beginDate/calendarDate";
                qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, startDate, indent);
                qgDatesStart.addQueryTerm(qt);
                emlField = "temporalCoverage/singleDateTime/calendarDate";
                qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, startDate, indent);
                qgDatesStart.addQueryTerm(qt);
            }
            if (dateField.equals("ALL") || dateField.equals("PUBLICATION")) {
                emlField = "dataset/pubDate";
                qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, startDate, indent);
                qgDatesStart.addQueryTerm(qt);
            }
            qgDates.addQueryGroup(qgDatesStart);
            addQueryGroupDates = true;
        }
        if (endDate != null && !endDate.equals("")) {
            indent = this.getIndent(this.indentLevel * 4);
            AdvancedSearchQueryGroup qgDatesEnd = new AdvancedSearchQueryGroup("UNION", indent);
            indent = this.getIndent(this.indentLevel * 5);
            searchMode = "less-than-equals";
            if (dateField.equals("ALL") || dateField.equals("COLLECTION")) {
                emlField = "temporalCoverage/rangeOfDates/endDate/calendarDate";
                qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, endDate, indent);
                qgDatesEnd.addQueryTerm(qt);
                emlField = "temporalCoverage/singleDateTime/calendarDate";
                qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, endDate, indent);
                qgDatesEnd.addQueryTerm(qt);
            }
            if (dateField.equals("ALL") || dateField.equals("PUBLICATION")) {
                emlField = "dataset/pubDate";
                qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, endDate, indent);
                qgDatesEnd.addQueryTerm(qt);
            }
            qgDates.addQueryGroup(qgDatesEnd);
            addQueryGroupDates = true;
        }
        if (addQueryGroupNamed) {
            qg.addQueryGroup(qgNamed);
            addQueryGroup = true;
        }
        if (addQueryGroupDates) {
            qg.addQueryGroup(qgDates);
            addQueryGroup = true;
        }
        if (addQueryGroup) {
            this.hasTemporalSearch = true;
            this.queryGroup.addQueryGroup(qg);
        }
    }

    private void buildQueryTaxon() {
        boolean addQueryGroup = false;
        String indent = this.getIndent(this.indentLevel * 2);
        String operator = "INTERSECT";
        AdvancedSearchQueryGroup qg = new AdvancedSearchQueryGroup("INTERSECT", indent);
        int taxonQueryType = this.advancedSearchBean.getTaxonQueryType();
        String value = this.advancedSearchBean.getTaxon();
        indent = this.getIndent(this.indentLevel * 3);
        if (value != null && !value.equals("")) {
            String emlField = "taxonomicClassification/taxonRankValue";
            String searchMode = this.metacatSearchMode(taxonQueryType);
            AdvancedSearchQueryTerm qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, value, indent);
            qg.addQueryTerm(qt);
            addQueryGroup = true;
        }
        if (addQueryGroup) {
            this.hasTaxonomicSearch = true;
            this.queryGroup.addQueryGroup(qg);
        }
    }

    private void buildSiteFilter() {
        String attributeValue = "";
        String emlField = "";
        String indent = this.getIndent(this.indentLevel * 2);
        LTERSite lterSite = new LTERSite(this.site);
        String operator = "UNION";
        AdvancedSearchQueryGroup qg = new AdvancedSearchQueryGroup("UNION", indent);
        if (lterSite.isValidSite()) {
            this.hasSiteFilter = true;
            indent = this.getIndent(this.indentLevel * 3);
            if (this.site.equals("CAP") || this.site.equals("CWT")) {
                emlField = "/eml/@system";
                attributeValue = lterSite.getSystem();
            } else {
                emlField = "/eml/@packageId";
                attributeValue = lterSite.getPackageId();
            }
            String searchMode = "starts-with";
            AdvancedSearchQueryTerm qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, attributeValue, indent);
            qg.addQueryTerm(qt);
            String siteKeyword = lterSite.getSiteKeyword();
            emlField = "";
            searchMode = "contains";
            qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, siteKeyword, indent);
            qg.addQueryTerm(qt);
            this.queryGroup.addQueryGroup(qg);
        }
    }

    private int countSearchTypes() {
        int searchTypes = 0;
        if (this.hasSubjectSearch) {
            ++searchTypes;
        }
        if (this.hasAuthorSearch) {
            ++searchTypes;
        }
        if (this.hasSpatialSearch) {
            ++searchTypes;
        }
        if (this.hasTaxonomicSearch) {
            ++searchTypes;
        }
        if (this.hasTemporalSearch) {
            ++searchTypes;
        }
        if (this.hasSiteFilter) {
            ++searchTypes;
        }
        return searchTypes;
    }

    public String executeAdvancedSearch(String metacatURL, Metacat metacat, String qformat, String xslPath) {
        String htmlString = "";
        this.buildQuerySubject();
        this.buildQueryAuthor();
        this.buildQueryTaxon();
        this.buildQuerySpatialCriteria();
        this.buildQueryTemporalCriteria();
        this.buildSiteFilter();
        int searchTypes = this.countSearchTypes();
        if (searchTypes == 1) {
            this.queryGroup.setIncludeOuterQueryGroup(false);
        }
        this.queryString = this.pathQuery.toString();
        htmlString = this.runQuery(metacatURL, metacat, qformat, xslPath);
        return htmlString;
    }

    public String executeSearch(String metacatURL, Metacat metacat, String qformat, String xslPath, String value) {
        String emlField = "";
        String htmlString = "";
        String indent = this.getIndent(this.indentLevel * 2);
        String searchMode = "contains";
        indent = this.getIndent(this.indentLevel * 3);
        if (value == null || value.equals("")) {
            value = "%";
        }
        AdvancedSearchQueryTerm qt = new AdvancedSearchQueryTerm(searchMode, this.caseSensitive, emlField, value, indent);
        this.queryGroup.addQueryTerm(qt);
        this.queryString = this.pathQuery.toString();
        htmlString = this.runQuery(metacatURL, metacat, qformat, xslPath);
        return htmlString;
    }

    private String getIndent(int indentLevel) {
        StringBuffer indent = new StringBuffer(12);
        for (int i = 0; i < indentLevel; ++i) {
            indent.append(" ");
        }
        return indent.toString();
    }

    private String metacatSearchMode(int queryType) {
        String searchMode;
        switch (queryType) {
            case 0: {
                searchMode = "contains";
                break;
            }
            case 1: {
                searchMode = "equals";
                break;
            }
            case 2: {
                searchMode = "starts-with";
                break;
            }
            case 3: {
                searchMode = "ends-with";
                break;
            }
            default: {
                searchMode = "contains";
            }
        }
        return searchMode;
    }

    private ArrayList parseTermsAdvanced(String value) {
        StringBuffer currentTerm = new StringBuffer(100);
        boolean keepSpaces = false;
        ArrayList terms = new ArrayList();
        value = value.trim();
        int stringLength = value.length();
        for (int i = 0; i < stringLength; ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                if (keepSpaces) {
                    this.addTerm(terms, currentTerm);
                    currentTerm = new StringBuffer(100);
                }
                keepSpaces = !keepSpaces;
                continue;
            }
            if (c == ' ') {
                if (keepSpaces) {
                    currentTerm.append(c);
                    continue;
                }
                this.addTerm(terms, currentTerm);
                currentTerm = new StringBuffer(100);
                continue;
            }
            currentTerm.append(c);
        }
        this.addTerm(terms, currentTerm);
        return terms;
    }

    private String runQuery(String metacatURL, Metacat metacat, String qformat, String xslPath) {
        String htmlString = "";
        String resultset = "";
        Stylizer stylizer = new Stylizer();
        if (metacat == null) {
            try {
                metacat = MetacatFactory.createMetacatConnection(metacatURL);
            }
            catch (MetacatInaccessibleException mie) {
                System.err.println("Metacat Inaccessible:\n" + mie.getMessage());
            }
        }
        String sessionId = metacat.getSessionId();
        try {
            System.err.println("Starting query...");
            StringReader stringReader = new StringReader(this.queryString);
            Reader reader = metacat.query(stringReader);
            resultset = IOUtil.getAsString((Reader)reader, (boolean)true);
            System.err.println("Query result:\n" + resultset);
            htmlString = stylizer.resultsetToHTML(resultset, sessionId, metacatURL, qformat, xslPath);
        }
        catch (Exception e) {
            System.err.println("General exception:\n" + e.getMessage());
            e.printStackTrace();
        }
        return htmlString;
    }

    public static void main(String[] argv) {
        AdvancedSearchBean advancedSearchBean = new AdvancedSearchBean();
        String contextString = argv[2];
        MetacatHelper metacatHelper = new MetacatHelper();
        String qformat = "lter";
        String serverName = argv[0];
        Integer serverPortInteger = new Integer(argv[1]);
        int serverPort = serverPortInteger;
        String xslPath = argv[3];
        advancedSearchBean.setSubjectField("ALL");
        advancedSearchBean.setSubjectValue("bird");
        AdvancedSearch advancedSearch = new AdvancedSearch(advancedSearchBean);
        String metacatURL = metacatHelper.constructMetacatURL(serverName, serverPort, contextString);
        advancedSearch.executeAdvancedSearch(metacatURL, null, qformat, xslPath);
    }
}

