/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.dataone;

import edu.ucsb.nceas.metacat.AccessionNumber;
import edu.ucsb.nceas.metacat.AccessionNumberException;
import edu.ucsb.nceas.metacat.DBUtil;
import edu.ucsb.nceas.metacat.DocumentImpl;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.McdbDocNotFoundException;
import edu.ucsb.nceas.metacat.McdbException;
import edu.ucsb.nceas.metacat.MetacatHandler;
import edu.ucsb.nceas.metacat.accesscontrol.AccessControlException;
import edu.ucsb.nceas.metacat.client.InsufficientKarmaException;
import edu.ucsb.nceas.metacat.dataone.MNodeService;
import edu.ucsb.nceas.metacat.dataone.hazelcast.HazelcastService;
import edu.ucsb.nceas.metacat.index.MetacatSolrIndex;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.replication.ReplicationService;
import edu.ucsb.nceas.metacat.shared.AccessException;
import edu.ucsb.nceas.metacat.shared.HandlerException;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.utilities.ParseLSIDException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.eml.DataoneEMLParser;
import org.dataone.eml.EMLDocument;
import org.dataone.exceptions.MarshallingException;
import org.dataone.ore.ResourceMapFactory;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ReplicationPolicy;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.DateTimeMarshaller;
import org.dspace.foresite.ResourceMap;
import org.xml.sax.SAXException;

public class SystemMetadataFactory {
    public static final String RESOURCE_MAP_PREFIX = "resourceMap_";
    private static Logger logMetacat = Logger.getLogger(SystemMetadataFactory.class);
    private static boolean updateExisting = true;

    public static SystemMetadata createSystemMetadata(String localId, boolean includeORE, boolean downloadData) throws McdbException, McdbDocNotFoundException, SQLException, IOException, AccessionNumberException, ClassNotFoundException, InsufficientKarmaException, ParseLSIDException, PropertyNotFoundException, BaseException, NoSuchAlgorithmException, MarshallingException, AccessControlException, HandlerException, SAXException, AccessException {
        boolean indexDataFile = false;
        return SystemMetadataFactory.createSystemMetadata(indexDataFile, localId, includeORE, downloadData);
    }

    public static SystemMetadata createSystemMetadata(boolean indexDataFile, String localId, boolean includeORE, boolean downloadData) throws McdbException, McdbDocNotFoundException, SQLException, IOException, AccessionNumberException, ClassNotFoundException, InsufficientKarmaException, ParseLSIDException, PropertyNotFoundException, BaseException, NoSuchAlgorithmException, MarshallingException, AccessControlException, HandlerException, SAXException, AccessException {
        logMetacat.debug((Object)("createSystemMetadata() called for localId " + localId));
        SystemMetadata sysMeta = null;
        AccessionNumber accNum = new AccessionNumber(localId, "NONE");
        int rev = Integer.valueOf(accNum.getRev());
        String guid = null;
        try {
            guid = IdentifierManager.getInstance().getGUID(accNum.getDocid(), rev);
        }
        catch (McdbDocNotFoundException dnfe) {
            logMetacat.debug((Object)("No guid found in the identifier table.  Creating mapping for " + localId));
            IdentifierManager.getInstance().createMapping(localId, localId);
            guid = IdentifierManager.getInstance().getGUID(accNum.getDocid(), rev);
        }
        Identifier identifier = new Identifier();
        identifier.setValue(guid);
        try {
            logMetacat.debug((Object)"Using hazelcast to get system metadata");
            sysMeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)identifier);
            if (!updateExisting) {
                return sysMeta;
            }
        }
        catch (Exception e) {
            logMetacat.debug((Object)("No system metadata found in hz: " + e.getMessage()));
        }
        if (sysMeta == null) {
            sysMeta = new SystemMetadata();
            sysMeta.setIdentifier(identifier);
            sysMeta.setSerialVersion(BigInteger.valueOf(1L));
            sysMeta.setArchived(Boolean.valueOf(false));
        }
        Hashtable<String, String> docInfo = ReplicationService.getDocumentInfoMap(localId);
        String doctype = docInfo.get("doctype");
        ObjectFormatIdentifier fmtid = null;
        if (doctype.trim().equals("BIN")) {
            fmtid = ObjectFormatCache.getInstance().getFormat("application/octet-stream").getFormatId();
        } else if (doctype.trim().equals("metadata")) {
            fmtid = ObjectFormatCache.getInstance().getFormat("FGDC-STD-001-1998").getFormatId();
        } else {
            try {
                fmtid = ObjectFormatCache.getInstance().getFormat(doctype).getFormatId();
            }
            catch (NotFound nfe) {
                fmtid = ObjectFormatCache.getInstance().getFormat("text/plain").getFormatId();
            }
        }
        sysMeta.setFormatId(fmtid);
        logMetacat.debug((Object)("The ObjectFormat for " + localId + " is " + fmtid.getValue()));
        InputStream inputStream = null;
        inputStream = MetacatHandler.read(localId);
        String algorithm = PropertyService.getProperty("dataone.checksumAlgorithm.default");
        Checksum checksum = ChecksumUtil.checksum((InputStream)inputStream, (String)algorithm);
        logMetacat.debug((Object)("The checksum for " + localId + " is " + checksum.getValue()));
        sysMeta.setChecksum(checksum);
        File fileOnDisk = SystemMetadataFactory.getFileOnDisk(localId);
        long fileSize = 0L;
        if (fileOnDisk.exists()) {
            fileSize = fileOnDisk.length();
        }
        sysMeta.setSize(BigInteger.valueOf(fileSize));
        Subject submitter = new Subject();
        submitter.setValue(docInfo.get("user_updated"));
        sysMeta.setSubmitter(submitter);
        Subject owner = new Subject();
        owner.setValue(docInfo.get("user_owner"));
        sysMeta.setRightsHolder(owner);
        String createdDateString = docInfo.get("date_created");
        String updatedDateString = docInfo.get("date_updated");
        Date createdDate = DateTimeMarshaller.deserializeDateToUTC((String)createdDateString);
        Date updatedDate = DateTimeMarshaller.deserializeDateToUTC((String)updatedDateString);
        sysMeta.setDateUploaded(createdDate);
        sysMeta.setDateSysMetadataModified(Calendar.getInstance().getTime());
        String docidWithoutRev = accNum.getDocid();
        Identifier obsoletedBy = null;
        Identifier obsoletes = null;
        Vector<Integer> revisions = DBUtil.getRevListFromRevisionTable(docidWithoutRev);
        Collections.sort(revisions);
        for (int existingRev : revisions) {
            String existingPid = docidWithoutRev + "." + existingRev;
            try {
                existingPid = IdentifierManager.getInstance().getGUID(docidWithoutRev, existingRev);
            }
            catch (McdbDocNotFoundException mdfe) {
                logMetacat.warn((Object)("could not locate guid when processing revision history for localId: " + localId));
            }
            if (existingRev < rev) {
                obsoletes = new Identifier();
                obsoletes.setValue(existingPid);
            }
            if (existingRev <= rev) continue;
            obsoletedBy = new Identifier();
            obsoletedBy.setValue(existingPid);
            break;
        }
        sysMeta.setObsoletedBy(obsoletedBy);
        sysMeta.setObsoletes(obsoletes);
        if (obsoletedBy != null) {
            SystemMetadata obsoletedBySysMeta = null;
            try {
                obsoletedBySysMeta = IdentifierManager.getInstance().getSystemMetadata(obsoletedBy.getValue());
            }
            catch (McdbDocNotFoundException existingRev) {
                // empty catch block
            }
            if (obsoletedBySysMeta != null) {
                obsoletedBySysMeta.setObsoletes(identifier);
                obsoletedBySysMeta.setDateSysMetadataModified(Calendar.getInstance().getTime());
                HazelcastService.getInstance().getSystemMetadataMap().put(obsoletedBy, (Object)obsoletedBySysMeta);
            }
        }
        if (obsoletes != null) {
            SystemMetadata obsoletesSysMeta = null;
            try {
                obsoletesSysMeta = IdentifierManager.getInstance().getSystemMetadata(obsoletes.getValue());
            }
            catch (McdbDocNotFoundException existingRev) {
                // empty catch block
            }
            if (obsoletesSysMeta != null) {
                obsoletesSysMeta.setObsoletedBy(identifier);
                obsoletesSysMeta.setDateSysMetadataModified(Calendar.getInstance().getTime());
                HazelcastService.getInstance().getSystemMetadataMap().put(obsoletes, (Object)obsoletesSysMeta);
            }
        }
        AccessPolicy accessPolicy = IdentifierManager.getInstance().getAccessPolicy(guid);
        try {
            List allowList = accessPolicy.getAllowList();
            int listSize = allowList.size();
            sysMeta.setAccessPolicy(accessPolicy);
        }
        catch (NullPointerException npe) {
            logMetacat.info((Object)("The allow list is empty, can't include an empty access policy in the system metadata for " + guid));
        }
        NodeReference nr = new NodeReference();
        nr.setValue(PropertyService.getProperty("dataone.nodeId"));
        sysMeta.setOriginMemberNode(nr);
        sysMeta.setAuthoritativeMemberNode(nr);
        ReplicationPolicy rp = SystemMetadataFactory.getDefaultReplicationPolicy();
        if (rp != null) {
            sysMeta.setReplicationPolicy(rp);
        }
        if (fmtid == ObjectFormatCache.getInstance().getFormat("eml://ecoinformatics.org/eml-2.0.0").getFormatId() || fmtid == ObjectFormatCache.getInstance().getFormat("eml://ecoinformatics.org/eml-2.0.1").getFormatId() || fmtid == ObjectFormatCache.getInstance().getFormat("eml://ecoinformatics.org/eml-2.1.0").getFormatId() || fmtid == ObjectFormatCache.getInstance().getFormat("eml://ecoinformatics.org/eml-2.1.1").getFormatId()) {
            try {
                logMetacat.debug((Object)"Re-reading document inputStream");
                inputStream = MetacatHandler.read(localId);
                DataoneEMLParser emlParser = DataoneEMLParser.getInstance();
                EMLDocument emlDocument = emlParser.parseDocument(inputStream);
                logMetacat.debug((Object)("In createSystemMetadata() the number of data entities is: " + emlDocument.distributionMetadata));
                HashMap idMap = new HashMap();
                ArrayList<Identifier> dataIds = new ArrayList<Identifier>();
                if (emlDocument.distributionMetadata != null) {
                    for (int j = 0; j < emlDocument.distributionMetadata.size(); ++j) {
                        EMLDocument.DistributionMetadata distMetadata = (EMLDocument.DistributionMetadata)emlDocument.distributionMetadata.elementAt(j);
                        String dataDocUrl = distMetadata.url;
                        String dataDocMimeType = distMetadata.mimeType;
                        if (dataDocMimeType == null) {
                            dataDocMimeType = "application/octet-stream";
                        }
                        boolean remoteData = false;
                        String dataDocLocalId = null;
                        Identifier dataGuid = new Identifier();
                        String ecogridPrefix = "ecogrid://knb/";
                        if (dataDocUrl.trim().startsWith(ecogridPrefix)) {
                            dataDocLocalId = dataDocUrl.substring(dataDocUrl.indexOf(ecogridPrefix) + ecogridPrefix.length());
                        } else if (downloadData) {
                            InputStream dataObject = null;
                            try {
                                URL dataURL = new URL(dataDocUrl);
                                URLConnection dataConnection = dataURL.openConnection();
                                dataObject = dataConnection.getInputStream();
                                String detectedContentType = dataConnection.getContentType();
                                logMetacat.info((Object)("Detected content type: " + detectedContentType));
                                if (detectedContentType != null) {
                                    if (detectedContentType.contains("html") && !dataDocMimeType.contains("html")) {
                                        dataObject = null;
                                        logMetacat.warn((Object)("Skipping remote resource, unexpected HTML content type at: " + dataDocUrl));
                                    }
                                } else {
                                    dataObject = null;
                                    logMetacat.warn((Object)("Skipping remote resource, unknown content type at: " + dataDocUrl));
                                }
                            }
                            catch (Exception e) {
                                logMetacat.warn((Object)("Error downloading remote data. " + e.getMessage()));
                            }
                            if (dataObject != null) {
                                dataDocLocalId = DocumentUtil.generateDocumentId(1);
                                IdentifierManager.getInstance().createMapping(dataDocLocalId, dataDocLocalId);
                                dataGuid.setValue(dataDocLocalId);
                                Session session = new Session();
                                session.setSubject(submitter);
                                MockHttpServletRequest request = new MockHttpServletRequest(null, null, null);
                                MNodeService.getInstance((HttpServletRequest)request).insertDataObject(dataObject, dataGuid, session);
                                remoteData = true;
                            }
                        }
                        logMetacat.debug((Object)("Data local ID: " + dataDocLocalId));
                        logMetacat.debug((Object)("Data URL     : " + dataDocUrl));
                        logMetacat.debug((Object)("Data mime    : " + dataDocMimeType));
                        String dataDocid = null;
                        int dataRev = 0;
                        if (dataDocLocalId != null) {
                            try {
                                dataDocid = DocumentUtil.getSmartDocId(dataDocLocalId);
                                dataRev = DocumentUtil.getRevisionFromAccessionNumber(dataDocLocalId);
                            }
                            catch (Exception e) {
                                logMetacat.warn((Object)(e.getClass().getName() + " - Problem parsing accession number for: " + dataDocLocalId + ". Message: " + e.getMessage()));
                                dataDocLocalId = null;
                            }
                        }
                        if (dataDocLocalId == null) continue;
                        SystemMetadata dataSysMeta = null;
                        String dataGuidString = null;
                        try {
                            dataGuidString = IdentifierManager.getInstance().getGUID(dataDocid, dataRev);
                            dataGuid.setValue(dataGuidString);
                            try {
                                dataSysMeta = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)dataGuid);
                            }
                            catch (Exception e) {
                                dataSysMeta = null;
                            }
                        }
                        catch (McdbDocNotFoundException nf) {
                            dataSysMeta = null;
                        }
                        if (dataSysMeta == null) {
                            logMetacat.debug((Object)("No exisiting SystemMetdata found, creating for: " + dataDocLocalId));
                            dataSysMeta = SystemMetadataFactory.createSystemMetadata(dataDocLocalId, includeORE, false);
                            dataGuidString = IdentifierManager.getInstance().getGUID(dataDocid, dataRev);
                            dataGuid.setValue(dataGuidString);
                            if (remoteData) {
                                dataSysMeta.setAccessPolicy(sysMeta.getAccessPolicy());
                            }
                        }
                        logMetacat.debug((Object)("Updating system metadata for " + dataGuid.getValue() + " to " + dataDocMimeType));
                        ObjectFormatIdentifier fmt = null;
                        try {
                            fmt = ObjectFormatCache.getInstance().getFormat(dataDocMimeType).getFormatId();
                        }
                        catch (NotFound nfe) {
                            logMetacat.debug((Object)("Couldn't find format identifier for: " + dataDocMimeType + ". Setting it to application/octet-stream."));
                            fmt = new ObjectFormatIdentifier();
                            fmt.setValue("application/octet-stream");
                        }
                        dataSysMeta.setFormatId(fmt);
                        HazelcastService.getInstance().getSystemMetadataMap().put((Object)dataSysMeta.getIdentifier(), (Object)dataSysMeta);
                        logMetacat.debug((Object)("do we need to reindex guid " + dataGuid.getValue() + "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~?" + indexDataFile));
                        if (indexDataFile) {
                            SystemMetadataFactory.reindexDataFile(dataSysMeta.getIdentifier(), dataSysMeta);
                        }
                        dataIds.add(dataGuid);
                    }
                }
                if (includeORE && !dataIds.isEmpty() && !SystemMetadataFactory.oreExistsFor(sysMeta.getIdentifier())) {
                    Identifier resourceMapId = new Identifier();
                    resourceMapId.setValue(RESOURCE_MAP_PREFIX + localId);
                    idMap.put(sysMeta.getIdentifier(), dataIds);
                    ResourceMap rm = ResourceMapFactory.getInstance().createResourceMap(resourceMapId, idMap);
                    String resourceMapXML = ResourceMapFactory.getInstance().serializeResourceMap(rm);
                    SystemMetadata resourceMapSysMeta = new SystemMetadata();
                    BeanUtils.copyProperties((Object)resourceMapSysMeta, (Object)sysMeta);
                    resourceMapSysMeta.setIdentifier(resourceMapId);
                    Checksum oreChecksum = ChecksumUtil.checksum((InputStream)IOUtils.toInputStream((String)resourceMapXML, (String)"UTF-8"), (String)algorithm);
                    resourceMapSysMeta.setChecksum(oreChecksum);
                    ObjectFormatIdentifier formatId = ObjectFormatCache.getInstance().getFormat("http://www.openarchives.org/ore/terms").getFormatId();
                    resourceMapSysMeta.setFormatId(formatId);
                    resourceMapSysMeta.setSize(BigInteger.valueOf(SystemMetadataFactory.sizeOfStream(IOUtils.toInputStream((String)resourceMapXML, (String)"UTF-8"))));
                    resourceMapSysMeta.setObsoletes(null);
                    resourceMapSysMeta.setObsoletedBy(null);
                    if (sysMeta.getObsoletes() != null) {
                        String obsoletesLocalId = IdentifierManager.getInstance().getLocalId(sysMeta.getObsoletes().getValue());
                        Identifier resourceMapObsoletes = new Identifier();
                        resourceMapObsoletes.setValue(RESOURCE_MAP_PREFIX + obsoletesLocalId);
                        resourceMapSysMeta.setObsoletes(resourceMapObsoletes);
                        SystemMetadata resourceMapObsoletesSystemMetadata = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)resourceMapObsoletes);
                        if (resourceMapObsoletesSystemMetadata != null) {
                            resourceMapObsoletesSystemMetadata.setObsoletedBy(resourceMapId);
                            resourceMapObsoletesSystemMetadata.setArchived(Boolean.valueOf(true));
                            HazelcastService.getInstance().getSystemMetadataMap().put((Object)resourceMapObsoletes, (Object)resourceMapObsoletesSystemMetadata);
                        }
                    }
                    if (sysMeta.getObsoletedBy() != null) {
                        String obsoletedByLocalId = IdentifierManager.getInstance().getLocalId(sysMeta.getObsoletedBy().getValue());
                        Identifier resourceMapObsoletedBy = new Identifier();
                        resourceMapObsoletedBy.setValue(RESOURCE_MAP_PREFIX + obsoletedByLocalId);
                        resourceMapSysMeta.setObsoletedBy(resourceMapObsoletedBy);
                        resourceMapSysMeta.setArchived(Boolean.valueOf(true));
                        SystemMetadata resourceMapObsoletedBySystemMetadata = (SystemMetadata)HazelcastService.getInstance().getSystemMetadataMap().get((Object)resourceMapObsoletedBy);
                        if (resourceMapObsoletedBySystemMetadata != null) {
                            resourceMapObsoletedBySystemMetadata.setObsoletes(resourceMapId);
                            HazelcastService.getInstance().getSystemMetadataMap().put((Object)resourceMapObsoletedBy, (Object)resourceMapObsoletedBySystemMetadata);
                        }
                    }
                    if (!IdentifierManager.getInstance().identifierExists(resourceMapId.getValue())) {
                        Session session = new Session();
                        session.setSubject(submitter);
                        MockHttpServletRequest request = new MockHttpServletRequest(null, null, null);
                        MNodeService.getInstance((HttpServletRequest)request).insertDataObject(IOUtils.toInputStream((String)resourceMapXML, (String)"UTF-8"), resourceMapId, session);
                        MNodeService.getInstance((HttpServletRequest)request).insertSystemMetadata(resourceMapSysMeta);
                        logMetacat.info((Object)("Inserted ORE package: " + resourceMapId.getValue()));
                    }
                }
            }
            catch (ParserConfigurationException pce) {
                logMetacat.debug((Object)("There was a problem parsing the EML document. The error message was: " + pce.getMessage()));
            }
            catch (SAXException saxe) {
                logMetacat.debug((Object)("There was a problem traversing the EML document. The error message was: " + saxe.getMessage()));
            }
            catch (XPathExpressionException xpee) {
                logMetacat.debug((Object)("There was a problem searching the EML document. The error message was: " + xpee.getMessage()));
            }
            catch (Exception e) {
                logMetacat.debug((Object)("There was a problem creating System Metadata. The error message was: " + e.getMessage()));
                e.printStackTrace();
            }
        }
        return sysMeta;
    }

    private static void reindexDataFile(Identifier id, SystemMetadata sysmeta) {
        try {
            logMetacat.debug((Object)("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ reindex" + id.getValue()));
            if (sysmeta != null) {
                if (!sysmeta.getArchived().booleanValue()) {
                    sysmeta.setArchived(Boolean.valueOf(true));
                    MetacatSolrIndex.getInstance().submit(id, sysmeta, null, true);
                    sysmeta.setArchived(Boolean.valueOf(false));
                    MetacatSolrIndex.getInstance().submit(id, sysmeta, null, true);
                } else {
                    MetacatSolrIndex.getInstance().submit(id, sysmeta, null, true);
                }
            }
        }
        catch (Exception e) {
            logMetacat.warn((Object)("Can't reindex the data object " + id.getValue() + " since " + e.getMessage()));
        }
    }

    public static boolean oreExistsFor(Identifier identifier) {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null, null);
        List<Identifier> ids = MNodeService.getInstance((HttpServletRequest)request).lookupOreFor(identifier, true);
        return ids != null && ids.size() > 0;
    }

    public static void generateSystemMetadata(List<String> idList, boolean includeOre, boolean downloadData) throws PropertyNotFoundException, NoSuchAlgorithmException, AccessionNumberException, SQLException, AccessControlException, AccessException, McdbException, IOException, ClassNotFoundException, InsufficientKarmaException, ParseLSIDException, BaseException, MarshallingException, HandlerException, SAXException {
        for (String localId : idList) {
            logMetacat.debug((Object)("Creating SystemMetadata for localId " + localId));
            logMetacat.trace((Object)("METRICS:\tGENERATE_SYSTEM_METADATA:\tBEGIN:\tLOCALID:\t" + localId));
            SystemMetadata sm = null;
            try {
                sm = SystemMetadataFactory.createSystemMetadata(localId, includeOre, downloadData);
            }
            catch (Exception e) {
                logMetacat.error((Object)("Could not create/process system metadata for docid: " + localId), (Throwable)e);
                continue;
            }
            IdentifierManager.getInstance().insertOrUpdateSystemMetadata(sm);
            logMetacat.info((Object)("Generated or Updated SystemMetadata for " + localId));
            logMetacat.trace((Object)("METRICS:\tGENERATE_SYSTEM_METADATA:\tEND:\tLOCALID:\t" + localId));
        }
        logMetacat.info((Object)"done generating system metadata for given list");
    }

    public static long sizeOfStream(InputStream is) throws IOException {
        long size = 0L;
        byte[] b = new byte[1024];
        int numread = is.read(b, 0, 1024);
        while (numread != -1) {
            size += (long)numread;
            numread = is.read(b, 0, 1024);
        }
        return size;
    }

    private static File getFileOnDisk(String docid) throws McdbException, PropertyNotFoundException {
        DocumentImpl doc = new DocumentImpl(docid, false);
        String filepath = null;
        String filename = null;
        filepath = doc.getRootNodeID() == 0L ? PropertyService.getProperty("application.datafilepath") : PropertyService.getProperty("application.documentfilepath");
        if (!filepath.endsWith("/")) {
            filepath = filepath + "/";
        }
        filename = filepath + docid;
        File documentFile = new File(filename);
        return documentFile;
    }

    private static ReplicationPolicy getDefaultReplicationPolicy() {
        ReplicationPolicy rp = null;
        int numReplicas = -1;
        try {
            numReplicas = new Integer(PropertyService.getProperty("dataone.replicationpolicy.default.numreplicas"));
        }
        catch (NumberFormatException e) {
            return null;
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
        if (numReplicas > 0) {
            rp = new ReplicationPolicy();
            rp.setReplicationAllowed(Boolean.valueOf(true));
            rp.setNumberReplicas(Integer.valueOf(numReplicas));
            try {
                List<NodeReference> pNodes;
                String preferredNodeList = PropertyService.getProperty("dataone.replicationpolicy.default.preferredNodeList");
                if (preferredNodeList != null && (pNodes = SystemMetadataFactory.extractNodeReferences(preferredNodeList)) != null && !pNodes.isEmpty()) {
                    rp.setPreferredMemberNodeList(pNodes);
                }
            }
            catch (PropertyNotFoundException preferredNodeList) {
                // empty catch block
            }
            try {
                List<NodeReference> bNodes;
                String blockedNodeList = PropertyService.getProperty("dataone.replicationpolicy.default.blockedNodeList");
                if (blockedNodeList != null && (bNodes = SystemMetadataFactory.extractNodeReferences(blockedNodeList)) != null && !bNodes.isEmpty()) {
                    rp.setBlockedMemberNodeList(bNodes);
                }
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
        }
        return rp;
    }

    private static List<NodeReference> extractNodeReferences(String nodeString) {
        String[] result;
        ArrayList<NodeReference> nodeList = new ArrayList<NodeReference>();
        for (String r : result = nodeString.split("[,;\\s]")) {
            if (r == null || r.length() <= 0) continue;
            NodeReference noderef = new NodeReference();
            noderef.setValue(r);
            nodeList.add(noderef);
        }
        return nodeList;
    }
}

