/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.restservice.v2;

import edu.ucsb.nceas.metacat.common.query.stream.ContentTypeInputStream;
import edu.ucsb.nceas.metacat.dataone.CNodeService;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.restservice.D1ResourceHandler;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dataone.client.v2.formats.ObjectFormatInfo;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.exceptions.VersionMismatch;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.ChecksumAlgorithmList;
import org.dataone.service.types.v1.DescribeResponse;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.ObjectLocationList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationPolicy;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.Log;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.ObjectFormatList;
import org.dataone.service.types.v2.OptionList;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.util.DateTimeMarshaller;
import org.dataone.service.util.EncodingUtilities;
import org.dataone.service.util.ExceptionHandler;
import org.dataone.service.util.TypeMarshaller;
import org.xml.sax.SAXException;

public class CNResourceHandler
extends D1ResourceHandler {
    protected static final String RESOURCE_RESERVE = "reserve";
    protected static final String RESOURCE_FORMATS = "formats";
    protected static final String RESOURCE_RESOLVE = "resolve";
    protected static final String RESOURCE_OWNER = "owner";
    protected static final String RESOURCE_REPLICATION_POLICY = "replicaPolicies";
    protected static final String RESOURCE_REPLICATION_META = "replicaMetadata";
    protected static final String RESOURCE_REPLICATION_AUTHORIZED = "replicaAuthorizations";
    protected static final String RESOURCE_REPLICATION_NOTIFY = "replicaNotifications";

    public CNResourceHandler(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        super(servletContext, request, response);
        this.logMetacat = Logger.getLogger(CNResourceHandler.class);
    }

    @Override
    public void handle(byte httpVerb) {
        block81: {
            super.handle(httpVerb);
            try {
                if (!this.isD1Enabled()) {
                    ServiceFailure se = new ServiceFailure("0000", "DataONE services are not enabled on this node");
                    this.serializeException((BaseException)((Object)se), (OutputStream)this.response.getOutputStream());
                    return;
                }
                String resource = this.request.getPathInfo();
                resource = resource.substring(resource.indexOf("/") + 1);
                String extra = null;
                this.logMetacat.debug((Object)("handling verb " + httpVerb + " request with resource '" + resource + "'"));
                boolean status = false;
                if (resource != null) {
                    if (resource.startsWith("accessRules") && httpVerb == 3) {
                        this.logMetacat.debug((Object)"Setting access policy");
                        extra = this.parseTrailing(resource, "accessRules");
                        extra = CNResourceHandler.decode(extra);
                        this.setAccess(extra);
                        status = true;
                        this.logMetacat.debug((Object)"done setting access");
                    } else if (resource.startsWith("meta")) {
                        this.logMetacat.debug((Object)"Using resource: meta");
                        extra = this.parseTrailing(resource, "meta");
                        extra = CNResourceHandler.decode(extra);
                        if (httpVerb == 1) {
                            this.getSystemMetadataObject(extra);
                            status = true;
                        }
                        if (httpVerb == 2) {
                            this.registerSystemMetadata();
                            status = true;
                        } else if (httpVerb == 3) {
                            this.logMetacat.debug((Object)"Using resource 'meta' for PUT");
                            this.updateSystemMetadata();
                            status = true;
                        }
                    } else if (resource.startsWith(RESOURCE_RESERVE)) {
                        if (httpVerb == 2) {
                            this.reserve();
                            status = true;
                        }
                    } else if (resource.startsWith(RESOURCE_RESOLVE)) {
                        extra = this.parseTrailing(resource, RESOURCE_RESOLVE);
                        extra = CNResourceHandler.decode(extra);
                        if (httpVerb == 1) {
                            this.resolve(extra);
                            status = true;
                        }
                    } else if (resource.startsWith(RESOURCE_OWNER)) {
                        extra = this.parseTrailing(resource, RESOURCE_OWNER);
                        extra = CNResourceHandler.decode(extra);
                        if (httpVerb == 3) {
                            this.owner(extra);
                            status = true;
                        }
                    } else if (resource.startsWith("isAuthorized")) {
                        extra = this.parseTrailing(resource, "isAuthorized");
                        extra = CNResourceHandler.decode(extra);
                        if (httpVerb == 1) {
                            this.isAuthorized(extra);
                            status = true;
                        }
                    } else if (resource.startsWith("object")) {
                        this.logMetacat.debug((Object)"Using resource 'object'");
                        this.logMetacat.debug((Object)"D1 Rest: Starting resource processing...");
                        extra = this.parseTrailing(resource, "object");
                        extra = CNResourceHandler.decode(extra);
                        this.logMetacat.debug((Object)("objectId: " + extra));
                        this.logMetacat.debug((Object)("verb:" + httpVerb));
                        if (httpVerb == 1) {
                            if (extra != null) {
                                this.getObject(extra);
                            } else {
                                this.listObjects();
                            }
                            status = true;
                        } else if (httpVerb == 2) {
                            this.putObject("insert");
                            status = true;
                        } else if (httpVerb == 5) {
                            this.describeObject(extra);
                            status = true;
                        } else if (httpVerb == 4) {
                            this.deleteObject(extra);
                            status = true;
                        }
                    } else if (resource.startsWith(RESOURCE_FORMATS)) {
                        this.logMetacat.debug((Object)"Using resource: formats");
                        extra = this.parseTrailing(resource, RESOURCE_FORMATS);
                        extra = CNResourceHandler.decode(extra);
                        if (httpVerb == 1) {
                            if (extra == null) {
                                this.listFormats();
                            } else {
                                this.getFormat(extra);
                            }
                            status = true;
                        } else if (httpVerb == 3) {
                            this.addFormat(extra);
                        }
                    } else if (resource.startsWith("log")) {
                        this.logMetacat.debug((Object)"Using resource: log");
                        if (httpVerb == 1) {
                            this.getLog();
                            status = true;
                        }
                    } else if (resource.startsWith("archive")) {
                        this.logMetacat.debug((Object)"Using resource archive");
                        if (httpVerb == 3) {
                            extra = this.parseTrailing(resource, "archive");
                            extra = CNResourceHandler.decode(extra);
                            this.archive(extra);
                            status = true;
                        }
                    } else if (resource.startsWith("checksum")) {
                        this.logMetacat.debug((Object)"Using resource: checksum");
                        extra = this.parseTrailing(resource, "checksum");
                        extra = CNResourceHandler.decode(extra);
                        if (httpVerb == 1) {
                            if (extra != null && extra.length() > 0) {
                                this.checksum(extra);
                                status = true;
                            } else {
                                this.listChecksumAlgorithms();
                                status = true;
                            }
                        }
                    } else if (resource.startsWith(RESOURCE_REPLICATION_POLICY) && httpVerb == 3) {
                        this.logMetacat.debug((Object)"Using resource: replicaPolicies");
                        extra = this.parseTrailing(resource, RESOURCE_REPLICATION_POLICY);
                        extra = CNResourceHandler.decode(extra);
                        this.setReplicationPolicy(extra);
                        status = true;
                    } else if (resource.startsWith(RESOURCE_REPLICATION_META) && httpVerb == 3) {
                        this.logMetacat.debug((Object)"Using resource: replicaMetadata");
                        extra = this.parseTrailing(resource, RESOURCE_REPLICATION_META);
                        extra = CNResourceHandler.decode(extra);
                        this.updateReplicationMetadata(extra);
                        status = true;
                    } else if (resource.startsWith(RESOURCE_REPLICATION_NOTIFY) && httpVerb == 3) {
                        this.logMetacat.debug((Object)"Using resource: replicaNotifications");
                        extra = this.parseTrailing(resource, RESOURCE_REPLICATION_NOTIFY);
                        extra = CNResourceHandler.decode(extra);
                        this.setReplicationStatus(extra);
                        status = true;
                    } else if (resource.startsWith(RESOURCE_REPLICATION_AUTHORIZED) && httpVerb == 1) {
                        this.logMetacat.debug((Object)"Using resource: replicaAuthorizations");
                        extra = this.parseTrailing(resource, RESOURCE_REPLICATION_AUTHORIZED);
                        extra = CNResourceHandler.decode(extra);
                        this.isNodeAuthorized(extra);
                        status = true;
                    } else if (resource.startsWith("monitor/ping")) {
                        if (httpVerb == 1) {
                            extra = this.parseTrailing(resource, "monitor/ping");
                            extra = CNResourceHandler.decode(extra);
                            this.logMetacat.debug((Object)"processing ping request");
                            Date result = CNodeService.getInstance(this.request).ping();
                            status = true;
                        }
                    } else if (resource.startsWith("obsoletedBy") && httpVerb == 3) {
                        this.logMetacat.debug((Object)"Using resource: obsoletedBy");
                        extra = this.parseTrailing(resource, "obsoletedBy");
                        extra = CNResourceHandler.decode(extra);
                        this.setObsoletedBy(extra);
                        status = true;
                    } else if (resource.startsWith("removeReplicaMetadata") && httpVerb == 3) {
                        this.logMetacat.debug((Object)"Using resource: removeReplicaMetadata");
                        extra = this.parseTrailing(resource, "removeReplicaMetadata");
                        extra = CNResourceHandler.decode(extra);
                        this.deleteReplica(extra);
                        status = true;
                    } else if (resource.startsWith("views")) {
                        this.logMetacat.info((Object)"Using resource views");
                        extra = this.parseTrailing(resource, "views");
                        this.logMetacat.info((Object)("view extra: " + extra));
                        String format = null;
                        String pid = null;
                        if (extra != null) {
                            int formatIndex = extra.length();
                            if (extra.indexOf("/") <= -1) {
                                throw new InvalidRequest("2853", "The request doesn't specify the name of theme.");
                            }
                            formatIndex = extra.indexOf("/");
                            format = extra.substring(0, formatIndex);
                            format = CNResourceHandler.decode(format);
                            this.logMetacat.info((Object)("view format: " + format));
                            pid = extra.substring(formatIndex, extra.length());
                            if (pid != null && pid.length() == 0) {
                                pid = null;
                            } else if (pid.startsWith("/")) {
                                pid = pid.substring(1);
                            }
                            pid = CNResourceHandler.decode(pid);
                            this.logMetacat.debug((Object)("pid: " + pid));
                        }
                        this.logMetacat.debug((Object)("verb:" + httpVerb));
                        if (httpVerb == 1) {
                            this.doViews(format, pid);
                            status = true;
                        }
                    }
                    if (!status) {
                        throw new ServiceFailure("0000", "Unknown error, status = " + status);
                    }
                    break block81;
                }
                throw new InvalidRequest("0000", "No resource matched for " + resource);
            }
            catch (BaseException be) {
                ServletOutputStream out = null;
                try {
                    out = this.response.getOutputStream();
                }
                catch (IOException ioe) {
                    this.logMetacat.error((Object)"Could not get output stream from response", (Throwable)ioe);
                }
                this.serializeException(be, (OutputStream)out);
            }
            catch (Exception e) {
                this.logMetacat.error((Object)(e.getClass() + ": " + e.getMessage()), (Throwable)e);
                ServletOutputStream out = null;
                try {
                    out = this.response.getOutputStream();
                }
                catch (IOException ioe) {
                    this.logMetacat.error((Object)"Could not get output stream from response", (Throwable)ioe);
                }
                ServiceFailure se = new ServiceFailure("0000", e.getMessage());
                this.serializeException((BaseException)((Object)se), (OutputStream)out);
            }
        }
    }

    private void checksum(String guid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, InvalidRequest, NotImplemented, MarshallingException, IOException {
        Identifier guidid = new Identifier();
        guidid.setValue(guid);
        this.logMetacat.debug((Object)("getting checksum for object " + guid));
        Checksum c = CNodeService.getInstance(this.request).getChecksum(this.session, guidid);
        this.logMetacat.debug((Object)("got checksum " + c.getValue()));
        this.response.setStatus(200);
        this.logMetacat.debug((Object)"serializing response");
        TypeMarshaller.marshalTypeToOutputStream((Object)c, (OutputStream)this.response.getOutputStream());
        this.logMetacat.debug((Object)"done serializing response.");
    }

    private void getLog() throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, IOException, MarshallingException {
        Date fromDate = null;
        Date toDate = null;
        String event = null;
        Integer start = null;
        Integer count = null;
        String pidFilter = null;
        try {
            String fromDateS = ((String[])this.params.get("fromDate"))[0];
            this.logMetacat.debug((Object)("param fromDateS: " + fromDateS));
            fromDate = DateTimeMarshaller.deserializeDateToUTC((String)fromDateS);
        }
        catch (Exception e) {
            this.logMetacat.warn((Object)("Could not parse fromDate: " + e.getMessage()));
        }
        try {
            String toDateS = ((String[])this.params.get("toDate"))[0];
            this.logMetacat.debug((Object)("param toDateS: " + toDateS));
            toDate = DateTimeMarshaller.deserializeDateToUTC((String)toDateS);
        }
        catch (Exception e) {
            this.logMetacat.warn((Object)("Could not parse toDate: " + e.getMessage()));
        }
        try {
            event = ((String[])this.params.get("event"))[0];
        }
        catch (Exception e) {
            this.logMetacat.warn((Object)("Could not parse event: " + e.getMessage()));
        }
        this.logMetacat.debug((Object)("fromDate: " + fromDate + " toDate: " + toDate));
        try {
            start = Integer.parseInt(((String[])this.params.get("start"))[0]);
        }
        catch (Exception e) {
            this.logMetacat.warn((Object)("Could not parse start: " + e.getMessage()));
        }
        try {
            count = Integer.parseInt(((String[])this.params.get("count"))[0]);
        }
        catch (Exception e) {
            this.logMetacat.warn((Object)("Could not parse count: " + e.getMessage()));
        }
        try {
            pidFilter = ((String[])this.params.get("idFilter"))[0];
        }
        catch (Exception e) {
            this.logMetacat.warn((Object)("Could not parse pidFilter: " + e.getMessage()));
        }
        this.logMetacat.debug((Object)"calling getLogRecords");
        Log log = CNodeService.getInstance(this.request).getLogRecords(this.session, fromDate, toDate, event, pidFilter, start, count);
        ServletOutputStream out = this.response.getOutputStream();
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        TypeMarshaller.marshalTypeToOutputStream((Object)log, (OutputStream)out);
    }

    protected void getObject(String guid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, InvalidRequest, NotImplemented, IOException {
        Identifier id = new Identifier();
        id.setValue(guid);
        SystemMetadata sm = CNodeService.getInstance(this.request).getSystemMetadata(this.session, id);
        String mimeType = ObjectFormatInfo.instance().getMimeType(sm.getFormatId().getValue());
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        String extension = ObjectFormatInfo.instance().getExtension(sm.getFormatId().getValue());
        String filename = id.getValue();
        if (extension != null) {
            filename = id.getValue() + extension;
        }
        this.response.setContentType(mimeType);
        this.response.setHeader("Content-Disposition", "inline; filename=" + filename);
        InputStream data = CNodeService.getInstance(this.request).get(this.session, id);
        ServletOutputStream out = this.response.getOutputStream();
        this.response.setStatus(200);
        IOUtils.copyLarge((InputStream)data, (OutputStream)out);
    }

    protected void getSystemMetadataObject(String guid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, InvalidRequest, NotImplemented, IOException, MarshallingException {
        Identifier id = new Identifier();
        id.setValue(guid);
        SystemMetadata sysmeta = CNodeService.getInstance(this.request).getSystemMetadata(this.session, id);
        this.response.setContentType("text/xml");
        this.response.setStatus(200);
        ServletOutputStream out = this.response.getOutputStream();
        TypeMarshaller.marshalTypeToOutputStream((Object)sysmeta, (OutputStream)out);
    }

    protected void putObject(String action) throws ServiceFailure, InvalidRequest, IdentifierNotUnique, MarshallingException, InvalidToken, NotAuthorized, UnsupportedType, InsufficientResources, InvalidSystemMetadata, NotImplemented, IOException, InstantiationException, IllegalAccessException {
        Map<String, File> files = this.collectMultipartFiles();
        String pidString = (String)((List)this.multipartparams.get("pid")).get(0);
        Identifier pid = new Identifier();
        pid.setValue(pidString);
        this.logMetacat.debug((Object)("putObject: " + pid.getValue() + "/" + action));
        FileInputStream object = null;
        FileInputStream sysmeta = null;
        File smFile = files.get("sysmeta");
        sysmeta = new FileInputStream(smFile);
        File objFile = files.get("object");
        object = new FileInputStream(objFile);
        if (!action.equals("insert")) {
            throw new InvalidRequest("1000", "Operation must be create.");
        }
        this.logMetacat.debug((Object)"Commence creation...");
        SystemMetadata smd = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)sysmeta);
        this.logMetacat.debug((Object)("creating object with pid " + pid.getValue()));
        Identifier rId = CNodeService.getInstance(this.request).create(this.session, pid, object, smd);
        ServletOutputStream out = this.response.getOutputStream();
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        TypeMarshaller.marshalTypeToOutputStream((Object)rId, (OutputStream)out);
    }

    private void listFormats() throws InvalidRequest, ServiceFailure, NotFound, InsufficientResources, NotImplemented, IOException, MarshallingException {
        this.logMetacat.debug((Object)"Entering listFormats()");
        ObjectFormatList objectFormatList = CNodeService.getInstance(this.request).listFormats();
        ServletOutputStream out = this.response.getOutputStream();
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        String stylesheet = null;
        try {
            stylesheet = PropertyService.getProperty("dataone.types.xsl.v2");
        }
        catch (PropertyNotFoundException e) {
            this.logMetacat.warn((Object)("Could not locate DataONE types XSLT: " + e.getMessage()));
        }
        TypeMarshaller.marshalTypeToOutputStream((Object)objectFormatList, (OutputStream)out, (String)stylesheet);
    }

    private void listChecksumAlgorithms() throws IOException, ServiceFailure, NotImplemented, MarshallingException {
        this.logMetacat.debug((Object)"Entering listFormats()");
        ChecksumAlgorithmList result = CNodeService.getInstance(this.request).listChecksumAlgorithms();
        ServletOutputStream out = this.response.getOutputStream();
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        TypeMarshaller.marshalTypeToOutputStream((Object)result, (OutputStream)out);
    }

    private void describeObject(String pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        this.response.setContentType("text/xml");
        Identifier id = new Identifier();
        id.setValue(pid);
        DescribeResponse dr = null;
        try {
            dr = CNodeService.getInstance(this.request).describe(this.session, id);
        }
        catch (BaseException e) {
            this.response.setStatus(e.getCode());
            this.response.addHeader("DataONE-Exception-Name", ((Object)((Object)e)).getClass().getName());
            this.response.addHeader("DataONE-Exception-DetailCode", e.getDetail_code());
            this.response.addHeader("DataONE-Exception-Description", e.getDescription());
            this.response.addHeader("DataONE-Exception-PID", id.getValue());
            return;
        }
        this.response.setStatus(200);
        this.response.addHeader("DataONE-Checksum", dr.getDataONE_Checksum().getAlgorithm() + "," + dr.getDataONE_Checksum().getValue());
        this.response.addHeader("Content-Length", dr.getContent_Length() + "");
        this.response.addHeader("Last-Modified", DateTimeMarshaller.serializeDateToUTC((Date)dr.getLast_Modified()));
        this.response.addHeader("DataONE-ObjectFormat", dr.getDataONE_ObjectFormatIdentifier().getValue());
        this.response.addHeader("DataONE-SerialVersion", dr.getSerialVersion().toString());
    }

    private void deleteObject(String pid) throws IOException, InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, InvalidRequest, MarshallingException {
        ServletOutputStream out = this.response.getOutputStream();
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        Identifier id = new Identifier();
        id.setValue(pid);
        this.logMetacat.debug((Object)("Calling delete for identifier " + pid));
        CNodeService.getInstance(this.request).delete(this.session, id);
        TypeMarshaller.marshalTypeToOutputStream((Object)id, (OutputStream)out);
    }

    private void archive(String pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, IOException, MarshallingException {
        ServletOutputStream out = this.response.getOutputStream();
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        Identifier id = new Identifier();
        id.setValue(pid);
        this.logMetacat.debug((Object)"Calling archive");
        CNodeService.getInstance(this.request).archive(this.session, id);
        TypeMarshaller.marshalTypeToOutputStream((Object)id, (OutputStream)out);
    }

    private void getFormat(String fmtidStr) throws InvalidRequest, ServiceFailure, NotFound, InsufficientResources, NotImplemented, IOException, MarshallingException {
        this.logMetacat.debug((Object)"Entering listFormats()");
        ObjectFormatIdentifier fmtid = new ObjectFormatIdentifier();
        fmtid.setValue(fmtidStr);
        ObjectFormat objectFormat = CNodeService.getInstance(this.request).getFormat(fmtid);
        ServletOutputStream out = this.response.getOutputStream();
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        TypeMarshaller.marshalTypeToOutputStream((Object)objectFormat, (OutputStream)out);
    }

    private void addFormat(String formatIdStr) throws NotImplemented, ServiceFailure, InvalidRequest, InstantiationException, IllegalAccessException, IOException, MarshallingException, NotFound, NotAuthorized, InvalidToken {
        this.logMetacat.debug((Object)("addFormat: " + formatIdStr));
        Map<String, File> files = this.collectMultipartFiles();
        File formatFile = files.get("format");
        FileInputStream formatStream = new FileInputStream(formatFile);
        ObjectFormat objectFormat = (ObjectFormat)TypeMarshaller.unmarshalTypeFromStream(ObjectFormat.class, (InputStream)formatStream);
        ObjectFormatIdentifier formatId = new ObjectFormatIdentifier();
        formatId.setValue(formatIdStr);
        ObjectFormatIdentifier formatID = CNodeService.getInstance(this.request).addFormat(this.session, formatId, objectFormat);
        ServletOutputStream out = this.response.getOutputStream();
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        TypeMarshaller.marshalTypeToOutputStream((Object)formatID, (OutputStream)out);
    }

    private void reserve() throws InvalidToken, ServiceFailure, NotAuthorized, IdentifierNotUnique, NotImplemented, InvalidRequest {
        Identifier pid = null;
        Object scope = null;
        Object format = null;
        this.logMetacat.debug((Object)"Parsing reserve parameters from the mime multipart entity");
        try {
            this.collectMultipartParams();
        }
        catch (FileUploadException e1) {
            String msg = "FileUploadException: Couldn't parse the mime multipart information: " + e1.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4210", msg);
        }
        catch (IOException e1) {
            String msg = "IOException: Couldn't parse the mime multipart information: " + e1.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4210", msg);
        }
        catch (Exception e1) {
            String msg = "Exception: Couldn't parse the mime multipart information: " + e1.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4210", msg);
        }
        try {
            String id = (String)((List)this.multipartparams.get("pid")).get(0);
            pid = new Identifier();
            pid.setValue(id);
        }
        catch (NullPointerException e) {
            String msg = "The 'pid' must be provided as a parameter and was not.";
            this.logMetacat.error((Object)msg);
            throw new InvalidRequest("4200", msg);
        }
        try {
            Identifier resultPid = CNodeService.getInstance(this.request).reserveIdentifier(this.session, pid);
            ServletOutputStream out = this.response.getOutputStream();
            this.response.setStatus(200);
            this.response.setContentType("text/xml");
            TypeMarshaller.marshalTypeToOutputStream((Object)resultPid, (OutputStream)out);
        }
        catch (IOException e) {
            String msg = "Couldn't write the identifier to the response output stream: " + e.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4210", msg);
        }
        catch (MarshallingException e) {
            String msg = "Couldn't marshall the identifier to the response output stream: " + e.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4210", msg);
        }
    }

    private void resolve(String id) throws InvalidRequest, InvalidToken, ServiceFailure, NotAuthorized, NotFound, NotImplemented, IOException, MarshallingException {
        Identifier pid = new Identifier();
        pid.setValue(id);
        ObjectLocationList locationList = CNodeService.getInstance(this.request).resolve(this.session, pid);
        ServletOutputStream out = this.response.getOutputStream();
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        TypeMarshaller.marshalTypeToOutputStream((Object)locationList, (OutputStream)out);
    }

    private void owner(String id) throws InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, InvalidRequest, InstantiationException, IllegalAccessException, VersionMismatch {
        Identifier pid = new Identifier();
        pid.setValue(id);
        long serialVersion = 0L;
        String serialVersionStr = null;
        String userIdStr = null;
        Subject userId = null;
        this.logMetacat.debug((Object)"Parsing rights holder parameters from the mime multipart entity");
        try {
            this.collectMultipartParams();
        }
        catch (FileUploadException e1) {
            String msg = "FileUploadException: Couldn't parse the mime multipart information: " + e1.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4490", msg);
        }
        catch (IOException e1) {
            String msg = "IOException: Couldn't parse the mime multipart information: " + e1.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4490", msg);
        }
        catch (Exception e1) {
            String msg = "Exception: Couldn't parse the mime multipart information: " + e1.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4490", msg);
        }
        try {
            serialVersionStr = (String)((List)this.multipartparams.get("serialVersion")).get(0);
            serialVersion = new Long(serialVersionStr);
        }
        catch (NumberFormatException nfe) {
            String msg = "The 'serialVersion' must be provided as a positive integer and was not.";
            this.logMetacat.error((Object)msg);
            throw new InvalidRequest("4442", msg);
        }
        catch (NullPointerException e) {
            String msg = "The 'serialVersion' must be provided as a parameter and was not.";
            this.logMetacat.error((Object)msg);
            throw new InvalidRequest("4442", msg);
        }
        try {
            userIdStr = (String)((List)this.multipartparams.get("userId")).get(0);
            userId = new Subject();
            userId.setValue(userIdStr);
        }
        catch (NullPointerException e) {
            String msg = "The 'serialVersion' must be provided as a parameter and was not.";
            this.logMetacat.error((Object)msg);
            throw new InvalidRequest("4442", msg);
        }
        Identifier retPid = CNodeService.getInstance(this.request).setRightsHolder(this.session, pid, userId, serialVersion);
        try {
            ServletOutputStream out = this.response.getOutputStream();
            this.response.setStatus(200);
            this.response.setContentType("text/xml");
            TypeMarshaller.marshalTypeToOutputStream((Object)retPid, (OutputStream)out);
        }
        catch (IOException e) {
            String msg = "Couldn't write the identifier to the response output stream: " + e.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4490", msg);
        }
        catch (MarshallingException e) {
            String msg = "Couldn't marshall the identifier to the response output stream: " + e.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4490", msg);
        }
    }

    private boolean isAuthorized(String id) throws ServiceFailure, InvalidToken, NotFound, NotAuthorized, NotImplemented, InvalidRequest {
        Identifier pid = new Identifier();
        pid.setValue(id);
        String permission = ((String[])this.params.get("action"))[0];
        boolean result = CNodeService.getInstance(this.request).isAuthorized(this.session, pid, Permission.convert((String)permission));
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        return result;
    }

    protected void registerSystemMetadata() throws ServiceFailure, InvalidRequest, IOException, FileUploadException, MarshallingException, NotImplemented, NotAuthorized, InvalidSystemMetadata, InstantiationException, IllegalAccessException {
        Map<String, File> files = this.collectMultipartFiles();
        String pidString = (String)((List)this.multipartparams.get("pid")).get(0);
        Identifier pid = new Identifier();
        pid.setValue(pidString);
        this.logMetacat.debug((Object)("registerSystemMetadata: " + pid));
        File smFile = files.get("sysmeta");
        FileInputStream sysmeta = new FileInputStream(smFile);
        SystemMetadata systemMetadata = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)sysmeta);
        this.logMetacat.debug((Object)("registering system metadata with pid " + pid.getValue()));
        Identifier retGuid = CNodeService.getInstance(this.request).registerSystemMetadata(this.session, pid, systemMetadata);
        ServletOutputStream out = this.response.getOutputStream();
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        TypeMarshaller.marshalTypeToOutputStream((Object)retGuid, (OutputStream)out);
    }

    protected void setAccess(String pid) throws MarshallingException, InvalidToken, ServiceFailure, NotFound, NotAuthorized, NotImplemented, InvalidRequest, IOException, InstantiationException, IllegalAccessException, ParserConfigurationException, SAXException, VersionMismatch {
        long serialVersion = 0L;
        String serialVersionStr = null;
        Map<String, File> files = this.collectMultipartFiles();
        AccessPolicy accessPolicy = (AccessPolicy)TypeMarshaller.unmarshalTypeFromFile(AccessPolicy.class, (File)files.get("accessPolicy"));
        try {
            serialVersionStr = (String)((List)this.multipartparams.get("serialVersion")).get(0);
            serialVersion = new Long(serialVersionStr);
        }
        catch (NumberFormatException nfe) {
            String msg = "The 'serialVersion' must be provided as a positive integer and was not.";
            this.logMetacat.error((Object)msg);
            throw new InvalidRequest("4402", msg);
        }
        catch (NullPointerException e) {
            String msg = "The 'serialVersion' must be provided as a parameter and was not.";
            this.logMetacat.error((Object)msg);
            throw new InvalidRequest("4402", msg);
        }
        Identifier id = new Identifier();
        id.setValue(pid);
        CNodeService.getInstance(this.request).setAccessPolicy(this.session, id, accessPolicy, serialVersion);
    }

    private void listObjects() throws InvalidToken, ServiceFailure, NotAuthorized, InvalidRequest, NotImplemented, NotFound, IOException, MarshallingException {
        Date startTime = null;
        Date endTime = null;
        ObjectFormatIdentifier formatId = null;
        Identifier identifier = null;
        NodeReference nodeId = null;
        int start = 0;
        int count = 1000;
        Enumeration paramlist = this.request.getParameterNames();
        while (paramlist.hasMoreElements()) {
            String name = (String)paramlist.nextElement();
            String[] values = this.request.getParameterValues(name);
            String value = null;
            if (values != null && values.length > 0) {
                value = values[0];
                value = EncodingUtilities.decodeString((String)value);
            }
            if (name.equals("fromDate") && value != null) {
                try {
                    startTime = DateTimeMarshaller.deserializeDateToUTC((String)value);
                }
                catch (Exception e) {
                    this.logMetacat.warn((Object)("Could not parse fromDate: " + value));
                    startTime = null;
                }
                continue;
            }
            if (name.equals("toDate") && value != null) {
                try {
                    endTime = DateTimeMarshaller.deserializeDateToUTC((String)value);
                }
                catch (Exception e) {
                    this.logMetacat.warn((Object)("Could not parse toDate: " + value));
                    endTime = null;
                }
                continue;
            }
            if (name.equals("formatId") && value != null) {
                formatId = new ObjectFormatIdentifier();
                formatId.setValue(value);
                continue;
            }
            if (name.equals("identifier") && value != null) {
                identifier = new Identifier();
                identifier.setValue(value);
                continue;
            }
            if (name.equals("nodeId") && value != null) {
                nodeId = new NodeReference();
                nodeId.setValue(value);
                this.logMetacat.debug((Object)("the nodeId value is " + nodeId.getValue()));
                continue;
            }
            if (name.equals("start") && value != null) {
                start = Integer.valueOf(value);
                continue;
            }
            if (!name.equals("count") || value == null) continue;
            count = Integer.valueOf(value);
        }
        this.logMetacat.debug((Object)("session: " + this.session + " fromDate: " + startTime + " toDate: " + endTime + " formatId: " + formatId + " start: " + start + " count: " + count));
        ObjectList ol = CNodeService.getInstance(this.request).listObjects(this.session, startTime, endTime, formatId, identifier, nodeId, (Integer)start, (Integer)count);
        ServletOutputStream out = this.response.getOutputStream();
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        String stylesheet = null;
        try {
            stylesheet = PropertyService.getProperty("dataone.types.xsl.v2");
        }
        catch (PropertyNotFoundException e) {
            this.logMetacat.warn((Object)("Could not locate DataONE types XSLT: " + e.getMessage()));
        }
        TypeMarshaller.marshalTypeToOutputStream((Object)ol, (OutputStream)out, (String)stylesheet);
    }

    public boolean isNodeAuthorized(String pid) throws NotImplemented, NotAuthorized, InvalidToken, ServiceFailure, NotFound, InvalidRequest {
        boolean result = false;
        Subject targetNodeSubject = new Subject();
        String nodeSubject = null;
        Object replPermission = null;
        Identifier identifier = new Identifier();
        identifier.setValue(pid);
        try {
            nodeSubject = ((String[])this.params.get("targetNodeSubject"))[0];
            targetNodeSubject.setValue(nodeSubject);
        }
        catch (NullPointerException e) {
            String msg = "The 'targetNodeSubject' must be provided as a parameter and was not.";
            this.logMetacat.error((Object)msg);
            throw new InvalidRequest("4873", msg);
        }
        result = CNodeService.getInstance(this.request).isNodeAuthorized(this.session, targetNodeSubject, identifier);
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        return result;
    }

    public boolean setReplicationPolicy(String pid) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, IOException, InstantiationException, IllegalAccessException, MarshallingException, VersionMismatch {
        boolean result = false;
        long serialVersion = 0L;
        String serialVersionStr = null;
        Identifier identifier = new Identifier();
        identifier.setValue(pid);
        Map<String, File> files = this.collectMultipartFiles();
        ReplicationPolicy policy = (ReplicationPolicy)TypeMarshaller.unmarshalTypeFromFile(ReplicationPolicy.class, (File)files.get("policy"));
        try {
            serialVersionStr = (String)((List)this.multipartparams.get("serialVersion")).get(0);
            serialVersion = new Long(serialVersionStr);
        }
        catch (NullPointerException e) {
            String msg = "The 'serialVersion' must be provided as a parameter and was not.";
            this.logMetacat.error((Object)msg);
            throw new InvalidRequest("4883", msg);
        }
        result = CNodeService.getInstance(this.request).setReplicationPolicy(this.session, identifier, policy, serialVersion);
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        return result;
    }

    public boolean setObsoletedBy(String pid) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, InstantiationException, IllegalAccessException, VersionMismatch {
        boolean result = false;
        long serialVersion = 0L;
        String serialVersionStr = null;
        Identifier identifier = new Identifier();
        identifier.setValue(pid);
        String obsoletedByPidString = null;
        Identifier obsoletedByPid = null;
        this.logMetacat.debug((Object)"Parsing rights holder parameters from the mime multipart entity");
        try {
            this.collectMultipartParams();
        }
        catch (FileUploadException e1) {
            String msg = "FileUploadException: Couldn't parse the mime multipart information: " + e1.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4941", msg);
        }
        catch (IOException e1) {
            String msg = "IOException: Couldn't parse the mime multipart information: " + e1.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4941", msg);
        }
        catch (Exception e1) {
            String msg = "Exception: Couldn't parse the mime multipart information: " + e1.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4941", msg);
        }
        try {
            obsoletedByPidString = (String)((List)this.multipartparams.get("obsoletedByPid")).get(0);
            obsoletedByPid = new Identifier();
            obsoletedByPid.setValue(obsoletedByPidString);
        }
        catch (NullPointerException e) {
            String msg = "The 'obsoletedByPid' must be provided as a parameter and was not.";
            this.logMetacat.error((Object)msg);
            throw new InvalidRequest("4883", msg);
        }
        try {
            serialVersionStr = (String)((List)this.multipartparams.get("serialVersion")).get(0);
            serialVersion = new Long(serialVersionStr);
        }
        catch (NumberFormatException nfe) {
            String msg = "The 'serialVersion' must be provided as a positive integer and was not.";
            this.logMetacat.error((Object)msg);
            throw new InvalidRequest("4942", msg);
        }
        catch (NullPointerException e) {
            String msg = "The 'serialVersion' must be provided as a parameter and was not.";
            this.logMetacat.error((Object)msg);
            throw new InvalidRequest("4942", msg);
        }
        result = CNodeService.getInstance(this.request).setObsoletedBy(this.session, identifier, obsoletedByPid, serialVersion);
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        return result;
    }

    public boolean deleteReplica(String pid) throws NotImplemented, NotFound, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, InstantiationException, IllegalAccessException, VersionMismatch {
        boolean result = false;
        long serialVersion = 0L;
        String serialVersionStr = null;
        Identifier identifier = new Identifier();
        identifier.setValue(pid);
        NodeReference nodeId = null;
        this.logMetacat.debug((Object)"Parsing delete replica parameters from the mime multipart entity");
        try {
            this.collectMultipartParams();
        }
        catch (FileUploadException e1) {
            String msg = "FileUploadException: Couldn't parse the mime multipart information: " + e1.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4951", msg);
        }
        catch (IOException e1) {
            String msg = "IOException: Couldn't parse the mime multipart information: " + e1.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4951", msg);
        }
        catch (Exception e1) {
            String msg = "Exception: Couldn't parse the mime multipart information: " + e1.getMessage();
            this.logMetacat.debug((Object)msg);
            throw new ServiceFailure("4951", msg);
        }
        try {
            String nodeIdString = (String)((List)this.multipartparams.get("nodeId")).get(0);
            nodeId = new NodeReference();
            nodeId.setValue(nodeIdString);
        }
        catch (NullPointerException e) {
            String msg = "The 'nodeId' must be provided as a parameter and was not.";
            this.logMetacat.error((Object)msg);
            throw new InvalidRequest("4952", msg);
        }
        try {
            serialVersionStr = (String)((List)this.multipartparams.get("serialVersion")).get(0);
            serialVersion = new Long(serialVersionStr);
        }
        catch (NumberFormatException nfe) {
            String msg = "The 'serialVersion' must be provided as a positive integer and was not.";
            this.logMetacat.error((Object)msg);
            throw new InvalidRequest("4952", msg);
        }
        catch (NullPointerException e) {
            String msg = "The 'serialVersion' must be provided as a parameter and was not.";
            this.logMetacat.error((Object)msg);
            throw new InvalidRequest("4952", msg);
        }
        result = CNodeService.getInstance(this.request).deleteReplicationMetadata(this.session, identifier, nodeId, serialVersion);
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        return result;
    }

    public boolean setReplicationStatus(String pid) throws ServiceFailure, NotImplemented, InvalidToken, NotAuthorized, InvalidRequest, NotFound {
        boolean result = false;
        Identifier identifier = new Identifier();
        identifier.setValue(pid);
        BaseException failure = null;
        ReplicationStatus status = null;
        String replicationStatus = null;
        NodeReference targetNodeRef = null;
        String targetNode = null;
        this.logMetacat.debug((Object)"Parsing ReplicaStatus from the mime multipart entity");
        try {
            Map<String, File> files = this.collectMultipartFiles();
            if (files.containsKey("failure")) {
                failure = ExceptionHandler.deserializeXml((InputStream)new FileInputStream(files.get("failure")), (String)"Replication failed for an unknown reason.");
            }
        }
        catch (Exception e2) {
            throw new ServiceFailure("4700", "Couldn't resolve the multipart request: " + e2.getMessage());
        }
        try {
            replicationStatus = (String)((List)this.multipartparams.get("status")).get(0);
            status = ReplicationStatus.convert((String)replicationStatus);
        }
        catch (NullPointerException npe) {
            this.logMetacat.debug((Object)"The 'status' parameter was not found in the multipartparams map.  Trying the params map.");
            try {
                replicationStatus = ((String[])this.params.get("status"))[0];
                status = ReplicationStatus.convert((String)replicationStatus.toLowerCase());
            }
            catch (Exception e) {
                String msg = "The 'status' must be provided as a parameter and was not.";
                this.logMetacat.error((Object)msg);
                throw new InvalidRequest("4730", msg);
            }
        }
        try {
            targetNode = (String)((List)this.multipartparams.get("nodeRef")).get(0);
            targetNodeRef = new NodeReference();
            targetNodeRef.setValue(targetNode);
        }
        catch (NullPointerException e) {
            this.logMetacat.debug((Object)"The 'nodeRef' parameter was not found in the multipartparams map.  Trying the params map.");
            try {
                targetNode = ((String[])this.params.get("nodeRef"))[0];
                targetNodeRef = new NodeReference();
                targetNodeRef.setValue(targetNode);
            }
            catch (Exception e1) {
                String msg = "The 'nodeRef' must be provided as a parameter and was not.";
                this.logMetacat.error((Object)msg);
                throw new InvalidRequest("4730", msg);
            }
        }
        result = CNodeService.getInstance(this.request).setReplicationStatus(this.session, identifier, targetNodeRef, status, failure);
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        return result;
    }

    public boolean updateReplicationMetadata(String pid) throws ServiceFailure, NotImplemented, InvalidToken, NotAuthorized, InvalidRequest, NotFound, VersionMismatch, InstantiationException, IllegalAccessException, IOException, MarshallingException {
        boolean result = false;
        long serialVersion = 0L;
        String serialVersionStr = null;
        Identifier identifier = new Identifier();
        identifier.setValue(pid);
        Map<String, File> files = this.collectMultipartFiles();
        Replica replica = (Replica)TypeMarshaller.unmarshalTypeFromFile(Replica.class, (File)files.get(RESOURCE_REPLICATION_META));
        try {
            serialVersionStr = (String)((List)this.multipartparams.get("serialVersion")).get(0);
            serialVersion = new Long(serialVersionStr);
        }
        catch (NullPointerException e) {
            String msg = "The 'serialVersion' must be provided as a parameter and was not.";
            this.logMetacat.error((Object)msg);
            throw new InvalidRequest("4853", msg);
        }
        result = CNodeService.getInstance(this.request).updateReplicationMetadata(this.session, identifier, replica, serialVersion);
        this.response.setStatus(200);
        this.response.setContentType("text/xml");
        return result;
    }

    protected void updateSystemMetadata() throws ServiceFailure, InvalidRequest, InstantiationException, IllegalAccessException, IOException, MarshallingException, NotImplemented, NotAuthorized, InvalidSystemMetadata, InvalidToken {
        Map<String, File> files = this.collectMultipartFiles();
        String pidString = (String)((List)this.multipartparams.get("pid")).get(0);
        Identifier pid = new Identifier();
        pid.setValue(pidString);
        this.logMetacat.debug((Object)("updateSystemMetadata: " + pid));
        File smFile = files.get("sysmeta");
        FileInputStream sysmeta = new FileInputStream(smFile);
        SystemMetadata systemMetadata = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)sysmeta);
        this.logMetacat.debug((Object)("updating system metadata with pid " + pid.getValue()));
        CNodeService.getInstance(this.request).updateSystemMetadata(this.session, pid, systemMetadata);
    }

    private void doViews(String format, String pid) {
        ServletOutputStream out = null;
        CNodeService cnode = CNodeService.getInstance(this.request);
        try {
            if (pid != null) {
                Identifier identifier = new Identifier();
                identifier.setValue(pid);
                InputStream stream = cnode.view(this.session, format, identifier);
                if (stream instanceof ContentTypeInputStream) {
                    this.response.setContentType(((ContentTypeInputStream)stream).getContentType());
                }
                this.response.setStatus(200);
                out = this.response.getOutputStream();
                IOUtils.copyLarge((InputStream)stream, (OutputStream)out);
                return;
            }
            OptionList list = cnode.listViews(this.session);
            this.response.setContentType("text/xml");
            this.response.setStatus(200);
            TypeMarshaller.marshalTypeToOutputStream((Object)list, (OutputStream)this.response.getOutputStream());
        }
        catch (BaseException be) {
            try {
                out = this.response.getOutputStream();
            }
            catch (IOException e) {
                this.logMetacat.error((Object)"Could not get output stream from response", (Throwable)e);
            }
            this.serializeException(be, (OutputStream)out);
        }
        catch (Exception e) {
            this.logMetacat.error((Object)(e.getClass() + ": " + e.getMessage()), (Throwable)e);
            try {
                out = this.response.getOutputStream();
            }
            catch (IOException ioe) {
                this.logMetacat.error((Object)"Could not get output stream from response", (Throwable)ioe);
            }
            ServiceFailure se = new ServiceFailure("0000", e.getMessage());
            this.serializeException((BaseException)((Object)se), (OutputStream)out);
        }
    }
}

