/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.spatial;

import com.vividsolutions.jts.geom.MultiPolygon;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.SystemUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import org.apache.log4j.Logger;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeatureType;

public class SpatialFeatureSchema {
    private static Logger log = Logger.getLogger((String)SpatialFeatureSchema.class.getName());
    public static String polygonShpUri = null;
    public static String pointShpUri = null;
    public static int srid;

    public static SimpleFeatureType getPolygonFeatureType() {
        try {
            SimpleFeatureTypeBuilder featureBuilder = new SimpleFeatureTypeBuilder();
            featureBuilder.add("the_geom", MultiPolygon.class);
            featureBuilder.add("docid", String.class);
            featureBuilder.add("url", String.class);
            featureBuilder.add("title", String.class);
            featureBuilder.setName("bounds");
            SimpleFeatureType boundsType = featureBuilder.buildFeatureType();
            return boundsType;
        }
        catch (Exception e) {
            log.error((Object)("Problem building feature type : " + e));
            return null;
        }
    }

    public static SimpleFeatureType getPointFeatureType() {
        try {
            SimpleFeatureTypeBuilder featureBuilder = new SimpleFeatureTypeBuilder();
            featureBuilder.add("the_geom", MultiPolygon.class);
            featureBuilder.add("docid", String.class);
            featureBuilder.add("url", String.class);
            featureBuilder.add("title", String.class);
            featureBuilder.setName("centroids");
            SimpleFeatureType centroidsType = featureBuilder.buildFeatureType();
            return centroidsType;
        }
        catch (Exception e) {
            log.error((Object)("Problem building feature : " + e));
            return null;
        }
    }

    static {
        try {
            String geoserverDataDir = PropertyService.getProperty("geoserver.GEOSERVER_DATA_DIR");
            if (geoserverDataDir != null && geoserverDataDir.length() > 0) {
                polygonShpUri = geoserverDataDir + "/data/metacat_shps/data_bounds.shp";
                pointShpUri = geoserverDataDir + "/data/metacat_shps/data_points.shp";
            } else {
                String certPath = SystemUtil.getContextDir();
                polygonShpUri = certPath + "/spatial/geoserver/data/data/metacat_shps/data_bounds.shp";
                pointShpUri = certPath + "/spatial/geoserver/data/data/metacat_shps/data_points.shp";
            }
        }
        catch (PropertyNotFoundException pnfe) {
            System.err.println("Error in SpatialFeatureSchema static block:" + pnfe.getMessage());
            pnfe.printStackTrace();
        }
        srid = 4326;
    }
}

