/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.spatial;

import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTransform {
    public static void transform(String docString, String xslSystemId, PrintWriter pw, Hashtable param) {
        XSLTransform.transform(new StringReader(docString), xslSystemId, pw, param);
    }

    public static void transform(Reader doc, String xslSystemId, PrintWriter pw, Hashtable param) {
        try {
            StreamSource xslSource = new StreamSource(xslSystemId);
            xslSource.setSystemId(xslSystemId);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(xslSource);
            if (param != null) {
                Enumeration en = param.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    String value = (String)param.get(key);
                    transformer.setParameter(key, value);
                }
            }
            StreamSource ss = new StreamSource(doc);
            StreamResult sr = new StreamResult(pw);
            transformer.transform(ss, sr);
        }
        catch (Exception e) {
            pw.println("Error transforming document in XSLTransform.transform:\n" + e.getMessage());
            e.printStackTrace(pw);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Wrong number of arguments!!!");
            System.err.println("USAGE: java XSLTransform xml style");
            return;
        }
        String xmlfile = args[0];
        String xslfile = args[1];
        try {
            FileReader r = new FileReader(xmlfile);
            XSLTransform.transform(r, xslfile, new PrintWriter(System.out), null);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION HANDLING REQUIRED");
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

