/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.util;

import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.shared.MetacatUtilException;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import edu.ucsb.nceas.utilities.StringUtil;
import java.util.Vector;

public class OrganizationUtil {
    private OrganizationUtil() {
    }

    public static Vector<String> getOrganizations() throws MetacatUtilException {
        Vector<String> shortOrgNames = new Vector<String>();
        Vector<String> longOrgNames = null;
        longOrgNames = PropertyService.getPropertyNamesByGroup("organization.name");
        for (String longName : longOrgNames) {
            shortOrgNames.add(longName.substring(18));
        }
        return shortOrgNames;
    }

    public static Vector<String> getOrgDNs(String orgName) throws MetacatUtilException {
        String orgBaseList = null;
        try {
            orgBaseList = PropertyService.getProperty("organization.base." + orgName);
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatUtilException("Could not get metacat property: organization.base." + orgName + " : " + pnfe.getMessage());
        }
        return StringUtil.toVector((String)orgBaseList, (char)',');
    }

    public static boolean areOrganizationsConfigured() throws MetacatUtilException {
        String orgConfiguredString = "false";
        try {
            orgConfiguredString = PropertyService.getProperty("configutil.organizationsConfigured");
        }
        catch (PropertyNotFoundException pnfe) {
            throw new MetacatUtilException("Could not determine if organizations are configured: " + pnfe.getMessage());
        }
        return !orgConfiguredString.equals("false");
    }
}

