/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandParticipant
extends SingleLineCommand2<SequenceDiagram> {
    public CommandParticipant(SequenceDiagram sequenceDiagram, RegexConcat regexConcat) {
        super(sequenceDiagram, regexConcat);
    }

    @Override
    protected final CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
        String string = map.get("CODE").get(0);
        if (((SequenceDiagram)this.getSystem()).participants().containsKey(string)) {
            ((SequenceDiagram)this.getSystem()).putParticipantInLast(string);
            return CommandExecutionResult.ok();
        }
        List<String> list = null;
        if (map.get("FULL").get(0) != null) {
            list = StringUtils.getWithNewlines(map.get("FULL").get(0));
        }
        ParticipantType participantType = ParticipantType.valueOf(map.get("TYPE").get(0).toUpperCase());
        Participant participant = ((SequenceDiagram)this.getSystem()).createNewParticipant(participantType, string, list);
        String string2 = map.get("STEREO").get(0);
        if (string2 != null) {
            participant.setStereotype(new Stereotype(string2, ((SequenceDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((SequenceDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        participant.setSpecificBackcolor(HtmlColor.getColorIfValid(map.get("COLOR").get(0)));
        return CommandExecutionResult.ok();
    }
}

