/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.svg;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverPolygonSvg
implements UDriver<SvgGraphics> {
    private final ClipContainer clipContainer;

    public DriverPolygonSvg(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, SvgGraphics svgGraphics) {
        UPolygon uPolygon = (UPolygon)uShape;
        double[] dArray = new double[uPolygon.getPoints().size() * 2];
        int n = 0;
        for (Point2D.Double double_ : uPolygon.getPoints()) {
            dArray[n++] = ((Point2D)double_).getX() + d;
            dArray[n++] = ((Point2D)double_).getY() + d2;
        }
        UClip uClip = this.clipContainer.getClip();
        if (uClip != null) {
            for (int i = 0; i < dArray.length; i += 2) {
                if (uClip.isInside(dArray[i], dArray[i + 1])) continue;
                return;
            }
        }
        String string = uParam.getColor() == null ? "none" : StringUtils.getAsHtml(colorMapper.getMappedColor(uParam.getColor()));
        String string2 = uParam.getBackcolor() == null ? "none" : StringUtils.getAsHtml(colorMapper.getMappedColor(uParam.getBackcolor()));
        svgGraphics.setFillColor(string2);
        svgGraphics.setStrokeColor(string);
        svgGraphics.setStrokeWidth("" + uParam.getStroke().getThickness(), uParam.getStroke().getDasharraySvg());
        svgGraphics.svgPolygon(dArray);
    }
}

