/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram.command;

import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.activitydiagram.command.CommandLinkActivity;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinkLongActivity
extends CommandMultilines2<ActivityDiagram> {
    public CommandLinkLongActivity(ActivityDiagram activityDiagram) {
        super(activityDiagram, CommandLinkLongActivity.getRegexConcat(), "(?i)^\\s*([^\"]*)\"(?:\\s+as\\s+([\\p{L}0-9_.]+))?\\s*(\\<\\<.*\\>\\>)?\\s*(#\\w+)?$");
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexOr("FIRST", true, new RegexLeaf("STAR", "(\\(\\*(top)?\\))"), new RegexLeaf("CODE", "([\\p{L}0-9_.]+)"), new RegexLeaf("BAR", "(?:==+)\\s*([\\p{L}0-9_.]+)\\s*(?:==+)"), new RegexLeaf("QUOTED", "\"([^\"]+)\"(?:\\s+as\\s+([\\p{L}0-9_.]+))?")), new RegexLeaf("\\s*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("\\s*"), new RegexLeaf("BACKCOLOR", "(#\\w+)?"), new RegexLeaf("\\s*"), new RegexLeaf("ARROW", "([=-]+(?:(left|right|up|down|le?|ri?|up?|do?)(?=[-=]))?[=-]*\\>)"), new RegexLeaf("\\s*"), new RegexLeaf("BRACKET", "(?:\\[([^\\]*]+[^\\]]*)\\])?"), new RegexLeaf("\\s*"), new RegexLeaf("DESC", "\"([^\"]*?)"), new RegexLeaf("\\s*"), new RegexLeaf("$"));
    }

    @Override
    public CommandExecutionResult execute(List<String> list) {
        StringUtils.trim(list, false);
        Map<String, RegexPartialMatch> map = this.getStartingPattern().matcher(list.get(0).trim());
        IEntity iEntity = CommandLinkActivity.getEntity((ActivityDiagram)this.getSystem(), map, true);
        if (map.get("STEREOTYPE").get(0) != null) {
            iEntity.setStereotype(new Stereotype(map.get("STEREOTYPE").get(0)));
        }
        if (map.get("BACKCOLOR").get(0) != null) {
            iEntity.setSpecificBackcolor(HtmlColor.getColorIfValid(map.get("BACKCOLOR").get(0)));
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty(map.get("DESC").get(0))) {
            stringBuilder.append(map.get("DESC").get(0));
            stringBuilder.append("\\n");
        }
        for (int i = 1; i < list.size() - 1; ++i) {
            stringBuilder.append(list.get(i));
            if (i >= list.size() - 2) continue;
            stringBuilder.append("\\n");
        }
        List<String> list2 = StringUtils.getSplit(this.getEnding(), list.get(list.size() - 1));
        if (StringUtils.isNotEmpty(list2.get(0))) {
            if (!stringBuilder.toString().endsWith("\\n")) {
                stringBuilder.append("\\n");
            }
            stringBuilder.append(list2.get(0));
        }
        String string = stringBuilder.toString();
        String string2 = list2.get(1) == null ? string : list2.get(1);
        Entity entity = ((ActivityDiagram)this.getSystem()).createEntity(string2, string, EntityType.ACTIVITY);
        if (list2.get(2) != null) {
            entity.setStereotype(new Stereotype(list2.get(2)));
        }
        if (list2.get(3) != null) {
            entity.setSpecificBackcolor(HtmlColor.getColorIfValid(list2.get(3)));
        }
        if (iEntity == null || entity == null) {
            return CommandExecutionResult.error("No such entity");
        }
        String string3 = StringUtils.manageArrowForCuca(map.get("ARROW").get(0));
        int n = string3.length() - 1;
        String string4 = map.get("BRACKET").get(0);
        Link link = new Link(iEntity, entity, new LinkType(LinkDecor.ARROW, LinkDecor.NONE), string4, n);
        Direction direction = StringUtils.getArrowDirection(map.get("ARROW").get(0));
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        ((ActivityDiagram)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }
}

