/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.PSystem;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleLineCommand<S extends PSystem>
implements Command {
    private final S system;
    private final Pattern pattern;

    public SingleLineCommand(S s, String string) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (!string.startsWith("(?i)^") || !string.endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + string);
        }
        this.system = s;
        this.pattern = Pattern.compile(string);
    }

    @Override
    public String[] getDescription() {
        return new String[]{this.pattern.pattern()};
    }

    protected final S getSystem() {
        return this.system;
    }

    @Override
    public final CommandControl isValid(List<String> list) {
        if (list.size() != 1) {
            return CommandControl.NOT_OK;
        }
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        String string = list.get(0).trim();
        Matcher matcher = this.pattern.matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            this.actionIfCommandValid();
        }
        return bl ? CommandControl.OK : CommandControl.NOT_OK;
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    @Override
    public final CommandExecutionResult execute(List<String> list) {
        if (list.size() != 1) {
            throw new IllegalArgumentException();
        }
        String string = list.get(0).trim();
        if (this.isForbidden(string)) {
            return CommandExecutionResult.error("Forbidden line " + string);
        }
        List<String> list2 = this.getSplit(string);
        if (list2 == null) {
            return CommandExecutionResult.error("Cannot parse line " + string);
        }
        return this.executeArg(list2);
    }

    protected boolean isForbidden(String string) {
        return false;
    }

    protected abstract CommandExecutionResult executeArg(List<String> var1);

    public final List<String> getSplit(String string) {
        return StringUtils.getSplit(this.pattern, string);
    }

    @Override
    public final boolean isDeprecated(List<String> list) {
        if (list.size() != 1) {
            return false;
        }
        return this.isDeprecated(list.get(0));
    }

    @Override
    public String getHelpMessageForDeprecated(List<String> list) {
        return null;
    }

    protected boolean isDeprecated(String string) {
        return false;
    }
}

