/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.dot.DrawFile;
import net.sourceforge.plantuml.cucadiagram.dot.Lazy;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.skin.CircleInterface;
import net.sourceforge.plantuml.skin.UDrawable;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

public class StaticFiles {
    private final HtmlColor interfaceBorder;
    private final HtmlColor classborder;
    private final HtmlColor classBackground;
    private final HtmlColor interfaceBackground;
    private final HtmlColor background;
    private final UFont circledFont;
    private final double radius;
    private final Map<EntityType, DrawFile> staticImages = new EnumMap<EntityType, DrawFile>(EntityType.class);
    private final Map<VisibilityModifier, DrawFile> visibilityImages = new EnumMap<VisibilityModifier, DrawFile>(VisibilityModifier.class);
    private final Map<VisibilityModifier, HtmlColor> foregroundColor = new EnumMap<VisibilityModifier, HtmlColor>(VisibilityModifier.class);
    private final Map<VisibilityModifier, HtmlColor> backgroundColor = new EnumMap<VisibilityModifier, HtmlColor>(VisibilityModifier.class);
    private final double dpiFactor;
    private final ColorMapper colorMapper;

    public StaticFiles(ISkinParam iSkinParam, String string, double d) throws IOException {
        this.colorMapper = iSkinParam.getColorMapper();
        Rose rose = new Rose();
        this.dpiFactor = d;
        this.radius = iSkinParam.getCircledCharacterRadius();
        this.circledFont = iSkinParam.getFont(FontParam.CIRCLED_CHARACTER, string);
        this.classborder = rose.getHtmlColor(iSkinParam, ColorParam.classBorder, string);
        this.interfaceBorder = rose.getHtmlColor(iSkinParam, ColorParam.componentInterfaceBorder, string);
        this.interfaceBackground = rose.getHtmlColor(iSkinParam, ColorParam.componentInterfaceBackground, string);
        this.classBackground = rose.getHtmlColor(iSkinParam, ColorParam.classBackground, string);
        HtmlColor htmlColor = rose.getHtmlColor(iSkinParam, ColorParam.stereotypeCBackground, string);
        HtmlColor htmlColor2 = rose.getHtmlColor(iSkinParam, ColorParam.stereotypeABackground, string);
        HtmlColor htmlColor3 = rose.getHtmlColor(iSkinParam, ColorParam.stereotypeIBackground, string);
        HtmlColor htmlColor4 = rose.getHtmlColor(iSkinParam, ColorParam.stereotypeEBackground, string);
        this.background = iSkinParam.getBackgroundColor();
        File file = FileUtils.getTmpDir();
        this.staticImages.put(EntityType.LOLLIPOP, this.getLollipop());
        this.staticImages.put(EntityType.ABSTRACT_CLASS, this.getCircledCharacter('A', htmlColor2));
        this.staticImages.put(EntityType.CLASS, this.getCircledCharacter('C', htmlColor));
        this.staticImages.put(EntityType.INTERFACE, this.getCircledCharacter('I', htmlColor3));
        this.staticImages.put(EntityType.ENUM, this.getCircledCharacter('E', htmlColor4));
        if (iSkinParam.classAttributeIconSize() > 0) {
            for (VisibilityModifier visibilityModifier : EnumSet.allOf(VisibilityModifier.class)) {
                HtmlColor htmlColor5 = visibilityModifier.getBackground() == null ? null : rose.getHtmlColor(iSkinParam, visibilityModifier.getBackground(), string);
                HtmlColor htmlColor6 = rose.getHtmlColor(iSkinParam, visibilityModifier.getForeground(), string);
                this.backgroundColor.put(visibilityModifier, htmlColor5);
                this.foregroundColor.put(visibilityModifier, htmlColor6);
                this.visibilityImages.put(visibilityModifier, this.getVisibilityModifier(visibilityModifier, file, iSkinParam.classAttributeIconSize(), d));
            }
        }
    }

    private DrawFile getLollipop() throws IOException {
        final CircleInterface circleInterface = new CircleInterface(this.interfaceBackground, this.interfaceBorder, 10.0, 2.0f);
        Lazy<File> lazy = new Lazy<File>(){

            @Override
            public File getNow() throws IOException {
                EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(circleInterface.getPreferredWidth(null), circleInterface.getPreferredHeight(null), StaticFiles.this.colorMapper.getMappedColor(StaticFiles.this.background));
                BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
                Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
                circleInterface.drawU(new UGraphicG2d(StaticFiles.this.colorMapper, graphics2D, null, StaticFiles.this.dpiFactor));
                File file = FileUtils.createTempFile("lollipop", ".png");
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                return file;
            }
        };
        Lazy<File> lazy2 = new Lazy<File>(){

            @Override
            public File getNow() throws IOException {
                File file = FileUtils.createTempFile("lollipop", ".eps");
                UGraphicEps.copyEpsToFile(StaticFiles.this.colorMapper, circleInterface, file);
                return file;
            }
        };
        Lazy<String> lazy3 = new Lazy<String>(){

            @Override
            public String getNow() throws IOException {
                return UGraphicG2d.getSvgString(StaticFiles.this.colorMapper, circleInterface);
            }
        };
        List<Object> list = Arrays.asList("lollipop", this.interfaceBackground, this.interfaceBorder, this.background);
        return DrawFile.create(lazy, lazy3, lazy2, list);
    }

    private DrawFile getCircledCharacter(char c, HtmlColor htmlColor) throws IOException {
        CircledCharacter circledCharacter = new CircledCharacter(c, this.radius, this.circledFont, htmlColor, this.classborder, HtmlColor.BLACK);
        return circledCharacter.generateCircleCharacter(this.colorMapper, this.classBackground, this.dpiFactor);
    }

    public DrawFile getStaticImages(EntityType entityType) {
        return this.staticImages.get((Object)entityType);
    }

    public final DrawFile getVisibilityImages(VisibilityModifier visibilityModifier) {
        return this.visibilityImages.get((Object)visibilityModifier);
    }

    public DrawFile getDrawFile(String string) throws IOException {
        File file;
        File file2 = new File(string).getCanonicalFile();
        for (DrawFile drawFile : this.staticImages.values()) {
            file = drawFile.getPng().getCanonicalFile();
            if (!file.equals(file2)) continue;
            return drawFile;
        }
        for (DrawFile drawFile : this.visibilityImages.values()) {
            file = drawFile.getPng().getCanonicalFile();
            if (!file.equals(file2)) continue;
            return drawFile;
        }
        return null;
    }

    private DrawFile getVisibilityModifier(VisibilityModifier visibilityModifier, File file, final int n, final double d) throws IOException {
        final UDrawable uDrawable = visibilityModifier.getUDrawable(n, this.foregroundColor.get((Object)visibilityModifier), this.backgroundColor.get((Object)visibilityModifier));
        Lazy<File> lazy = new Lazy<File>(){

            @Override
            public File getNow() throws IOException {
                File file = FileUtils.createTempFile("visi", ".png");
                EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder((double)n * d, (double)n * d, StaticFiles.this.colorMapper.getMappedColor(StaticFiles.this.classBackground));
                BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
                uDrawable.drawU(new UGraphicG2d(StaticFiles.this.colorMapper, emptyImageBuilder.getGraphics2D(), bufferedImage, d));
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                return file;
            }
        };
        Lazy<File> lazy2 = new Lazy<File>(){

            @Override
            public File getNow() throws IOException {
                File file = FileUtils.createTempFile("visi", ".eps");
                UGraphicEps.copyEpsToFile(StaticFiles.this.colorMapper, uDrawable, file);
                return file;
            }
        };
        Lazy<String> lazy3 = new Lazy<String>(){

            @Override
            public String getNow() throws IOException {
                return UGraphicG2d.getSvgString(StaticFiles.this.colorMapper, uDrawable);
            }
        };
        List<Object> list = Arrays.asList(new Object[]{"visi", visibilityModifier, this.foregroundColor.get((Object)visibilityModifier), this.backgroundColor.get((Object)visibilityModifier), n, this.classBackground});
        return DrawFile.create(lazy, lazy3, lazy2, list);
    }

    public void clean() {
        for (DrawFile drawFile : this.staticImages.values()) {
            drawFile.deleteDrawFile();
        }
        for (DrawFile drawFile : this.visibilityImages.values()) {
            drawFile.deleteDrawFile();
        }
    }
}

