/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.graphic;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.project.Day;
import net.sourceforge.plantuml.project.Instant;
import net.sourceforge.plantuml.project.Month;
import net.sourceforge.plantuml.project.Project;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TimeScale {
    private final UFont font = new UFont("Serif", 0, 9);
    private final Project project;
    private final FontConfiguration fontConfig = new FontConfiguration(this.font, HtmlColor.BLACK);

    public TimeScale(Project project) {
        this.project = project;
    }

    public void draw(UGraphic uGraphic, double d, double d2) {
        Dimension2D dimension2D;
        TextBlock textBlock;
        Day day;
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d3 = this.getMonthHeight(stringBounder);
        double d4 = this.getCaseWidth(stringBounder);
        double d5 = this.getCaseHeight(stringBounder);
        int n = this.getNbCase();
        uGraphic.getParam().setColor(HtmlColor.BLACK);
        uGraphic.draw(d, d2, new URectangle((double)n * d4, d3));
        Instant instant = this.project.getEnd();
        Month month = null;
        double d6 = d;
        Instant instant2 = this.project.getStart();
        while (instant2.compareTo(instant) <= 0) {
            day = instant2.getDay();
            if (month == null || day.getMonth() != month) {
                uGraphic.draw(d6, d2, new ULine(0.0, d3));
                month = day.getMonth();
                textBlock = TextBlockUtils.create(Arrays.asList(month.name()), this.fontConfig, HorizontalAlignement.LEFT);
                dimension2D = textBlock.calculateDimension(stringBounder);
                textBlock.drawU(uGraphic, d6, d2 + (d3 - dimension2D.getHeight()) / 2.0);
            }
            d6 += d4;
            instant2 = instant2.next(this.project.getDayClose());
        }
        d6 = d;
        uGraphic.draw(d, d2 += d3, new URectangle((double)n * d4, d5));
        instant2 = this.project.getStart();
        while (instant2.compareTo(instant) <= 0) {
            day = instant2.getDay();
            textBlock = TextBlockUtils.create(Arrays.asList("" + day.getNumDay()), this.fontConfig, HorizontalAlignement.LEFT);
            dimension2D = textBlock.calculateDimension(stringBounder);
            textBlock.drawU(uGraphic, d6 + (d4 - dimension2D.getWidth()) / 2.0, d2 + (d5 - dimension2D.getHeight()) / 2.0);
            uGraphic.draw(d6 += d4, d2, new ULine(0.0, d5));
            instant2 = instant2.next(this.project.getDayClose());
        }
    }

    public SortedMap<Instant, Double> getAbscisse(StringBounder stringBounder) {
        TreeMap<Instant, Double> treeMap = new TreeMap<Instant, Double>();
        double d = this.getCaseWidth(stringBounder);
        Instant instant = this.project.getEnd();
        double d2 = 0.0;
        Instant instant2 = this.project.getStart();
        while (instant2.compareTo(instant) <= 0) {
            treeMap.put(instant2, d2);
            d2 += d;
            instant2 = instant2.next(this.project.getDayClose());
        }
        return Collections.unmodifiableSortedMap(treeMap);
    }

    private int getNbCase() {
        int n = 0;
        Instant instant = this.project.getEnd();
        Instant instant2 = this.project.getStart();
        while (instant2.compareTo(instant) <= 0) {
            ++n;
            instant2 = instant2.next(this.project.getDayClose());
        }
        return n;
    }

    private double getCaseWidth(StringBounder stringBounder) {
        Dimension2D dimension2D = stringBounder.calculateDimension(this.font, "00");
        return dimension2D.getWidth() + 3.0;
    }

    private double getCaseHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = stringBounder.calculateDimension(this.font, "00");
        return dimension2D.getHeight() + 3.0;
    }

    private double getMonthHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = stringBounder.calculateDimension(this.font, "ZZ");
        return dimension2D.getHeight() + 3.0;
    }

    public double getWidth(StringBounder stringBounder) {
        return this.getCaseWidth(stringBounder) * (double)this.getNbCase();
    }

    public double getHeight(StringBounder stringBounder) {
        return this.getCaseHeight(stringBounder) + this.getMonthHeight(stringBounder);
    }
}

