/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.InstallDeployTaskSupport;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.tools.ant.BuildException;

public class InstallTask
extends InstallDeployTaskSupport {
    protected void doExecute() {
        if (this.file == null && this.attachedArtifacts.size() == 0) {
            throw new BuildException("You must specify a file and/or an attached artifact to install to the local repository.");
        }
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        Pom pom = this.initializePom(localRepo);
        if (pom == null) {
            throw new BuildException("A POM element is required to install to the local repository");
        }
        Artifact artifact = pom.getArtifact();
        boolean isPomArtifact = "pom".equals(pom.getPackaging());
        if (!isPomArtifact) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pom.getFile());
            artifact.addMetadata(metadata);
        }
        ArtifactInstaller installer = (ArtifactInstaller)this.lookup(ArtifactInstaller.ROLE);
        try {
            if (this.file != null) {
                if (!isPomArtifact) {
                    installer.install(this.file, artifact, localRepo);
                } else {
                    installer.install(pom.getFile(), artifact, localRepo);
                }
            }
            if (this.attachedArtifacts != null) {
                Iterator iter = pom.getAttachedArtifacts().iterator();
                while (iter.hasNext()) {
                    Artifact attachedArtifact = (Artifact)iter.next();
                    installer.install(attachedArtifact.getFile(), attachedArtifact, localRepo);
                }
            }
        }
        catch (ArtifactInstallationException e) {
            throw new BuildException("Error installing artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Throwable)e);
        }
    }
}

