/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog;

import ORG.oclc.oai.server.catalog.RecordFactory;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class NewFileRecordFactory
extends RecordFactory {
    private String repositoryIdentifier = null;

    public NewFileRecordFactory(Properties properties) throws IllegalArgumentException {
        super(properties);
        this.repositoryIdentifier = properties.getProperty("NewFileRecordFactory.repositoryIdentifier");
        if (this.repositoryIdentifier == null) {
            throw new IllegalArgumentException("NewFileRecordFactory.repositoryIdentifier is missing from the properties file");
        }
    }

    public String fromOAIIdentifier(String identifier) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(identifier, ":");
            tokenizer.nextToken();
            tokenizer.nextToken();
            return tokenizer.nextToken();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getOAIIdentifier(Object nativeItem) {
        StringBuffer sb = new StringBuffer();
        sb.append("oai:");
        sb.append(this.repositoryIdentifier);
        sb.append(":");
        sb.append(this.getLocalIdentifier(nativeItem));
        return sb.toString();
    }

    public String getLocalIdentifier(Object nativeItem) {
        return (String)((HashMap)nativeItem).get("localIdentifier");
    }

    public String getDatestamp(Object nativeItem) throws IllegalArgumentException {
        return (String)((HashMap)nativeItem).get("lastModified");
    }

    public Iterator getSetSpecs(Object nativeItem) throws IllegalArgumentException {
        return (Iterator)((HashMap)nativeItem).get("setSpecs");
    }

    public Iterator getAbouts(Object nativeItem) throws IllegalArgumentException {
        return null;
    }

    public boolean isDeleted(Object nativeItem) throws IllegalArgumentException {
        return false;
    }

    public String quickCreate(Object nativeItem, String schemaLocation, String metadataPrefix) {
        try {
            String result = new String((byte[])((HashMap)nativeItem).get("recordBytes"), "UTF-8");
            if (result.startsWith("<?")) {
                int offset = result.indexOf("?>");
                result = result.substring(offset + 2);
            }
            return result;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

