/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tigris.subversion.svnclientadapter.AbstractClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineAnnotations;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineInfoPart;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineLogMessage;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotificationHandler;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineProperty;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineRemoteDirEntry;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineStatusPart;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineStatuses;
import org.tigris.subversion.svnclientadapter.commandline.Helper;
import org.tigris.subversion.svnclientadapter.commandline.SvnAdminCommandLine;
import org.tigris.subversion.svnclientadapter.commandline.SvnCommandLine;
import org.tigris.subversion.svnclientadapter.commandline.SvnMultiArgCommandLine;

public class CmdLineClientAdapter
extends AbstractClientAdapter {
    protected final CmdLineNotificationHandler notificationHandler;
    protected final SvnCommandLine _cmd;
    protected final SvnMultiArgCommandLine _cmdMulti;
    protected final SvnAdminCommandLine svnAdminCmd;
    protected String version = null;
    private static boolean availabilityCached = false;
    private static boolean available;
    private static String dirName;

    public CmdLineClientAdapter(CmdLineNotificationHandler cmdLineNotificationHandler) {
        this(cmdLineNotificationHandler, new SvnCommandLine("svn", cmdLineNotificationHandler), new SvnMultiArgCommandLine("svn", cmdLineNotificationHandler), new SvnAdminCommandLine("svnadmin", cmdLineNotificationHandler));
    }

    protected CmdLineClientAdapter(CmdLineNotificationHandler cmdLineNotificationHandler, SvnCommandLine svnCommandLine, SvnMultiArgCommandLine svnMultiArgCommandLine, SvnAdminCommandLine svnAdminCommandLine) {
        this.notificationHandler = cmdLineNotificationHandler;
        this._cmd = svnCommandLine;
        this._cmdMulti = svnMultiArgCommandLine;
        this.svnAdminCmd = svnAdminCommandLine;
    }

    public static boolean isAvailable() {
        if (!availabilityCached) {
            SvnCommandLine svnCommandLine = new SvnCommandLine("svn", new CmdLineNotificationHandler());
            try {
                String string = svnCommandLine.version();
                int n = string.indexOf(System.getProperty("line.separator"));
                string = string.substring(0, n);
                available = true;
                available &= string.indexOf("version 0.") == -1;
                available &= string.indexOf("version 1.0") == -1;
                available &= string.indexOf("version 1.1") == -1;
                available &= string.indexOf("version 1.2") == -1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                available = false;
            }
            availabilityCached = true;
        }
        return available;
    }

    public String getVersion() throws SVNClientException {
        if (this.version != null) {
            return this.version;
        }
        try {
            this.notificationHandler.disableLog();
            this.version = this._cmd.version();
            int n = this.version.indexOf(System.getProperty("line.separator"));
            String string = this.version = this.version.substring(0, n);
            return string;
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
        finally {
            this.notificationHandler.enableLog();
        }
    }

    public void addNotifyListener(ISVNNotifyListener iSVNNotifyListener) {
        this.notificationHandler.add(iSVNNotifyListener);
    }

    public void removeNotifyListener(ISVNNotifyListener iSVNNotifyListener) {
        this.notificationHandler.remove(iSVNNotifyListener);
    }

    private boolean isManaged(File file) {
        if (file.isDirectory()) {
            return this.isManagedDir(file.getParentFile()) || this.isManagedDir(file);
        }
        return this.isManagedDir(file.getParentFile());
    }

    private boolean isManagedDir(File file) {
        File file2 = new File(file, this.getAdminDirectoryName() + "/entries");
        return file2.exists();
    }

    public ISVNStatus[] getStatus(File[] fileArray) throws SVNClientException {
        int n;
        Object object;
        Object object2;
        ISVNStatus[] iSVNStatusArray = new ISVNStatus[fileArray.length];
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < fileArray.length; ++i) {
            object2 = fileArray[i];
            if (this.isManaged((File)object2)) {
                arrayList.add(CmdLineClientAdapter.toString(object2));
                continue;
            }
            iSVNStatusArray[i] = new SVNStatusUnversioned((File)object2, false);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        try {
            CmdLineStatusPart[] cmdLineStatusPartArray = this.getCmdStatuses(stringArray, false, true, false);
            object = new ArrayList<String>(cmdLineStatusPartArray.length);
            for (int i = 0; i < cmdLineStatusPartArray.length; ++i) {
                if (!cmdLineStatusPartArray[i].isManaged()) continue;
                object.add(cmdLineStatusPartArray[i].getFile().toString());
            }
            String string = this._cmd.info(object.toArray(new String[object.size()]));
            object2 = new CmdLineStatuses(string, cmdLineStatusPartArray);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
        for (n = 0; n < ((CmdLineStatuses)object2).size(); ++n) {
            object = ((CmdLineStatuses)object2).get(n);
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getAbsoluteFile().equals(object.getFile())) continue;
                iSVNStatusArray[i] = object;
            }
        }
        for (n = 0; n < iSVNStatusArray.length; ++n) {
            if (iSVNStatusArray[n] != null) continue;
            iSVNStatusArray[n] = new SVNStatusUnversioned(fileArray[n], false);
        }
        return iSVNStatusArray;
    }

    public ISVNStatus getSingleStatus(File file) throws SVNClientException {
        return this.getStatus(new File[]{file})[0];
    }

    private ISVNDirEntry[] getList(String string, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        try {
            byte[] byArray = this._cmd.list(string, CmdLineClientAdapter.toString(sVNRevision), bl);
            return CmdLineRemoteDirEntry.createDirEntries(byArray);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public ISVNDirEntry[] getList(SVNUrl sVNUrl, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        return this.getList(CmdLineClientAdapter.toString(sVNUrl), sVNRevision, bl);
    }

    public ISVNDirEntry[] getList(File file, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        return this.getList(CmdLineClientAdapter.toString(file), sVNRevision, bl);
    }

    public ISVNDirEntry getDirEntry(SVNUrl sVNUrl, SVNRevision sVNRevision) throws SVNClientException {
        ISVNDirEntry[] iSVNDirEntryArray = this.getList(sVNUrl.getParent(), sVNRevision, false);
        String string = sVNUrl.getLastPathSegment();
        for (int i = 0; i < iSVNDirEntryArray.length; ++i) {
            if (!iSVNDirEntryArray[i].getPath().equals(string)) continue;
            return iSVNDirEntryArray[i];
        }
        return null;
    }

    public ISVNDirEntry getDirEntry(File file, SVNRevision sVNRevision) throws SVNClientException {
        ISVNDirEntry[] iSVNDirEntryArray = this.getList(file.getParentFile(), sVNRevision, false);
        String string = file.getName();
        for (int i = 0; i < iSVNDirEntryArray.length; ++i) {
            if (!iSVNDirEntryArray[i].getPath().equals(string)) continue;
            return iSVNDirEntryArray[i];
        }
        return null;
    }

    public void remove(File[] fileArray, boolean bl) throws SVNClientException {
        String[] stringArray = new String[fileArray.length];
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                stringArray[i] = fileArray[i].toString();
            }
            this._cmd.delete(stringArray, null, bl);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void revert(File file, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this._cmd.revert(new String[]{CmdLineClientAdapter.toString(file)}, bl);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public InputStream getContent(SVNUrl sVNUrl, SVNRevision sVNRevision) throws SVNClientException {
        try {
            InputStream inputStream = this._cmd.cat(CmdLineClientAdapter.toString(sVNUrl), CmdLineClientAdapter.toString(sVNRevision));
            byte[] byArray = CmdLineClientAdapter.streamToByteArray(inputStream);
            return new ByteArrayInputStream(byArray);
        }
        catch (IOException iOException) {
            throw SVNClientException.wrapException(iOException);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public InputStream getContent(File file, SVNRevision sVNRevision) throws SVNClientException {
        try {
            InputStream inputStream = this._cmd.cat(CmdLineClientAdapter.toString(file), CmdLineClientAdapter.toString(sVNRevision));
            byte[] byArray = CmdLineClientAdapter.streamToByteArray(inputStream);
            return new ByteArrayInputStream(byArray);
        }
        catch (IOException iOException) {
            throw SVNClientException.wrapException(iOException);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void mkdir(SVNUrl sVNUrl, String string) throws SVNClientException {
        try {
            this._cmd.mkdir(CmdLineClientAdapter.toString(sVNUrl), string);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl) throws SVNClientException {
        return this.getLogMessages(sVNUrl, sVNRevision, sVNRevision2, false, bl, 0L);
    }

    public void remove(SVNUrl[] sVNUrlArray, String string) throws SVNClientException {
        String[] stringArray = new String[sVNUrlArray.length];
        for (int i = 0; i < sVNUrlArray.length; ++i) {
            stringArray[i] = sVNUrlArray[i].toString();
        }
        try {
            this._cmd.delete(stringArray, string, false);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void copy(SVNUrl sVNUrl, SVNUrl sVNUrl2, String string, SVNRevision sVNRevision) throws SVNClientException {
        try {
            this._cmd.copy(CmdLineClientAdapter.toString(sVNUrl), CmdLineClientAdapter.toString(sVNUrl2), string, CmdLineClientAdapter.toString(sVNRevision));
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void copy(File file, File file2) throws SVNClientException {
        try {
            this._cmd.copy(CmdLineClientAdapter.toString(file), CmdLineClientAdapter.toString(file2));
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
        for (int i = 0; i < 50 && !file2.exists(); ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void move(SVNUrl sVNUrl, SVNUrl sVNUrl2, String string, SVNRevision sVNRevision) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(new File("."));
            this._cmd.move(CmdLineClientAdapter.toString(sVNUrl), CmdLineClientAdapter.toString(sVNUrl2), string, CmdLineClientAdapter.toString(sVNRevision), false);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void move(File file, File file2, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File[]{file, file2}));
            this._cmd.move(CmdLineClientAdapter.toString(file), CmdLineClientAdapter.toString(file2), null, null, bl);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void setUsername(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this._cmd.setUsername(string);
    }

    public void setPassword(String string) {
        if (string == null) {
            return;
        }
        this._cmd.setPassword(string);
    }

    public void addDirectory(File file, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this._cmd.add(CmdLineClientAdapter.toString(file), bl);
        }
        catch (CmdLineException cmdLineException) {
            if (cmdLineException.getMessage().startsWith("svn: warning: ")) {
                return;
            }
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void addFile(File file) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this._cmd.add(CmdLineClientAdapter.toString(file), false);
        }
        catch (CmdLineException cmdLineException) {
            if (cmdLineException.getMessage().startsWith("svn: warning: ")) {
                return;
            }
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public long commit(File[] fileArray, String string, boolean bl) throws SVNClientException {
        return this.commit(fileArray, string, bl, false);
    }

    public long commit(File[] fileArray, String string, boolean bl, boolean bl2) throws SVNClientException {
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = CmdLineClientAdapter.toString(fileArray[i]);
        }
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(fileArray));
            this._cmd.checkin(stringArray, string, bl2);
            return this._cmd.getRevision();
        }
        catch (CmdLineException cmdLineException) {
            if ("".equals(cmdLineException.getMessage())) {
                return -1L;
            }
            if (cmdLineException.getMessage().startsWith("svn: Attempted to lock an already-locked dir")) {
                for (int i = 0; i < 50; ++i) {
                    try {
                        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(fileArray));
                        this._cmd.checkin(stringArray, string, bl2);
                        return this._cmd.getRevision();
                    }
                    catch (CmdLineException cmdLineException2) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
            }
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public long update(File file, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this._cmd.update(CmdLineClientAdapter.toString(file), CmdLineClientAdapter.toString(sVNRevision));
            return this._cmd.getRevision();
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public long[] update(File[] fileArray, SVNRevision sVNRevision, boolean bl, boolean bl2) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(fileArray[0]));
            this._cmdMulti.update(CmdLineClientAdapter.toString(fileArray), CmdLineClientAdapter.toString(sVNRevision));
            return this._cmdMulti.getRevisions();
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void checkout(SVNUrl sVNUrl, File file, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this._cmd.checkout(CmdLineClientAdapter.toString(sVNUrl), CmdLineClientAdapter.toString(file), CmdLineClientAdapter.toString(sVNRevision), bl);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public ISVNStatus[] getStatus(File file, boolean bl, boolean bl2) throws SVNClientException {
        return this.getStatus(file, bl, bl2, false);
    }

    protected CmdLineStatusPart[] getCmdStatuses(File[] fileArray, boolean bl, boolean bl2, boolean bl3) throws CmdLineException {
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = CmdLineClientAdapter.toString(fileArray[i]);
        }
        return this.getCmdStatuses(stringArray, bl, bl2, bl3);
    }

    protected CmdLineStatusPart[] getCmdStatuses(String[] stringArray, boolean bl, boolean bl2, boolean bl3) throws CmdLineException {
        if (stringArray.length == 0) {
            return new CmdLineStatusPart[0];
        }
        byte[] byArray = this._cmd.status(stringArray, bl, bl2, bl3);
        return CmdLineStatusPart.CmdLineStatusPartFromXml.createStatusParts(byArray);
    }

    private void diff(String string, SVNRevision sVNRevision, String string2, SVNRevision sVNRevision2, File file, boolean bl) throws SVNClientException {
        if (string2 == null) {
            string2 = string;
        }
        if (sVNRevision == null) {
            sVNRevision = SVNRevision.BASE;
        }
        if (sVNRevision2 == null) {
            sVNRevision2 = SVNRevision.WORKING;
        }
        try {
            InputStream inputStream = this._cmd.diff(string, CmdLineClientAdapter.toString(sVNRevision), string2, CmdLineClientAdapter.toString(sVNRevision2), bl);
            CmdLineClientAdapter.streamToFile(inputStream, file);
        }
        catch (IOException iOException) {
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void diff(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, File file3, boolean bl) throws SVNClientException {
        if (file == null) {
            file = new File(".");
        }
        this.diff(CmdLineClientAdapter.toString(file), sVNRevision, CmdLineClientAdapter.toString(file2), sVNRevision2, file3, bl);
    }

    public void diff(File file, File file2, boolean bl) throws SVNClientException {
        this.diff(file, null, null, null, file2, bl);
    }

    public void diff(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNUrl sVNUrl2, SVNRevision sVNRevision2, File file, boolean bl) throws SVNClientException {
        this.diff(CmdLineClientAdapter.toString(sVNUrl), sVNRevision, CmdLineClientAdapter.toString(sVNUrl2), sVNRevision2, file, bl);
    }

    public void diff(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, File file, boolean bl) throws SVNClientException {
        this.diff(sVNUrl, sVNRevision, sVNUrl, sVNRevision2, file, bl);
    }

    public ISVNProperty propertyGet(File file, String string) throws SVNClientException {
        try {
            InputStream inputStream = this._cmd.propget(CmdLineClientAdapter.toString(file), string);
            byte[] byArray = CmdLineClientAdapter.streamToByteArray(inputStream);
            if (byArray.length == 0) {
                return null;
            }
            return new CmdLineProperty(string, new String(byArray), file, byArray);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
        catch (IOException iOException) {
            throw SVNClientException.wrapException(iOException);
        }
    }

    public ISVNProperty propertyGet(SVNUrl sVNUrl, String string) throws SVNClientException {
        try {
            InputStream inputStream = this._cmd.propget(sVNUrl.toString(), string);
            byte[] byArray = CmdLineClientAdapter.streamToByteArray(inputStream);
            if (byArray.length == 0) {
                return null;
            }
            return new CmdLineProperty(string, new String(byArray), null, byArray);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
        catch (IOException iOException) {
            throw SVNClientException.wrapException(iOException);
        }
    }

    public void propertySet(File file, String string, File file2, boolean bl) throws SVNClientException, IOException {
        try {
            this._cmd.propsetFile(string, CmdLineClientAdapter.toString(file2), CmdLineClientAdapter.toString(file), bl);
            ISVNStatus[] iSVNStatusArray = this.getStatus(file, bl, false);
            for (int i = 0; i < iSVNStatusArray.length; ++i) {
                this.notificationHandler.notifyListenersOfChange(iSVNStatusArray[i].getFile().getAbsolutePath());
            }
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void propertyDel(File file, String string, boolean bl) throws SVNClientException {
        try {
            this._cmd.propdel(string, CmdLineClientAdapter.toString(file), bl);
            ISVNStatus[] iSVNStatusArray = this.getStatus(file, bl, false);
            for (int i = 0; i < iSVNStatusArray.length; ++i) {
                this.notificationHandler.notifyListenersOfChange(iSVNStatusArray[i].getFile().getAbsolutePath());
            }
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void setRevProperty(SVNUrl sVNUrl, SVNRevision.Number number, String string, String string2, boolean bl) throws SVNClientException {
        try {
            this._cmd.revpropset(string, string2, CmdLineClientAdapter.toString(sVNUrl), Long.toString(number.getNumber()), bl);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void mkdir(File file) throws SVNClientException {
        try {
            this._cmd.mkdir(CmdLineClientAdapter.toString(file));
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
        for (int i = 0; i < 50 && !file.exists(); ++i) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void doImport(File file, SVNUrl sVNUrl, String string, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this._cmd.importFiles(CmdLineClientAdapter.toString(file), CmdLineClientAdapter.toString(sVNUrl), string, bl);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void doExport(SVNUrl sVNUrl, File file, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        try {
            this._cmd.export(CmdLineClientAdapter.toString(sVNUrl), CmdLineClientAdapter.toString(file), CmdLineClientAdapter.toString(sVNRevision), bl);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void doExport(File file, File file2, boolean bl) throws SVNClientException {
        try {
            this._cmd.export(CmdLineClientAdapter.toString(file), CmdLineClientAdapter.toString(file2), null, bl);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void copy(File file, SVNUrl sVNUrl, String string) throws SVNClientException {
        try {
            this._cmd.copy(CmdLineClientAdapter.toString(file), CmdLineClientAdapter.toString(sVNUrl), string, null);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl) throws SVNClientException {
        return this.getLogMessages((Object)file, sVNRevision, sVNRevision2, false, bl, 0L);
    }

    public void copy(SVNUrl sVNUrl, File file, SVNRevision sVNRevision) throws SVNClientException {
        try {
            this._cmd.copy(CmdLineClientAdapter.toString(sVNUrl), CmdLineClientAdapter.toString(file), null, CmdLineClientAdapter.toString(sVNRevision));
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void propertySet(File file, String string, String string2, boolean bl) throws SVNClientException {
        try {
            this._cmd.propset(string, string2, CmdLineClientAdapter.toString(file), bl);
            ISVNStatus[] iSVNStatusArray = this.getStatus(file, bl, false);
            for (int i = 0; i < iSVNStatusArray.length; ++i) {
                this.notificationHandler.notifyListenersOfChange(iSVNStatusArray[i].getFile().getAbsolutePath());
            }
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    protected static String toString(Object object) {
        return object == null ? null : object.toString();
    }

    private ISVNLogMessage[] getLogMessages(Object object, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2, long l) throws SVNClientException {
        String string = CmdLineClientAdapter.toString(sVNRevision) + ":" + CmdLineClientAdapter.toString(sVNRevision2);
        try {
            byte[] byArray = bl2 ? this._cmd.logVerbose(CmdLineClientAdapter.toString(object), string, bl, l) : this._cmd.log(CmdLineClientAdapter.toString(object), string, bl, l);
            return CmdLineLogMessage.createLogMessages(byArray);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    private static void streamToFile(InputStream inputStream, File file) throws IOException {
        try {
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            while ((n = inputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            fileOutputStream.close();
            inputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private static byte[] streamToByteArray(InputStream inputStream) throws IOException {
        int n;
        Vector<Byte> vector = new Vector<Byte>(1024);
        while ((n = inputStream.read()) != -1) {
            vector.add(new Byte((byte)n));
        }
        byte[] byArray = new byte[vector.size()];
        for (int i = 0; i < byArray.length; ++i) {
            Byte by = (Byte)vector.get(i);
            byArray[i] = by;
        }
        return byArray;
    }

    protected ISVNAnnotations annotate(String string, SVNRevision sVNRevision, SVNRevision sVNRevision2) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(25);
            if (sVNRevision == null) {
                sVNRevision = new SVNRevision.Number(1L);
            }
            if (sVNRevision2 == null) {
                sVNRevision2 = SVNRevision.HEAD;
            }
            byte[] byArray = this._cmd.annotate(string, CmdLineClientAdapter.toString(sVNRevision), CmdLineClientAdapter.toString(sVNRevision2));
            InputStream inputStream = this._cmd.cat(string, sVNRevision2.toString());
            return CmdLineAnnotations.createFromXml(byArray, inputStream);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public ISVNAnnotations annotate(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2) throws SVNClientException {
        return this.annotate(CmdLineClientAdapter.toString(sVNUrl), sVNRevision, sVNRevision2);
    }

    public ISVNAnnotations annotate(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2) throws SVNClientException {
        return this.annotate(CmdLineClientAdapter.toString(file), sVNRevision, sVNRevision2);
    }

    public ISVNProperty[] getProperties(File file) throws SVNClientException {
        try {
            String string = this._cmd.proplist(CmdLineClientAdapter.toString(file), false);
            LinkedList<ISVNProperty> linkedList = new LinkedList<ISVNProperty>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, Helper.NEWLINE);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.startsWith("Properties on '")) continue;
                String string3 = string2.substring(2);
                linkedList.add(this.propertyGet(file, string3));
            }
            return linkedList.toArray(new ISVNProperty[0]);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public ISVNProperty[] getProperties(SVNUrl sVNUrl) throws SVNClientException {
        try {
            String string = this._cmd.proplist(sVNUrl.toString(), false);
            LinkedList<ISVNProperty> linkedList = new LinkedList<ISVNProperty>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, Helper.NEWLINE);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.startsWith("Properties on '")) continue;
                String string3 = string2.substring(2);
                linkedList.add(this.propertyGet(sVNUrl, string3));
            }
            return linkedList.toArray(new ISVNProperty[0]);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void resolved(File file) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this._cmd.resolved(new String[]{CmdLineClientAdapter.toString(file)}, false);
            this.notificationHandler.notifyListenersOfChange(file.getAbsolutePath());
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void createRepository(File file, String string) throws SVNClientException {
        try {
            this.svnAdminCmd.create(CmdLineClientAdapter.toString(file), string);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public ISVNStatus[] getStatus(File file, boolean bl, boolean bl2, boolean bl3) throws SVNClientException {
        try {
            CmdLineStatusPart[] cmdLineStatusPartArray = this.getCmdStatuses(new File[]{file}, bl, bl2, bl3);
            ArrayList<String> arrayList = new ArrayList<String>(cmdLineStatusPartArray.length);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (int i = 0; i < cmdLineStatusPartArray.length; ++i) {
                if (cmdLineStatusPartArray[i].isManaged()) {
                    arrayList.add(cmdLineStatusPartArray[i].getFile().toString());
                    continue;
                }
                arrayList2.add(new Integer(i));
            }
            String string = this._cmd.info(arrayList.toArray(new String[arrayList.size()]));
            String[] stringArray = CmdLineInfoPart.parseInfoParts(string);
            CmdLineInfoPart[] cmdLineInfoPartArray = new CmdLineInfoPart[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                cmdLineInfoPartArray[i] = new CmdLineInfoPart(stringArray[i]);
            }
            CmdLineInfoPart[] cmdLineInfoPartArray2 = new CmdLineInfoPart[cmdLineStatusPartArray.length];
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                cmdLineInfoPartArray2[n.intValue()] = CmdLineInfoPart.createUnversioned(null);
            }
            block5: for (int i = 0; i < cmdLineInfoPartArray.length; ++i) {
                for (int j = i; j < cmdLineInfoPartArray2.length; ++j) {
                    if (cmdLineInfoPartArray2[j] != null) continue;
                    cmdLineInfoPartArray2[j] = cmdLineInfoPartArray[i];
                    continue block5;
                }
            }
            CmdLineStatuses cmdLineStatuses = new CmdLineStatuses(cmdLineInfoPartArray, cmdLineStatusPartArray);
            return cmdLineStatuses.toArray();
        }
        catch (CmdLineException cmdLineException) {
            if (cmdLineException.getMessage().trim().matches("svn:.*is not a working copy.*")) {
                return new ISVNStatus[]{new SVNStatusUnversioned(file)};
            }
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void cancelOperation() throws SVNClientException {
        this.notificationHandler.logMessage("Warning: operation canceled.");
        this._cmd.stopProcess();
    }

    public ISVNInfo getInfoFromWorkingCopy(File file) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            CmdLineStatusPart[] cmdLineStatusPartArray = this.getCmdStatuses(new File[]{file}, false, true, false);
            if (cmdLineStatusPartArray.length > 0 && cmdLineStatusPartArray[0].isManaged()) {
                String string = this._cmd.info(new String[]{CmdLineClientAdapter.toString(file)});
                return new CmdLineInfoPart(string);
            }
            return CmdLineInfoPart.createUnversioned(file.getPath());
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public ISVNInfo getInfo(File file) throws SVNClientException {
        return this.getInfoFromWorkingCopy(file);
    }

    public ISVNInfo getInfo(SVNUrl sVNUrl) throws SVNClientException {
        return this.getInfo(new SVNUrl[]{sVNUrl});
    }

    public ISVNInfo getInfo(SVNUrl[] sVNUrlArray) throws SVNClientException {
        try {
            String[] stringArray = new String[sVNUrlArray.length];
            for (int i = 0; i < sVNUrlArray.length; ++i) {
                stringArray[i] = CmdLineClientAdapter.toString(sVNUrlArray[i]);
            }
            String string = this._cmd.info(stringArray);
            return new CmdLineInfoPart(string);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public SVNUrl getRepositoryRoot(SVNUrl sVNUrl) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    public void switchToUrl(File file, SVNUrl sVNUrl, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this._cmd.switchUrl(CmdLineClientAdapter.toString(file), CmdLineClientAdapter.toString(sVNUrl), CmdLineClientAdapter.toString(sVNRevision));
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void setConfigDirectory(File file) throws SVNClientException {
        this._cmd.setConfigDirectory(CmdLineClientAdapter.toString(file));
    }

    public void cleanup(File file) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this._cmd.cleanup(CmdLineClientAdapter.toString(file));
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void merge(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNUrl sVNUrl2, SVNRevision sVNRevision2, File file, boolean bl, boolean bl2) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this._cmd.merge(CmdLineClientAdapter.toString(sVNUrl), CmdLineClientAdapter.toString(sVNRevision), CmdLineClientAdapter.toString(sVNUrl2), CmdLineClientAdapter.toString(sVNRevision2), CmdLineClientAdapter.toString(file), bl, bl2, false);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void merge(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNUrl sVNUrl2, SVNRevision sVNRevision2, File file, boolean bl, boolean bl2, boolean bl3) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(file));
            this._cmd.merge(CmdLineClientAdapter.toString(sVNUrl), CmdLineClientAdapter.toString(sVNRevision), CmdLineClientAdapter.toString(sVNUrl2), CmdLineClientAdapter.toString(sVNRevision2), CmdLineClientAdapter.toString(file), bl, bl2, bl3);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void lock(SVNUrl[] sVNUrlArray, String string, boolean bl) throws SVNClientException {
        try {
            this._cmd.lock(sVNUrlArray, string, bl);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void unlock(SVNUrl[] sVNUrlArray, boolean bl) throws SVNClientException {
        try {
            this._cmd.unlock(sVNUrlArray, bl);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void lock(File[] fileArray, String string, boolean bl) throws SVNClientException {
        int i;
        Object[] objectArray = new String[fileArray.length];
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            objectArray[i2] = CmdLineClientAdapter.toString(fileArray[i2]);
        }
        try {
            try {
                this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(fileArray));
                this._cmd.lock(objectArray, string, bl);
            }
            catch (CmdLineException cmdLineException) {
                throw SVNClientException.wrapException(cmdLineException);
            }
            Object var7_7 = null;
            i = 0;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            int i3 = 0;
            while (true) {
                if (i3 >= objectArray.length) {
                    throw throwable;
                }
                this.notificationHandler.notifyListenersOfChange((String)objectArray[i3]);
                ++i3;
            }
        }
        while (i < objectArray.length) {
            this.notificationHandler.notifyListenersOfChange((String)objectArray[i]);
            ++i;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unlock(File[] fileArray, boolean bl) throws SVNClientException {
        int i;
        Object[] objectArray = new String[fileArray.length];
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            objectArray[i2] = CmdLineClientAdapter.toString(fileArray[i2]);
        }
        try {
            try {
                this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(fileArray));
                this._cmd.unlock(objectArray, bl);
            }
            catch (CmdLineException cmdLineException) {
                throw SVNClientException.wrapException(cmdLineException);
            }
            Object var6_6 = null;
            i = 0;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            int i3 = 0;
            while (true) {
                if (i3 >= objectArray.length) {
                    throw throwable;
                }
                this.notificationHandler.notifyListenersOfChange((String)objectArray[i3]);
                ++i3;
            }
        }
        while (i < objectArray.length) {
            this.notificationHandler.notifyListenersOfChange((String)objectArray[i]);
            ++i;
        }
        return;
    }

    public String getAdminDirectoryName() {
        if (dirName == null) {
            if (CmdLineClientAdapter.isOsWindows()) {
                dirName = CmdLineClientAdapter.getEnvironmentVariable("SVN_ASP_DOT_NET_HACK");
            }
            dirName = dirName != null ? "_svn" : ".svn";
        }
        return dirName;
    }

    public boolean isAdminDirectory(String string) {
        return this.getAdminDirectoryName().equals(string) || ".svn".equals(string);
    }

    public static String getEnvironmentVariable(String string) {
        try {
            return System.getenv(string);
        }
        catch (Error error) {
            try {
                return CmdLineClientAdapter.getEnvVars().getProperty(string);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    public static Properties getEnvVars() throws Throwable {
        Process process = null;
        Properties properties = new Properties();
        Runtime runtime = Runtime.getRuntime();
        process = CmdLineClientAdapter.isOsWindows() ? (System.getProperty("os.name").toLowerCase().indexOf("windows 9") > -1 ? runtime.exec("command.com /c set") : runtime.exec("cmd.exe /c set")) : runtime.exec("env");
        if (process != null) {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(61);
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                properties.setProperty(string2, string3);
            }
        }
        return properties;
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2, long l) throws SVNClientException {
        return this.getLogMessages((Object)file, sVNRevision, sVNRevision2, bl, bl2, l);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl, boolean bl2, long l) throws SVNClientException {
        return this.getLogMessages(sVNUrl, sVNRevision2, sVNRevision3, bl, bl2, l);
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2) throws SVNClientException {
        return this.getLogMessages((Object)file, sVNRevision, sVNRevision2, bl, bl2, 0L);
    }

    public void relocate(String string, String string2, String string3, boolean bl) throws SVNClientException {
        try {
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(new File(string3)));
            this._cmd.relocate(string, string2, string3, bl);
        }
        catch (CmdLineException cmdLineException) {
            throw SVNClientException.wrapException(cmdLineException);
        }
    }

    public void diff(File file, SVNUrl sVNUrl, SVNRevision sVNRevision, File file2, boolean bl) throws SVNClientException {
        this.diff(CmdLineClientAdapter.toString(file), null, CmdLineClientAdapter.toString(sVNUrl) + "@" + CmdLineClientAdapter.toString(sVNRevision), null, file2, bl);
    }
}

