/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.util;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.dataone.configuration.Settings;

public class PerformanceLogger {
    private static PerformanceLogger self = new PerformanceLogger();
    private static final Level LOGGING_LEVEL = Level.INFO;
    private static Logger perfLogger;
    private static boolean enabled;

    private PerformanceLogger() {
        enabled = Settings.getConfiguration().getBoolean("dataone.indexing.performance.logging.enabled", Boolean.FALSE);
        perfLogger = Logger.getLogger((String)"performanceStats");
        if (perfLogger == null) {
            Logger defaultLogger = Logger.getLogger((String)PerformanceLogger.class.getName());
            defaultLogger.error((Object)"Unable to create Logger for performanceStats appender!");
            enabled = false;
        }
    }

    public static PerformanceLogger getInstance() {
        return self;
    }

    public void log(String id, long milliseconds) {
        if (enabled) {
            this.log("" + id + ", " + milliseconds);
        }
    }

    public void log(String message) {
        if (enabled) {
            perfLogger.log((Priority)LOGGING_LEVEL, (Object)message);
        }
    }
}

